/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import weka.gui.ensembleLibraryEditor.tree.NumberClassNotFoundException;
import weka.gui.ensembleLibraryEditor.tree.NumberNode;
import weka.gui.ensembleLibraryEditor.tree.PropertyNode;

public class NumberNodeEditor
extends JPanel
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3486848815982334460L;
    private JButton m_IteratorButton;
    private JFormattedTextField m_NumberField;
    private JCheckBox m_SelectedCheckBox;
    private JLabel m_Label;
    private Color textForeground;
    private Color textBackground;
    private NumberNode m_Node;

    public NumberNodeEditor(NumberNode numberNode) {
        this.m_Node = numberNode;
        String string = numberNode.getText();
        Number number = numberNode.getValue();
        int n = numberNode.getIteratorType();
        boolean bl = numberNode.getCheckable();
        boolean bl2 = numberNode.getSelected();
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
        this.setForeground(this.textForeground);
        this.setBackground(this.textBackground);
        Font font = UIManager.getFont("Tree.font");
        if (bl) {
            this.m_SelectedCheckBox = new JCheckBox();
            this.m_SelectedCheckBox.setSelected(bl2);
            this.m_SelectedCheckBox.setForeground(this.textForeground);
            this.m_SelectedCheckBox.setBackground(this.textBackground);
            this.m_SelectedCheckBox.addItemListener(this);
            this.add(this.m_SelectedCheckBox);
        }
        this.m_Label = new JLabel(string);
        if (font != null) {
            this.m_Label.setFont(font);
        }
        this.m_Label.setForeground(this.textForeground);
        this.m_Label.setBackground(this.textBackground);
        this.add(this.m_Label);
        if (n != 0) {
            this.updateIteratorButton();
            this.m_IteratorButton.setForeground(this.textForeground);
            this.m_IteratorButton.setBackground(this.textBackground);
            this.add(this.m_IteratorButton);
        }
        NumberFormat numberFormat = null;
        try {
            numberFormat = numberNode.getNumberFormat();
        }
        catch (NumberClassNotFoundException numberClassNotFoundException) {
            numberClassNotFoundException.printStackTrace();
        }
        this.m_NumberField = new JFormattedTextField(numberFormat);
        this.m_NumberField.setValue(number);
        this.m_NumberField.setColumns(10);
        this.m_NumberField.setForeground(this.textForeground);
        this.m_NumberField.setBackground(this.textBackground);
        this.m_NumberField.addPropertyChangeListener(this);
        this.add(this.m_NumberField);
        if (!bl2 && bl) {
            this.m_Label.setEnabled(false);
            if (this.m_IteratorButton != null) {
                this.m_IteratorButton.setEnabled(false);
            }
            this.m_NumberField.setEnabled(false);
        }
    }

    public void setActionListener(ActionListener actionListener) {
        if (this.m_IteratorButton != null) {
            this.m_IteratorButton.addActionListener(actionListener);
        }
    }

    public void setItemListener(ItemListener itemListener) {
        if (this.m_SelectedCheckBox != null) {
            this.m_SelectedCheckBox.addItemListener(itemListener);
        }
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_NumberField != null) {
            this.m_NumberField.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private void updateIteratorButton() {
        if (this.m_Node.getIteratorType() == 2) {
            this.m_IteratorButton = new JButton("+=");
            this.m_IteratorButton.addActionListener(this);
        } else if (this.m_Node.getIteratorType() == 1) {
            this.m_IteratorButton = new JButton("*=");
            this.m_IteratorButton.addActionListener(this);
        }
        this.m_IteratorButton.repaint();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_Node.getIteratorType() == 2) {
            this.m_Node.setIteratorType(1);
            try {
                if (this.m_Node.getValue().equals(this.m_Node.getOneValue())) {
                    this.m_Node.setValue(this.m_Node.getTwoValue());
                    this.updateIteratorButton();
                }
            }
            catch (NumberClassNotFoundException numberClassNotFoundException) {
                numberClassNotFoundException.printStackTrace();
            }
        } else if (this.m_Node.getIteratorType() == 1) {
            this.m_Node.setIteratorType(2);
            try {
                if (this.m_Node.getValue().equals(this.m_Node.getTwoValue())) {
                    this.m_Node.setValue(this.m_Node.getOneValue());
                    this.updateIteratorButton();
                }
            }
            catch (NumberClassNotFoundException numberClassNotFoundException) {
                numberClassNotFoundException.printStackTrace();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            PropertyNode propertyNode = (PropertyNode)this.m_Node.getParent();
            if (propertyNode.canSelect(this.m_Node)) {
                this.m_Node.setSelected(true);
                this.m_Label.setEnabled(true);
                if (this.m_IteratorButton != null) {
                    this.m_IteratorButton.setEnabled(true);
                }
                this.m_NumberField.setEnabled(true);
            } else {
                this.m_SelectedCheckBox.setSelected(false);
            }
        } else if (itemEvent.getStateChange() == 2) {
            PropertyNode propertyNode = (PropertyNode)this.m_Node.getParent();
            if (propertyNode.canDeselect(this.m_Node)) {
                this.m_Node.setSelected(false);
                this.m_Label.setEnabled(false);
                if (this.m_IteratorButton != null) {
                    this.m_IteratorButton.setEnabled(false);
                }
                this.m_NumberField.setEnabled(false);
            } else {
                this.m_SelectedCheckBox.setSelected(true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof JFormattedTextField && propertyChangeEvent.getPropertyName().equals("value") && ((JFormattedTextField)propertyChangeEvent.getSource()).getValue() != null) {
            Number number = null;
            Number number2 = this.m_Node.getValue();
            JFormattedTextField jFormattedTextField = (JFormattedTextField)propertyChangeEvent.getSource();
            Number number3 = (Number)jFormattedTextField.getValue();
            if (number2 instanceof Double) {
                number = new Double(NumberNode.roundDouble(number3.doubleValue()));
            } else if (number2 instanceof Integer) {
                number = new Integer(number3.intValue());
            } else if (number2 instanceof Float) {
                number = new Float(NumberNode.roundFloat(number3.floatValue()));
            } else if (number2 instanceof Long) {
                number = new Long(number3.longValue());
            } else {
                try {
                    throw new NumberClassNotFoundException(number2.getClass() + " not currently supported.");
                }
                catch (NumberClassNotFoundException numberClassNotFoundException) {
                    numberClassNotFoundException.printStackTrace();
                }
            }
            jFormattedTextField.setValue(number);
            this.m_Node.setValue(number);
        }
    }
}

