/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;

public class Agrawal
extends ClassificationGenerator
implements TechnicalInformationHandler {
    static final long serialVersionUID = 2254651939636143025L;
    protected static ClassFunction[] builtInFunctions = new ClassFunction[]{new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            if (n < 40 || 60 <= n) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            if (n < 40) {
                if (50000.0 <= d && d <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (n < 60) {
                if (75000.0 <= d && d <= 125000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= d && d <= 75000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            if (n < 40) {
                if (n2 == 0 || n2 == 1) {
                    return 0L;
                }
                return 1L;
            }
            if (n < 60) {
                if (n2 == 1 || n2 == 2 || n2 == 3) {
                    return 0L;
                }
                return 1L;
            }
            if (n2 == 2 || n2 == 3 || n2 == 4) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            if (n < 40) {
                if (n2 == 0 || n2 == 1) {
                    if (25000.0 <= d && d <= 75000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (50000.0 <= d && d <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (n < 60) {
                if (n2 == 1 || n2 == 2 || n2 == 3) {
                    if (50000.0 <= d && d <= 100000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (75000.0 <= d && d <= 125000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (n2 == 2 || n2 == 3 || n2 == 4) {
                if (50000.0 <= d && d <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= d && d <= 75000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            if (n < 40) {
                if (50000.0 <= d && d <= 100000.0) {
                    if (100000.0 <= d4 && d4 <= 300000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (200000.0 <= d4 && d4 <= 400000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (n < 60) {
                if (75000.0 <= d && d <= 125000.0) {
                    if (200000.0 <= d4 && d4 <= 400000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (300000.0 <= d4 && d4 <= 500000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= d && d <= 75000.0) {
                if (300000.0 <= d4 && d4 <= 500000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (100000.0 <= d4 && d4 <= 300000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            double d5 = d + d2;
            if (n < 40) {
                if (50000.0 <= d5 && d5 <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (n < 60) {
                if (75000.0 <= d5 && d5 <= 125000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= d5 && d5 <= 75000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            double d5 = 2.0 * (d + d2) / 3.0 - d4 / 5.0 - 20000.0;
            return d5 > 0.0 ? 0L : 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            double d5 = 2.0 * (d + d2) / 3.0 - 5000.0 * (double)n2 - 20000.0;
            return d5 > 0.0 ? 0L : 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            double d5 = 2.0 * (d + d2) / 3.0 - 5000.0 * (double)n2 - d4 / 5.0 - 10000.0;
            return d5 > 0.0 ? 0L : 1L;
        }
    }, new ClassFunction(){

        public long determineClass(double d, double d2, int n, int n2, int n3, int n4, double d3, int n5, double d4) {
            double d5;
            double d6 = 0.0;
            if (n5 >= 20) {
                d6 = d3 * ((double)n5 - 20.0) / 10.0;
            }
            return (d5 = 2.0 * (d + d2) / 3.0 - 5000.0 * (double)n2 + d6 / 5.0 - 10000.0) > 0.0 ? 0L : 1L;
        }
    }};
    public static final int FUNCTION_1 = 1;
    public static final int FUNCTION_2 = 2;
    public static final int FUNCTION_3 = 3;
    public static final int FUNCTION_4 = 4;
    public static final int FUNCTION_5 = 5;
    public static final int FUNCTION_6 = 6;
    public static final int FUNCTION_7 = 7;
    public static final int FUNCTION_8 = 8;
    public static final int FUNCTION_9 = 9;
    public static final int FUNCTION_10 = 10;
    public static final Tag[] FUNCTION_TAGS = new Tag[]{new Tag(1, "Function 1"), new Tag(2, "Function 2"), new Tag(3, "Function 3"), new Tag(4, "Function 4"), new Tag(5, "Function 5"), new Tag(6, "Function 6"), new Tag(7, "Function 7"), new Tag(8, "Function 8"), new Tag(9, "Function 9"), new Tag(10, "Function 10")};
    protected int m_Function;
    protected boolean m_BalanceClass;
    protected double m_PerturbationFraction;
    protected boolean m_nextClassShouldBeZero;
    protected double m_lastLabel;

    public Agrawal() {
        this.setFunction(this.defaultFunction());
        this.setBalanceClass(this.defaultBalanceClass());
        this.setPerturbationFraction(this.defaultPerturbationFraction());
    }

    public String globalInfo() {
        return "Generates a people database and is based on the paper by Agrawal et al.:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "R. Agrawal and T. Imielinski and A. Swami");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1993");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Database Mining: A Performance Perspective");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "5");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "6");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "914-925");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "Special issue on Learning and Discovery in Knowledge-Based Databases");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://www.almaden.ibm.com/software/quest/Publications/ByDate.html");
        technicalInformation.setValue(TechnicalInformation.Field.PDF, "http://www.almaden.ibm.com/software/quest/Publications/papers/tkde93.pdf");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.add(new Option("\tThe function to use for generating the data. (default " + this.defaultFunction().getSelectedTag().getID() + ")", "F", 1, "-F <num>"));
        vector.add(new Option("\tWhether to balance the class.", "B", 0, "-B"));
        vector.add(new Option("\tThe perturbation factor. (default " + this.defaultPerturbationFraction() + ")", "P", 1, "-P <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('F', stringArray);
        if (string.length() != 0) {
            this.setFunction(new SelectedTag(Integer.parseInt(string), FUNCTION_TAGS));
        } else {
            this.setFunction(this.defaultFunction());
        }
        this.setBalanceClass(Utils.getFlag('B', stringArray));
        string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setPerturbationFraction(Double.parseDouble(string));
        } else {
            this.setPerturbationFraction(this.defaultPerturbationFraction());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-F");
        vector.add("" + this.m_Function);
        if (this.getBalanceClass()) {
            vector.add("-B");
        }
        vector.add("-P");
        vector.add("" + this.getPerturbationFraction());
        return vector.toArray(new String[vector.size()]);
    }

    protected SelectedTag defaultFunction() {
        return new SelectedTag(1, FUNCTION_TAGS);
    }

    public SelectedTag getFunction() {
        return new SelectedTag(this.m_Function, FUNCTION_TAGS);
    }

    public void setFunction(SelectedTag selectedTag) {
        if (selectedTag.getTags() == FUNCTION_TAGS) {
            this.m_Function = selectedTag.getSelectedTag().getID();
        }
    }

    public String functionTipText() {
        return "The function to use for generating the data.";
    }

    protected boolean defaultBalanceClass() {
        return false;
    }

    public boolean getBalanceClass() {
        return this.m_BalanceClass;
    }

    public void setBalanceClass(boolean bl) {
        this.m_BalanceClass = bl;
    }

    public String balanceClassTipText() {
        return "Whether to balance the class.";
    }

    protected double defaultPerturbationFraction() {
        return 0.05;
    }

    public double getPerturbationFraction() {
        return this.m_PerturbationFraction;
    }

    public void setPerturbationFraction(double d) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new IllegalArgumentException("Perturbation fraction must be in [0,1] (provided: " + d + ")!");
        }
        this.m_PerturbationFraction = d;
    }

    public String perturbationFractionTipText() {
        return "The perturbation fraction: 0 <= fraction <= 1.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    public Instances defineDataFormat() throws Exception {
        int n;
        this.m_Random = new Random(this.getSeed());
        this.m_nextClassShouldBeZero = true;
        this.m_lastLabel = Double.NaN;
        this.setNumExamplesAct(this.getNumExamples());
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Attribute("salary"));
        fastVector.addElement(new Attribute("commission"));
        FastVector fastVector2 = new FastVector();
        fastVector.addElement(new Attribute("age"));
        fastVector2 = new FastVector();
        for (n = 0; n < 5; ++n) {
            fastVector2.addElement("" + n);
        }
        fastVector.addElement(new Attribute("elevel", fastVector2));
        fastVector2 = new FastVector();
        for (n = 1; n <= 20; ++n) {
            fastVector2.addElement("" + n);
        }
        fastVector.addElement(new Attribute("car", fastVector2));
        fastVector2 = new FastVector();
        for (n = 0; n < 9; ++n) {
            fastVector2.addElement("" + n);
        }
        fastVector.addElement(new Attribute("zipcode", fastVector2));
        fastVector.addElement(new Attribute("hvalue"));
        fastVector.addElement(new Attribute("hyears"));
        fastVector.addElement(new Attribute("loan"));
        fastVector2 = new FastVector();
        for (n = 0; n < 2; ++n) {
            fastVector2.addElement("" + n);
        }
        fastVector.addElement(new Attribute("group", fastVector2));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), fastVector, 0);
        return this.m_DatasetFormat;
    }

    protected double perturbValue(double d, double d2, double d3) {
        return this.perturbValue(d, d3 - d2, d2, d3);
    }

    protected double perturbValue(double d, double d2, double d3, double d4) {
        if ((d += d2 * (2.0 * (this.getRandom().nextDouble() - 0.5)) * this.getPerturbationFraction()) < d3) {
            d = d3;
        } else if (d > d4) {
            d = d4;
        }
        return d;
    }

    public Instance generateExample() throws Exception {
        Instance instance = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        ClassFunction classFunction = builtInFunctions[this.m_Function - 1];
        while (!bl) {
            d = 20000.0 + 130000.0 * random.nextDouble();
            d2 = d >= 75000.0 ? 0.0 : 10000.0 + 65000.0 * random.nextDouble();
            n = 20 + random.nextInt(61);
            n2 = random.nextInt(5);
            n3 = 1 + random.nextInt(20);
            n4 = random.nextInt(9);
            d3 = (9.0 - (double)n4) * 100000.0 * (0.5 + random.nextDouble());
            n5 = 1 + random.nextInt(30);
            d4 = random.nextDouble() * 500000.0;
            this.m_lastLabel = classFunction.determineClass(d, d2, n, n2, n3, n4, d3, n5, d4);
            if (!this.getBalanceClass()) {
                bl = true;
                continue;
            }
            if ((!this.m_nextClassShouldBeZero || this.m_lastLabel != 0.0) && (this.m_nextClassShouldBeZero || this.m_lastLabel != 1.0)) continue;
            bl = true;
            this.m_nextClassShouldBeZero = !this.m_nextClassShouldBeZero;
        }
        if (this.getPerturbationFraction() > 0.0) {
            d = this.perturbValue(d, 20000.0, 150000.0);
            if (d2 > 0.0) {
                d2 = this.perturbValue(d2, 10000.0, 75000.0);
            }
            n = (int)Math.round(this.perturbValue(n, 20.0, 80.0));
            d3 = this.perturbValue(d3, (9.0 - (double)n4) * 100000.0, 0.0, 135000.0);
            n5 = (int)Math.round(this.perturbValue(n5, 1.0, 30.0));
            d4 = this.perturbValue(d4, 0.0, 500000.0);
        }
        double[] dArray = new double[this.m_DatasetFormat.numAttributes()];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = n;
        dArray[3] = n2;
        dArray[4] = n3 - 1;
        dArray[5] = n4;
        dArray[6] = d3;
        dArray[7] = n5;
        dArray[8] = d4;
        dArray[9] = this.m_lastLabel;
        instance = new Instance(1.0, dArray);
        instance.setDataset(this.m_DatasetFormat);
        return instance;
    }

    public Instances generateExamples() throws Exception {
        Instances instances = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            instances.add(this.generateExample());
        }
        return instances;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] stringArray) {
        Agrawal.runDataGenerator(new Agrawal(), stringArray);
    }

    protected static interface ClassFunction {
        public long determineClass(double var1, double var3, int var5, int var6, int var7, int var8, double var9, int var11, double var12);
    }
}

