/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.estimators.EstimatorUtils;
import weka.estimators.IncrementalEstimator;

public abstract class Estimator
implements Cloneable,
Serializable,
OptionHandler,
CapabilitiesHandler,
RevisionHandler {
    static final long serialVersionUID = -5902411487362274342L;
    private boolean m_Debug = false;
    protected double m_classValueIndex = -1.0;
    protected boolean m_noClass = true;

    public void addValue(double d, double d2) {
        try {
            throw new Exception("Method to add single value is not implemented!\nEstimator should implement IncrementalEstimator.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void addValues(Instances instances, int n) throws Exception {
        this.getCapabilities().testWithFail(instances);
        double[] dArray = new double[2];
        try {
            EstimatorUtils.getMinMax(instances, n, dArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
        double d = dArray[0];
        double d2 = dArray[1];
        this.addValues(instances, n, d, d2, 1.0);
    }

    public void addValues(Instances instances, int n, double d, double d2, double d3) throws Exception {
        int n2 = instances.numInstances();
        for (int i = 1; i < n2; ++i) {
            this.addValue(instances.instance(i).value(n), 1.0);
        }
    }

    public void addValues(Instances instances, int n, int n2, int n3) throws Exception {
        this.m_noClass = false;
        this.getCapabilities().testWithFail(instances);
        double[] dArray = new double[2];
        try {
            EstimatorUtils.getMinMax(instances, n, dArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
        double d = dArray[0];
        double d2 = dArray[1];
        Instances instances2 = new Instances(instances, 0);
        double d3 = this.getInstancesFromClass(instances, n, n2, n3, instances2);
        if (instances2.numInstances() == 0) {
            return;
        }
        this.addValues(instances, n, d, d2, d3);
    }

    public void addValues(Instances instances, int n, int n2, int n3, double d, double d2) throws Exception {
        Instances instances2 = new Instances(instances, 0);
        double d3 = this.getInstancesFromClass(instances, n, n2, n3, instances2);
        if (instances2.numInstances() == 0) {
            return;
        }
        this.addValues(instances, n, d, d2, d3);
    }

    private double getInstancesFromClass(Instances instances, int n, int n2, double d, Instances instances2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instances.instance(i).isMissing(n)) continue;
            ++n3;
            if (instances.instance(i).value(n2) != d) continue;
            instances2.add(instances.instance(i));
            ++n4;
        }
        Double d2 = new Double((double)n4 / (double)n3);
        return d2;
    }

    public abstract double getProbability(double var1);

    public static void buildEstimator(Estimator estimator, String[] stringArray, boolean bl) throws Exception {
        boolean bl2 = false;
        Builder builder = new Builder();
        try {
            Estimator.setGeneralOptions(builder, estimator, stringArray);
            if (estimator instanceof OptionHandler) {
                estimator.setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            Estimator.buildEstimator(estimator, builder.m_instances, builder.m_attrIndex, builder.m_classIndex, builder.m_classValueIndex, bl);
        }
        catch (Exception exception) {
            Object object;
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            String string = "";
            if (estimator instanceof OptionHandler) {
                string = string + "\nEstimator options:\n\n";
                object = estimator.listOptions();
                while (object.hasMoreElements()) {
                    Option option = (Option)object.nextElement();
                    string = string + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-i <file>\n\tThe name of the file containing input instances.\n\tIf not supplied then instances will be read from stdin.\n-a <attribute index>\n\tThe number of the attribute the probability distribution\n\testimation is done for.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n-c <class index>\n\tIf class value index is set, this attribute is taken as class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then last is default.\n-v <class value index>\n\tIf value is different to -1, select instances of this class value.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then all instances are taken.\n";
            throw new Exception('\n' + exception.getMessage() + string + (String)object);
        }
    }

    public static void buildEstimator(Estimator estimator, Instances instances, int n, int n2, int n3, boolean bl) throws Exception {
        if (!bl) {
            if (n3 == -1) {
                estimator.addValues(instances, n);
            } else {
                estimator.addValues(instances, n, n2, n3);
            }
        } else {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                ((IncrementalEstimator)((Object)estimator)).addValue(instance.value(n), instance.weight());
            }
        }
    }

    private static void setGeneralOptions(Builder builder, Estimator estimator, String[] stringArray) throws Exception {
        String string;
        BufferedReader bufferedReader = null;
        boolean bl = Utils.getFlag('h', stringArray);
        if (bl) {
            throw new Exception("Help requested.\n");
        }
        String string2 = Utils.getOption('i', stringArray);
        bufferedReader = string2.length() != 0 ? new BufferedReader(new FileReader(string2)) : new BufferedReader(new InputStreamReader(System.in));
        builder.m_instances = new Instances(bufferedReader);
        String string3 = Utils.getOption('a', stringArray);
        if (string3.length() != 0) {
            if (string3.equals("first")) {
                builder.m_attrIndex = 0;
            } else if (string3.equals("last")) {
                builder.m_attrIndex = builder.m_instances.numAttributes() - 1;
            } else {
                int n = Integer.parseInt(string3) - 1;
                if (n < 0 || n >= builder.m_instances.numAttributes()) {
                    throw new IllegalArgumentException("Option a: attribute index out of range.");
                }
                builder.m_attrIndex = n;
            }
        } else {
            builder.m_attrIndex = 0;
        }
        String string4 = Utils.getOption('c', stringArray);
        if (string4.length() == 0) {
            string4 = "last";
        }
        if (string4.length() != 0) {
            int n;
            builder.m_classIndex = string4.equals("first") ? 0 : (string4.equals("last") ? builder.m_instances.numAttributes() - 1 : ((n = Integer.parseInt(string4)) == -1 ? builder.m_instances.numAttributes() - 1 : n - 1));
        }
        if ((string = Utils.getOption('v', stringArray)).length() != 0) {
            int n;
            builder.m_classValueIndex = string.equals("first") ? 0 : (string.equals("last") ? builder.m_instances.numAttributes() - 1 : ((n = Integer.parseInt(string)) == -1 ? -1 : n - 1));
        }
        builder.m_instances.setClassIndex(builder.m_classIndex);
    }

    public static Estimator clone(Estimator estimator) throws Exception {
        return Estimator.makeCopy(estimator);
    }

    public static Estimator makeCopy(Estimator estimator) throws Exception {
        return (Estimator)new SerializedObject(estimator).getObject();
    }

    public static Estimator[] makeCopies(Estimator estimator, int n) throws Exception {
        if (estimator == null) {
            throw new Exception("No model estimator set");
        }
        Estimator[] estimatorArray = new Estimator[n];
        SerializedObject serializedObject = new SerializedObject(estimator);
        for (int i = 0; i < estimatorArray.length; ++i) {
            estimatorArray[i] = (Estimator)serializedObject.getObject();
        }
        return estimatorArray;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Estimator estimator = (Estimator)object;
        if (this.m_Debug != estimator.m_Debug) {
            return false;
        }
        if (this.m_classValueIndex != estimator.m_classValueIndex) {
            return false;
        }
        return this.m_noClass == estimator.m_noClass;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tIf set, estimator is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = this.getDebug() ? new String[]{"-D"} : new String[]{};
        return stringArray;
    }

    public static Estimator forName(String string, String[] stringArray) throws Exception {
        return (Estimator)Utils.forName(Estimator.class, string, stringArray);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, estimator may output additional info to the console.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.enableAll();
        return capabilities;
    }

    public void testCapabilities(Instances instances, int n) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.getCapabilities().testWithFail(instances.attribute(n));
    }

    private static class Builder
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -5810927990193597303L;
        Instances m_instances = null;
        int m_attrIndex = -1;
        int m_classIndex = -1;
        int m_classValueIndex = -1;

        private Builder() {
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5539 $");
        }
    }
}

