/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.RegSMO;
import weka.classifiers.functions.supportVector.SMOset;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RegSMOImproved
extends RegSMO
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 471692841446029784L;
    public static final int I0 = 3;
    public static final int I0a = 1;
    public static final int I0b = 2;
    public static final int I1 = 4;
    public static final int I2 = 8;
    public static final int I3 = 16;
    protected SMOset m_I0;
    protected int[] m_iSet;
    protected double m_bUp;
    protected double m_bLow;
    protected int m_iUp;
    protected int m_iLow;
    double m_fTolerance = 0.001;
    boolean m_bUseVariant1 = true;

    public String globalInfo() {
        return "Learn SVM for regression using SMO with Shevade, Keerthi, et al. adaption of the stopping criterion.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Improvements to the SMO Algorithm for SVM Regression");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "IEEE Transactions on Neural Networks");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1999");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/ieee_smo_reg.ps.gz");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.TECHREPORT);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Improvements to the SMO Algorithm for SVM Regression");
        technicalInformation2.setValue(TechnicalInformation.Field.INSTITUTION, "National University of Singapore");
        technicalInformation2.setValue(TechnicalInformation.Field.ADDRESS, "Control Division, Dept. of Mechanical Engineering");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "CD-99-16");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1999");
        technicalInformation2.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/smoreg_mod.ps.gz");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe tolerance parameter for checking the stopping criterion.\n\t(default 0.001)", "T", 1, "-T <double>"));
        vector.addElement(new Option("\tUse variant 1 of the algorithm when true, otherwise use variant 2.\n\t(default true)", "V", 0, "-V"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('T', stringArray);
        if (string.length() != 0) {
            this.setTolerance(Double.parseDouble(string));
        } else {
            this.setTolerance(0.001);
        }
        this.setUseVariant1(Utils.getFlag('V', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-T");
        vector.add("" + this.getTolerance());
        if (this.m_bUseVariant1) {
            vector.add("-V");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String toleranceTipText() {
        return "tolerance parameter used for checking stopping criterion b.up < b.low + 2 tol";
    }

    public double getTolerance() {
        return this.m_fTolerance;
    }

    public void setTolerance(double d) {
        this.m_fTolerance = d;
    }

    public String useVariant1TipText() {
        return "set true to use variant 1 of the paper, otherwise use variant 2.";
    }

    public boolean isUseVariant1() {
        return this.m_bUseVariant1;
    }

    public void setUseVariant1(boolean bl) {
        this.m_bUseVariant1 = bl;
    }

    protected int takeStep(int n, int n2, double d, double d2, double d3) throws Exception {
        if (n == n2) {
            return 0;
        }
        double d4 = this.m_C * this.m_data.instance(n).weight();
        double d5 = this.m_C * this.m_data.instance(n2).weight();
        double d6 = this.m_alpha[n];
        double d7 = this.m_alphaStar[n];
        double d8 = this.m_error[n];
        double d9 = this.m_kernel.eval(n, n, this.m_data.instance(n));
        double d10 = this.m_kernel.eval(n, n2, this.m_data.instance(n));
        double d11 = this.m_kernel.eval(n2, n2, this.m_data.instance(n2));
        double d12 = -2.0 * d10 + d9 + d11;
        double d13 = d6 - d7 + d - d2;
        double d14 = d6;
        double d15 = d7;
        double d16 = d;
        double d17 = d2;
        double d18 = d8 - d3;
        if (this.findOptimalPointOnLine(n, d6, d7, d4, n2, d, d2, d5, d13, d12, d18)) {
            d6 = this.m_alpha[n];
            d7 = this.m_alphaStar[n];
            d = this.m_alpha[n2];
            d2 = this.m_alphaStar[n2];
            double d19 = d6 - d14 - (d7 - d15);
            double d20 = d - d16 - (d2 - d17);
            int n3 = this.m_I0.getNext(-1);
            while (n3 != -1) {
                if (n3 != n && n3 != n2) {
                    int n4 = n3;
                    this.m_error[n4] = this.m_error[n4] - (d19 * this.m_kernel.eval(n, n3, this.m_data.instance(n)) + d20 * this.m_kernel.eval(n2, n3, this.m_data.instance(n2)));
                }
                n3 = this.m_I0.getNext(n3);
            }
            int n5 = n;
            this.m_error[n5] = this.m_error[n5] - (d19 * d9 + d20 * d10);
            int n6 = n2;
            this.m_error[n6] = this.m_error[n6] - (d19 * d10 + d20 * d11);
            this.updateIndexSetFor(n, d4);
            this.updateIndexSetFor(n2, d5);
            this.m_bUp = Double.MAX_VALUE;
            this.m_bLow = -1.7976931348623157E308;
            n3 = this.m_I0.getNext(-1);
            while (n3 != -1) {
                this.updateBoundaries(n3, this.m_error[n3]);
                n3 = this.m_I0.getNext(n3);
            }
            if (!this.m_I0.contains(n)) {
                this.updateBoundaries(n, this.m_error[n]);
            }
            if (!this.m_I0.contains(n2)) {
                this.updateBoundaries(n2, this.m_error[n2]);
            }
            return 1;
        }
        return 0;
    }

    protected void updateIndexSetFor(int n, double d) throws Exception {
        if (this.m_alpha[n] == 0.0 && this.m_alphaStar[n] == 0.0) {
            this.m_iSet[n] = 4;
            this.m_I0.delete(n);
        } else if (this.m_alpha[n] > 0.0) {
            if (this.m_alpha[n] < d) {
                if ((this.m_iSet[n] & 3) == 0) {
                    this.m_I0.insert(n);
                }
                this.m_iSet[n] = 1;
            } else {
                this.m_iSet[n] = 16;
                this.m_I0.delete(n);
            }
        } else if (this.m_alphaStar[n] < d) {
            if ((this.m_iSet[n] & 3) == 0) {
                this.m_I0.insert(n);
            }
            this.m_iSet[n] = 2;
        } else {
            this.m_iSet[n] = 8;
            this.m_I0.delete(n);
        }
    }

    protected void updateBoundaries(int n, double d) {
        int n2 = this.m_iSet[n];
        double d2 = this.m_bLow;
        if ((n2 & 0xA) > 0) {
            d2 = d + this.m_epsilon;
        } else if ((n2 & 5) > 0) {
            d2 = d - this.m_epsilon;
        }
        if (this.m_bLow < d2) {
            this.m_bLow = d2;
            this.m_iLow = n;
        }
        double d3 = this.m_bUp;
        if ((n2 & 0x11) > 0) {
            d3 = d - this.m_epsilon;
        } else if ((n2 & 6) > 0) {
            d3 = d + this.m_epsilon;
        }
        if (this.m_bUp > d3) {
            this.m_bUp = d3;
            this.m_iUp = n;
        }
    }

    protected int examineExample(int n) throws Exception {
        double d = this.m_alpha[n];
        double d2 = this.m_alphaStar[n];
        int n2 = this.m_iSet[n];
        double d3 = this.m_error[n];
        if (!this.m_I0.contains(n)) {
            this.m_error[n] = d3 = -this.SVMOutput(n) - this.m_b + this.m_target[n];
            if (n2 == 4) {
                if (d3 + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = d3 + this.m_epsilon;
                    this.m_iUp = n;
                } else if (d3 - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = d3 - this.m_epsilon;
                    this.m_iLow = n;
                }
            } else if (n2 == 8 && d3 + this.m_epsilon > this.m_bLow) {
                this.m_bLow = d3 + this.m_epsilon;
                this.m_iLow = n;
            } else if (n2 == 16 && d3 - this.m_epsilon < this.m_bUp) {
                this.m_bUp = d3 - this.m_epsilon;
                this.m_iUp = n;
            }
        }
        int n3 = n;
        boolean bl = true;
        if (n2 == 1) {
            if (this.m_bLow - (d3 - this.m_epsilon) > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iLow;
                if (d3 - this.m_epsilon - this.m_bUp > this.m_bLow - (d3 - this.m_epsilon)) {
                    n3 = this.m_iUp;
                }
            } else if (d3 - this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iUp;
                if (this.m_bLow - (d3 - this.m_epsilon) > d3 - this.m_epsilon - this.m_bUp) {
                    n3 = this.m_iLow;
                }
            }
        } else if (n2 == 2) {
            if (this.m_bLow - (d3 + this.m_epsilon) > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iLow;
                if (d3 + this.m_epsilon - this.m_bUp > this.m_bLow - (d3 + this.m_epsilon)) {
                    n3 = this.m_iUp;
                }
            } else if (d3 + this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iUp;
                if (this.m_bLow - (d3 + this.m_epsilon) > d3 + this.m_epsilon - this.m_bUp) {
                    n3 = this.m_iLow;
                }
            }
        } else if (n2 == 4) {
            if (this.m_bLow - (d3 + this.m_epsilon) > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iLow;
                if (d3 + this.m_epsilon - this.m_bUp > this.m_bLow - (d3 + this.m_epsilon)) {
                    n3 = this.m_iUp;
                }
            } else if (d3 - this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iUp;
                if (this.m_bLow - (d3 - this.m_epsilon) > d3 - this.m_epsilon - this.m_bUp) {
                    n3 = this.m_iLow;
                }
            }
        } else if (n2 == 8) {
            if (d3 + this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bl = false;
                n3 = this.m_iUp;
            }
        } else if (n2 == 16 && this.m_bLow - (d3 - this.m_epsilon) > 2.0 * this.m_fTolerance) {
            bl = false;
            n3 = this.m_iLow;
        }
        if (bl) {
            return 0;
        }
        return this.takeStep(n3, n, this.m_alpha[n], this.m_alphaStar[n], d3);
    }

    protected void init(Instances instances) throws Exception {
        int n;
        super.init(instances);
        this.m_I0 = new SMOset(this.m_data.numInstances());
        this.m_iSet = new int[this.m_data.numInstances()];
        for (n = 0; n < this.m_nInstances; ++n) {
            this.m_iSet[n] = 4;
        }
        this.m_iUp = 0;
        this.m_bUp = this.m_target[this.m_iUp] + this.m_epsilon;
        this.m_iLow = this.m_iUp;
        this.m_bLow = this.m_target[this.m_iLow] - this.m_epsilon;
        this.m_error = new double[this.m_nInstances];
        for (n = 0; n < this.m_nInstances; ++n) {
            this.m_error[n] = this.m_target[n];
        }
    }

    protected void optimize1() throws Exception {
        int n = 0;
        boolean bl = true;
        while (n > 0 || bl) {
            int n2;
            n = 0;
            if (bl) {
                for (n2 = 0; n2 < this.m_nInstances; ++n2) {
                    n += this.examineExample(n2);
                }
            } else {
                n2 = this.m_I0.getNext(-1);
                while (n2 != -1) {
                    n += this.examineExample(n2);
                    if (this.m_bLow - this.m_bUp < 2.0 * this.m_fTolerance) {
                        n = 0;
                        break;
                    }
                    n2 = this.m_I0.getNext(n2);
                }
            }
            if (bl) {
                bl = false;
                continue;
            }
            if (n != 0) continue;
            bl = true;
        }
    }

    protected void optimize2() throws Exception {
        int n = 0;
        boolean bl = true;
        while (n > 0 || bl) {
            int n2;
            n = 0;
            if (bl) {
                for (n2 = 0; n2 < this.m_nInstances; ++n2) {
                    n += this.examineExample(n2);
                }
            } else {
                n2 = 1;
                do {
                    if (this.takeStep(this.m_iUp, this.m_iLow, this.m_alpha[this.m_iLow], this.m_alphaStar[this.m_iLow], this.m_error[this.m_iLow]) > 0) {
                        n2 = 1;
                        ++n;
                        continue;
                    }
                    n2 = 0;
                } while (this.m_bUp <= this.m_bLow - 2.0 * this.m_fTolerance && n2 != 0);
                n = 0;
            }
            if (bl) {
                bl = false;
                continue;
            }
            if (n != 0) continue;
            bl = true;
        }
    }

    protected void wrapUp() throws Exception {
        this.m_b = -(this.m_bLow + this.m_bUp) / 2.0;
        this.m_target = null;
        this.m_error = null;
        super.wrapUp();
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.init(instances);
        if (this.m_bUseVariant1) {
            this.optimize1();
        } else {
            this.optimize2();
        }
        this.wrapUp();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

