/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Vector;
import weka.associations.Apriori;
import weka.associations.SingleAssociatorEnhancer;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FilteredAssociator
extends SingleAssociatorEnhancer {
    static final long serialVersionUID = -4523450618538717400L;
    protected Filter m_Filter;
    protected Instances m_FilteredInstances;
    protected int m_ClassIndex;

    public FilteredAssociator() {
        this.m_Associator = new Apriori();
        this.m_Filter = new MultiFilter();
        ((MultiFilter)this.m_Filter).setFilters(new Filter[]{new ReplaceMissingValues()});
        this.m_ClassIndex = -1;
    }

    public String globalInfo() {
        return "Class for running an arbitrary associator on data that has been passed through an arbitrary filter. Like the associator, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.";
    }

    protected String defaultAssociatorString() {
        return Apriori.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.Remove -V -R 1,2\"\n\t(default: weka.filters.MultiFilter with\n\tweka.filters.unsupervised.attribute.ReplaceMissingValues)", "F", 1, "-F <filter specification>"));
        vector.addElement(new Option("\tThe class index.\n\t(default: -1, i.e., last)", "c", 1, "-c <the class index>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        if (string.length() > 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string2, stringArray2));
        } else {
            this.setFilter(new Discretize());
        }
        string = Utils.getOption('c', stringArray);
        if (string.length() > 0) {
            this.setClassIndex(Integer.parseInt(string));
        } else {
            this.setClassIndex(-1);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-F");
        vector.add("" + this.getFilterSpec());
        vector.add("-c");
        vector.add("" + this.getClassIndex());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String classIndexTipText() {
        return "Index of the class attribute. If set to -1, the last attribute is taken as class attribute.";
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    protected String getFilterSpec() {
        Filter filter = this.getFilter();
        if (filter instanceof OptionHandler) {
            return filter.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
        }
        return filter.getClass().getName();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getFilter() == null ? super.getCapabilities() : this.getFilter().getCapabilities();
        capabilities.disable(Capabilities.Capability.NO_CLASS);
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        return capabilities;
    }

    public void buildAssociations(Instances instances) throws Exception {
        if (this.m_Associator == null) {
            throw new Exception("No base associator has been set!");
        }
        instances = new Instances(instances);
        if (this.getClassIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            instances.setClassIndex(this.getClassIndex());
        }
        instances.deleteWithMissingClass();
        this.m_Filter.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Filter);
        this.getAssociator().getCapabilities().testWithFail(instances);
        this.m_FilteredInstances = instances.stringFreeStructure();
        this.m_Associator.buildAssociations(instances);
    }

    public String toString() {
        String string = this.m_FilteredInstances == null ? "FilteredAssociator: No model built yet." : "FilteredAssociator using " + this.getAssociatorSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nAssociator Model\n" + this.m_Associator.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        FilteredAssociator.runAssociator(new FilteredAssociator(), stringArray);
    }
}

