/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.ChartEvent;
import weka.gui.beans.ChartListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;

public class IncrementalClassifierEvaluator
extends AbstractEvaluator
implements IncrementalClassifierListener,
EventConstraints {
    private static final long serialVersionUID = -3105419818939541291L;
    private transient Evaluation m_eval;
    private transient Classifier m_classifier;
    private Vector m_listeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Vector m_dataLegend = new Vector();
    private ChartEvent m_ce = new ChartEvent(this);
    private double[] m_dataPoint = new double[1];
    private boolean m_reset = false;
    private double m_min = Double.MAX_VALUE;
    private double m_max = Double.MIN_VALUE;

    public IncrementalClassifierEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/IncrementalClassifierEvaluator.gif", "weka/gui/beans/icons/IncrementalClassifierEvaluator_animated.gif");
        this.m_visual.setText("IncrementalClassifierEvaluator");
    }

    public String globalInfo() {
        return "Evaluate the performance of incrementally trained classifiers.";
    }

    public void acceptClassifier(IncrementalClassifierEvent incrementalClassifierEvent) {
        try {
            if (incrementalClassifierEvent.getStatus() == 0) {
                this.m_eval = new Evaluation(incrementalClassifierEvent.getStructure());
                this.m_dataLegend = new Vector();
                this.m_reset = true;
                this.m_dataPoint = new double[0];
                Instances instances = incrementalClassifierEvent.getStructure();
                System.err.println("NEW BATCH");
            } else {
                Instance instance = incrementalClassifierEvent.getCurrentInstance();
                double[] dArray = incrementalClassifierEvent.getClassifier().distributionForInstance(instance);
                double d = 0.0;
                if (!instance.isMissing(instance.classIndex())) {
                    this.m_eval.evaluateModelOnce(dArray, instance);
                } else {
                    d = incrementalClassifierEvent.getClassifier().classifyInstance(instance);
                }
                if (instance.classIndex() >= 0) {
                    double d2;
                    if (instance.attribute(instance.classIndex()).isNominal()) {
                        if (!instance.isMissing(instance.classIndex())) {
                            if (this.m_dataPoint.length < 2) {
                                this.m_dataPoint = new double[2];
                                this.m_dataLegend.addElement("Accuracy");
                                this.m_dataLegend.addElement("RMSE (prob)");
                            }
                            this.m_dataPoint[1] = this.m_eval.rootMeanSquaredError();
                        } else if (this.m_dataPoint.length < 1) {
                            this.m_dataPoint = new double[1];
                            this.m_dataLegend.addElement("Confidence");
                        }
                        d2 = 0.0;
                        d2 = !instance.isMissing(instance.classIndex()) ? 1.0 - this.m_eval.errorRate() : dArray[Utils.maxIndex(dArray)];
                        this.m_dataPoint[0] = d2;
                        this.m_ce.setLegendText(this.m_dataLegend);
                        this.m_ce.setMin(0.0);
                        this.m_ce.setMax(1.0);
                        this.m_ce.setDataPoint(this.m_dataPoint);
                        this.m_ce.setReset(this.m_reset);
                        this.m_reset = false;
                    } else {
                        if (this.m_dataPoint.length < 1) {
                            this.m_dataPoint = new double[1];
                            if (instance.isMissing(instance.classIndex())) {
                                this.m_dataLegend.addElement("Prediction");
                            } else {
                                this.m_dataLegend.addElement("RMSE");
                            }
                        }
                        if (!instance.isMissing(instance.classIndex())) {
                            d2 = !instance.isMissing(instance.classIndex()) ? this.m_eval.rootMeanSquaredError() : d;
                            this.m_dataPoint[0] = d2;
                            if (d2 > this.m_max) {
                                this.m_max = d2;
                            }
                            if (d2 < this.m_min) {
                                this.m_min = d2;
                            }
                        }
                        this.m_ce.setLegendText(this.m_dataLegend);
                        this.m_ce.setMin(instance.isMissing(instance.classIndex()) ? this.m_min : 0.0);
                        this.m_ce.setMax(this.m_max);
                        this.m_ce.setDataPoint(this.m_dataPoint);
                        this.m_ce.setReset(this.m_reset);
                        this.m_reset = false;
                    }
                    this.notifyChartListeners(this.m_ce);
                    if (incrementalClassifierEvent.getStatus() == 2 && this.m_textListeners.size() > 0) {
                        String string = incrementalClassifierEvent.getClassifier().getClass().getName();
                        string = string.substring(string.lastIndexOf(46) + 1, string.length());
                        String string2 = "=== Performance information ===\n\nScheme:   " + string + "\n" + "Relation: " + instance.dataset().relationName() + "\n\n" + this.m_eval.toSummaryString();
                        string = "Results: " + string;
                        TextEvent textEvent = new TextEvent(this, string2, string);
                        this.notifyTextListeners(textEvent);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("incrementalClassifier");
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChartListeners(ChartEvent chartEvent) {
        Vector vector;
        IncrementalClassifierEvaluator incrementalClassifierEvaluator = this;
        synchronized (incrementalClassifierEvaluator) {
            vector = (Vector)this.m_listeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((ChartListener)vector.elementAt(i)).acceptDataPoint(chartEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        IncrementalClassifierEvaluator incrementalClassifierEvaluator = this;
        synchronized (incrementalClassifierEvaluator) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    public synchronized void addChartListener(ChartListener chartListener) {
        this.m_listeners.addElement(chartListener);
    }

    public synchronized void removeChartListener(ChartListener chartListener) {
        this.m_listeners.remove(chartListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }
}

