/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.ParallelIteratedSingleClassifierEnhancer;
import weka.core.Option;
import weka.core.Utils;

public abstract class RandomizableParallelIteratedSingleClassifierEnhancer
extends ParallelIteratedSingleClassifierEnhancer {
    private static final long serialVersionUID = 1298141000373615374L;
    protected int m_Seed = 1;

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tRandom number seed.\n\t(default 1)", "S", 1, "-S <num>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String seed = Utils.getOption('S', options);
        if (seed.length() != 0) {
            this.setSeed(Integer.parseInt(seed));
        } else {
            this.setSeed(1);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.getSeed();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    public int getSeed() {
        return this.m_Seed;
    }
}

