/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.rules.DecisionTable;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class DTNB
extends DecisionTable {
    protected NaiveBayes m_NB;
    private int[] m_nbFeatures;
    private double m_percentUsedByDT;
    private double m_percentDeleted;
    static final long serialVersionUID = 2999557077765701326L;
    protected ASSearch m_backwardWithDelete;

    public String globalInfo() {
        return "Class for building and using a decision table/naive bayes hybrid classifier. At each point in the search, the algorithm evaluates the merit of dividing the attributes into two disjoint subsets: one for the decision table, the other for naive Bayes. A forward selection search is used, where at each step, selected attributes are modeled by naive Bayes and the remainder by the decision table, and all attributes are modelled by the decision table initially. At each step, the algorithm also considers dropping an attribute entirely from the model.\n\nFor more information, see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hall and Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining Naive Bayes and Decision Tables");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 21st Florida Artificial Intelligence Society Conference (FLAIRS)");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        result.setValue(TechnicalInformation.Field.PAGES, "???-???");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI press");
        return result;
    }

    double evaluateFoldCV(Instances fold, int[] fs) throws Exception {
        Instance inst;
        int i;
        int ruleCount = 0;
        int numFold = fold.numInstances();
        int numCl = this.m_theInstances.classAttribute().numValues();
        double[][] class_distribs = new double[numFold][numCl];
        double[] instA = new double[fs.length];
        double acc = 0.0;
        int classI = this.m_theInstances.classIndex();
        double[] normDist = this.m_classIsNominal ? new double[numCl] : new double[2];
        for (i = 0; i < numFold; ++i) {
            inst = fold.instance(i);
            for (int j = 0; j < fs.length; ++j) {
                instA[j] = fs[j] == classI ? Double.MAX_VALUE : (inst.isMissing(fs[j]) ? Double.MAX_VALUE : inst.value(fs[j]));
            }
            DecisionTableHashKey thekey = new DecisionTableHashKey(instA);
            class_distribs[i] = (double[])this.m_entries.get(thekey);
            if (class_distribs[i] == null) {
                throw new Error("This should never happen!");
            }
            if (this.m_classIsNominal) {
                double[] dArray = class_distribs[i];
                int n = (int)inst.classValue();
                dArray[n] = dArray[n] - inst.weight();
                inst.setWeight(-inst.weight());
                this.m_NB.updateClassifier(inst);
                inst.setWeight(-inst.weight());
            } else {
                double[] dArray = class_distribs[i];
                dArray[0] = dArray[0] - inst.classValue() * inst.weight();
                double[] dArray2 = class_distribs[i];
                dArray2[1] = dArray2[1] - inst.weight();
            }
            ++ruleCount;
            int n = (int)inst.classValue();
            this.m_classPriorCounts[n] = this.m_classPriorCounts[n] - inst.weight();
        }
        double[] classPriors = (double[])this.m_classPriorCounts.clone();
        Utils.normalize(classPriors);
        for (i = 0; i < numFold; ++i) {
            inst = fold.instance(i);
            System.arraycopy(class_distribs[i], 0, normDist, 0, normDist.length);
            if (this.m_classIsNominal) {
                boolean ok = false;
                for (int j = 0; j < normDist.length; ++j) {
                    if (!Utils.gr(normDist[j], 1.0)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    normDist = (double[])classPriors.clone();
                } else {
                    Utils.normalize(normDist);
                }
                double[] nbDist = this.m_NB.distributionForInstance(inst);
                for (int l = 0; l < normDist.length; ++l) {
                    normDist[l] = Math.log(normDist[l]) - Math.log(classPriors[l]);
                    int n = l;
                    normDist[n] = normDist[n] + Math.log(nbDist[l]);
                }
                normDist = Utils.logs2probs(normDist);
                if (this.m_evaluationMeasure == 5) {
                    this.m_evaluation.evaluateModelOnceAndRecordPrediction(normDist, inst);
                    continue;
                }
                this.m_evaluation.evaluateModelOnce(normDist, inst);
                continue;
            }
            if (Utils.eq(normDist[1], 0.0)) {
                double[] temp = new double[]{this.m_majority};
                this.m_evaluation.evaluateModelOnce(temp, inst);
                continue;
            }
            double[] temp = new double[]{normDist[0] / normDist[1]};
            this.m_evaluation.evaluateModelOnce(temp, inst);
        }
        for (i = 0; i < numFold; ++i) {
            inst = fold.instance(i);
            int n = (int)inst.classValue();
            this.m_classPriorCounts[n] = this.m_classPriorCounts[n] + inst.weight();
            if (this.m_classIsNominal) {
                double[] dArray = class_distribs[i];
                int n2 = (int)inst.classValue();
                dArray[n2] = dArray[n2] + inst.weight();
                this.m_NB.updateClassifier(inst);
                continue;
            }
            double[] dArray = class_distribs[i];
            dArray[0] = dArray[0] + inst.classValue() * inst.weight();
            double[] dArray3 = class_distribs[i];
            dArray3[1] = dArray3[1] + inst.weight();
        }
        return acc;
    }

    double evaluateInstanceLeaveOneOut(Instance instance, double[] instA) throws Exception {
        DecisionTableHashKey thekey = new DecisionTableHashKey(instA);
        double[] tempDist = (double[])this.m_entries.get(thekey);
        if (tempDist == null) {
            throw new Error("This should never happen!");
        }
        double[] normDist = new double[tempDist.length];
        System.arraycopy(tempDist, 0, normDist, 0, tempDist.length);
        int n = (int)instance.classValue();
        normDist[n] = normDist[n] - instance.weight();
        boolean ok = false;
        for (int i = 0; i < normDist.length; ++i) {
            if (!Utils.gr(normDist[i], 1.0)) continue;
            ok = true;
            break;
        }
        int n2 = (int)instance.classValue();
        this.m_classPriorCounts[n2] = this.m_classPriorCounts[n2] - instance.weight();
        double[] classPriors = (double[])this.m_classPriorCounts.clone();
        Utils.normalize(classPriors);
        if (!ok) {
            normDist = classPriors;
        } else {
            Utils.normalize(normDist);
        }
        int n3 = (int)instance.classValue();
        this.m_classPriorCounts[n3] = this.m_classPriorCounts[n3] + instance.weight();
        if (this.m_NB != null) {
            instance.setWeight(-instance.weight());
            this.m_NB.updateClassifier(instance);
            double[] nbDist = this.m_NB.distributionForInstance(instance);
            instance.setWeight(-instance.weight());
            this.m_NB.updateClassifier(instance);
            for (int i = 0; i < normDist.length; ++i) {
                normDist[i] = Math.log(normDist[i]) - Math.log(classPriors[i]);
                int n4 = i;
                normDist[n4] = normDist[n4] + Math.log(nbDist[i]);
            }
            normDist = Utils.logs2probs(normDist);
        }
        if (this.m_evaluationMeasure == 5) {
            this.m_evaluation.evaluateModelOnceAndRecordPrediction(normDist, instance);
        } else {
            this.m_evaluation.evaluateModelOnce(normDist, instance);
        }
        return Utils.maxIndex(normDist);
    }

    protected void setUpEvaluator() throws Exception {
        this.m_evaluator = new EvalWithDelete();
        this.m_evaluator.buildEvaluator(this.m_theInstances);
    }

    private void setUpSearch() {
        this.m_backwardWithDelete = new BackwardsWithDelete();
    }

    public void buildClassifier(Instances data) throws Exception {
        this.m_saveMemory = false;
        if (data.classAttribute().isNumeric()) {
            throw new Exception("Can only handle nominal class!");
        }
        if (this.m_backwardWithDelete == null) {
            this.setUpSearch();
            this.m_search = this.m_backwardWithDelete;
        }
        super.buildClassifier(data);
        for (int i = 0; i < this.m_theInstances.numAttributes(); ++i) {
            this.m_theInstances.attribute(i).setWeight(1.0);
        }
        int count = 0;
        for (int i = 0; i < this.m_decisionFeatures.length; ++i) {
            if (this.m_decisionFeatures[i] == this.m_theInstances.classIndex()) continue;
            ++count;
            this.m_theInstances.attribute(this.m_decisionFeatures[i]).setWeight(0.0);
        }
        double numDeleted = 0.0;
        BitSet deleted = ((EvalWithDelete)this.m_evaluator).getDeletedList();
        for (int i = 0; i < this.m_theInstances.numAttributes(); ++i) {
            if (!deleted.get(i)) continue;
            this.m_theInstances.attribute(i).setWeight(0.0);
            numDeleted += 1.0;
        }
        this.m_percentUsedByDT = (double)count / (double)(this.m_theInstances.numAttributes() - 1);
        this.m_percentDeleted = numDeleted / (double)(this.m_theInstances.numAttributes() - 1);
        this.m_NB = new NaiveBayes();
        this.m_NB.buildClassifier(this.m_theInstances);
        this.m_dtInstances = new Instances(this.m_dtInstances, 0);
        this.m_theInstances = new Instances(this.m_theInstances, 0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_disTransform.input(instance);
        this.m_disTransform.batchFinished();
        instance = this.m_disTransform.output();
        this.m_delTransform.input(instance);
        this.m_delTransform.batchFinished();
        Instance dtInstance = this.m_delTransform.output();
        DecisionTableHashKey thekey = new DecisionTableHashKey(dtInstance, dtInstance.numAttributes(), false);
        double[] tempDist = (double[])this.m_entries.get(thekey);
        if (tempDist == null) {
            tempDist = this.m_useIBk ? this.m_ibk.distributionForInstance(dtInstance) : (double[])this.m_classPriors.clone();
        } else {
            double[] normDist = new double[tempDist.length];
            System.arraycopy(tempDist, 0, normDist, 0, tempDist.length);
            Utils.normalize(normDist);
            tempDist = normDist;
        }
        double[] nbDist = this.m_NB.distributionForInstance(instance);
        for (int i = 0; i < nbDist.length; ++i) {
            tempDist[i] = Math.log(tempDist[i]) - Math.log(this.m_classPriors[i]);
            int n = i;
            tempDist[n] = tempDist[n] + Math.log(nbDist[i]);
        }
        tempDist = Utils.logs2probs(tempDist);
        Utils.normalize(tempDist);
        return tempDist;
    }

    public String toString() {
        String sS = super.toString();
        if (this.m_displayRules && this.m_NB != null) {
            sS = sS + this.m_NB.toString();
        }
        return sS;
    }

    public double measurePercentAttsUsedByDT() {
        return this.m_percentUsedByDT;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(2);
        newVector.addElement("measureNumRules");
        newVector.addElement("measurePercentAttsUsedByDT");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (additionalMeasureName.compareToIgnoreCase("measurePercentAttsUsedByDT") == 0) {
            return this.measurePercentAttsUsedByDT();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (DecisionTable)");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disable(Capabilities.Capability.NUMERIC_CLASS);
        result.disable(Capabilities.Capability.DATE_CLASS);
        return result;
    }

    public void setSearch(ASSearch search) {
    }

    public ASSearch getSearch() {
        if (this.m_backwardWithDelete == null) {
            this.setUpSearch();
            this.m_search = this.m_backwardWithDelete;
        }
        return this.m_search;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(7);
        newVector.addElement(new Option("\tUse cross validation to evaluate features.\n\tUse number of folds = 1 for leave one out CV.\n\t(Default = leave one out CV)", "X", 1, "-X <number of folds>"));
        newVector.addElement(new Option("\tPerformance evaluation measure to use for selecting attributes.\n\t(Default = accuracy for discrete class and rmse for numeric class)", "E", 1, "-E <acc | rmse | mae | auc>"));
        newVector.addElement(new Option("\tUse nearest neighbour instead of global table majority.", "I", 0, "-I"));
        newVector.addElement(new Option("\tDisplay decision table rules.\n", "R", 0, "-R"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('X', options);
        if (optionString.length() != 0) {
            this.setCrossVal(Integer.parseInt(optionString));
        }
        this.m_useIBk = Utils.getFlag('I', options);
        this.m_displayRules = Utils.getFlag('R', options);
        optionString = Utils.getOption('E', options);
        if (optionString.length() != 0) {
            if (optionString.equals("acc")) {
                this.setEvaluationMeasure(new SelectedTag(2, TAGS_EVALUATION));
            } else if (optionString.equals("rmse")) {
                this.setEvaluationMeasure(new SelectedTag(3, TAGS_EVALUATION));
            } else if (optionString.equals("mae")) {
                this.setEvaluationMeasure(new SelectedTag(4, TAGS_EVALUATION));
            } else if (optionString.equals("auc")) {
                this.setEvaluationMeasure(new SelectedTag(5, TAGS_EVALUATION));
            } else {
                throw new IllegalArgumentException("Invalid evaluation measure");
            }
        }
    }

    public String[] getOptions() {
        String[] options = new String[9];
        int current = 0;
        options[current++] = "-X";
        options[current++] = "" + this.getCrossVal();
        if (this.m_evaluationMeasure != 1) {
            options[current++] = "-E";
            switch (this.m_evaluationMeasure) {
                case 2: {
                    options[current++] = "acc";
                    break;
                }
                case 3: {
                    options[current++] = "rmse";
                    break;
                }
                case 4: {
                    options[current++] = "mae";
                    break;
                }
                case 5: {
                    options[current++] = "auc";
                }
            }
        }
        if (this.m_useIBk) {
            options[current++] = "-I";
        }
        if (this.m_displayRules) {
            options[current++] = "-R";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] argv) {
        DTNB.runClassifier(new DTNB(), argv);
    }

    protected class BackwardsWithDelete
    extends ASSearch {
        protected BackwardsWithDelete() {
        }

        public String globalInfo() {
            return "Specialized search that performs a forward selection (naive Bayes)/backward elimination (decision table). Also considers dropping attributes entirely from the combined model.";
        }

        public String toString() {
            return "";
        }

        public int[] search(ASEvaluation eval, Instances data) throws Exception {
            int i;
            double best_merit = -1.7976931348623157E308;
            double temp_best = 0.0;
            double temp_merit = 0.0;
            double temp_merit_delete = 0.0;
            int temp_index = 0;
            BitSet best_group = null;
            int numAttribs = data.numAttributes();
            if (best_group == null) {
                best_group = new BitSet(numAttribs);
            }
            int classIndex = data.classIndex();
            for (i = 0; i < numAttribs; ++i) {
                if (i == classIndex) continue;
                best_group.set(i);
            }
            best_merit = ((SubsetEvaluator)((Object)eval)).evaluateSubset(best_group);
            boolean done = false;
            boolean addone = false;
            boolean deleted = false;
            while (!done) {
                BitSet temp_group = (BitSet)best_group.clone();
                temp_best = best_merit;
                done = true;
                addone = false;
                for (i = 0; i < numAttribs; ++i) {
                    boolean z;
                    boolean bl = z = i != classIndex && temp_group.get(i);
                    if (!z) continue;
                    temp_group.clear(i);
                    temp_merit = ((SubsetEvaluator)((Object)eval)).evaluateSubset(temp_group);
                    temp_merit_delete = ((EvalWithDelete)eval).evaluateSubsetDelete(temp_group, i);
                    boolean deleteBetter = false;
                    if (temp_merit_delete >= temp_merit) {
                        temp_merit = temp_merit_delete;
                        deleteBetter = true;
                    }
                    boolean bl2 = z = temp_merit >= temp_best;
                    if (z) {
                        temp_best = temp_merit;
                        temp_index = i;
                        addone = true;
                        done = false;
                        deleted = deleteBetter;
                    }
                    temp_group.set(i);
                }
                if (!addone) continue;
                best_group.clear(temp_index);
                best_merit = temp_best;
                if (!deleted) continue;
                ((EvalWithDelete)eval).getDeletedList().set(temp_index);
            }
            return this.attributeList(best_group);
        }

        protected int[] attributeList(BitSet group) {
            int count = 0;
            BitSet copy = (BitSet)group.clone();
            for (int i = 0; i < DTNB.this.m_numAttributes; ++i) {
                if (!copy.get(i)) continue;
                ++count;
            }
            int[] list = new int[count];
            count = 0;
            for (int i = 0; i < DTNB.this.m_numAttributes; ++i) {
                if (!copy.get(i)) continue;
                list[count++] = i;
            }
            return list;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.4 $");
        }
    }

    protected class EvalWithDelete
    extends ASEvaluation
    implements SubsetEvaluator {
        private BitSet m_deletedFromDTNB;

        protected EvalWithDelete() {
        }

        public void buildEvaluator(Instances data) throws Exception {
            DTNB.this.m_NB = null;
            this.m_deletedFromDTNB = new BitSet(data.numAttributes());
        }

        private int setUpForEval(BitSet subset) throws Exception {
            int fc = 0;
            for (int jj = 0; jj < DTNB.this.m_numAttributes; ++jj) {
                if (!subset.get(jj)) continue;
                ++fc;
            }
            for (int j = 0; j < DTNB.this.m_numAttributes; ++j) {
                DTNB.this.m_theInstances.attribute(j).setWeight(1.0);
                if (j == DTNB.this.m_theInstances.classIndex() || !subset.get(j)) continue;
                DTNB.this.m_theInstances.attribute(j).setWeight(0.0);
            }
            for (int i = 0; i < DTNB.this.m_numAttributes; ++i) {
                if (!this.m_deletedFromDTNB.get(i)) continue;
                DTNB.this.m_theInstances.attribute(i).setWeight(0.0);
            }
            if (DTNB.this.m_NB == null) {
                DTNB.this.m_NB = new NaiveBayes();
                DTNB.this.m_NB.buildClassifier(DTNB.this.m_theInstances);
            }
            return fc;
        }

        public double evaluateSubset(BitSet subset) throws Exception {
            int fc = this.setUpForEval(subset);
            return DTNB.this.estimatePerformance(subset, fc);
        }

        public double evaluateSubsetDelete(BitSet subset, int potentialDelete) throws Exception {
            int fc = this.setUpForEval(subset);
            DTNB.this.m_theInstances.attribute(potentialDelete).setWeight(0.0);
            return DTNB.this.estimatePerformance(subset, fc);
        }

        public BitSet getDeletedList() {
            return this.m_deletedFromDTNB;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.4 $");
        }
    }
}

