/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class MahalanobisEstimator
extends Estimator
implements IncrementalEstimator {
    private static final long serialVersionUID = 8950225468990043868L;
    private Matrix m_CovarianceInverse = null;
    private double m_Determinant;
    private double m_ConstDelta;
    private double m_ValueMean;
    private static double TWO_PI = Math.PI * 2;

    private double normalKernel(double x) {
        Matrix thisPoint = new Matrix(1, 2);
        thisPoint.set(0, 0, x);
        thisPoint.set(0, 1, this.m_ConstDelta);
        return Math.exp(-thisPoint.times(this.m_CovarianceInverse).times(thisPoint.transpose()).get(0, 0) / 2.0) / (Math.sqrt(TWO_PI) * this.m_Determinant);
    }

    public MahalanobisEstimator(Matrix covariance, double constDelta, double valueMean) {
        if (covariance.getRowDimension() == 2 && covariance.getColumnDimension() == 2) {
            double a = covariance.get(0, 0);
            double b = covariance.get(0, 1);
            double c = covariance.get(1, 0);
            double d = covariance.get(1, 1);
            if (a == 0.0) {
                a = c;
                c = 0.0;
                double temp = b;
                b = d;
                d = temp;
            }
            if (a == 0.0) {
                return;
            }
            double denom = d - c * b / a;
            if (denom == 0.0) {
                return;
            }
            this.m_Determinant = covariance.get(0, 0) * covariance.get(1, 1) - covariance.get(1, 0) * covariance.get(0, 1);
            this.m_CovarianceInverse = new Matrix(2, 2);
            this.m_CovarianceInverse.set(0, 0, 1.0 / a + b * c / a / a / denom);
            this.m_CovarianceInverse.set(0, 1, -b / a / denom);
            this.m_CovarianceInverse.set(1, 0, -c / a / denom);
            this.m_CovarianceInverse.set(1, 1, 1.0 / denom);
            this.m_ConstDelta = constDelta;
            this.m_ValueMean = valueMean;
        }
    }

    public void addValue(double data, double weight) {
    }

    public double getProbability(double data) {
        double delta = data - this.m_ValueMean;
        if (this.m_CovarianceInverse == null) {
            return 0.0;
        }
        return this.normalKernel(delta);
    }

    public String toString() {
        if (this.m_CovarianceInverse == null) {
            return "No covariance inverse\n";
        }
        return "Mahalanovis Distribution. Mean = " + Utils.doubleToString(this.m_ValueMean, 4, 2) + "  ConditionalOffset = " + Utils.doubleToString(this.m_ConstDelta, 4, 2) + "\n" + "Covariance Matrix: Determinant = " + this.m_Determinant + "  Inverse:\n" + this.m_CovarianceInverse;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        if (!this.m_noClass) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5490 $");
    }

    public static void main(String[] argv) {
        try {
            double delta = 0.5;
            double xmean = 0.0;
            double lower = 0.0;
            double upper = 10.0;
            Matrix covariance = new Matrix(2, 2);
            covariance.set(0, 0, 2.0);
            covariance.set(0, 1, -3.0);
            covariance.set(1, 0, -4.0);
            covariance.set(1, 1, 5.0);
            if (argv.length > 0) {
                covariance.set(0, 0, Double.valueOf(argv[0]));
            }
            if (argv.length > 1) {
                covariance.set(0, 1, Double.valueOf(argv[1]));
            }
            if (argv.length > 2) {
                covariance.set(1, 0, Double.valueOf(argv[2]));
            }
            if (argv.length > 3) {
                covariance.set(1, 1, Double.valueOf(argv[3]));
            }
            if (argv.length > 4) {
                delta = Double.valueOf(argv[4]);
            }
            if (argv.length > 5) {
                xmean = Double.valueOf(argv[5]);
            }
            MahalanobisEstimator newEst = new MahalanobisEstimator(covariance, delta, xmean);
            if (argv.length > 6) {
                lower = Double.valueOf(argv[6]);
                if (argv.length > 7) {
                    upper = Double.valueOf(argv[7]);
                }
                double increment = (upper - lower) / 50.0;
                for (double current = lower; current <= upper; current += increment) {
                    System.out.println(current + "  " + newEst.getProbability(current));
                }
            } else {
                System.out.println("Covariance Matrix\n" + covariance);
                System.out.println(newEst);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

