/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.LinkedList;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class MILESFilter
extends SimpleBatchFilter
implements UnsupervisedFilter,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4694489111366063853L;
    public static final int BAG_ATTRIBUTE = 1;
    public static final int LABEL_ATTRIBUTE = 2;
    private double m_sigma = Math.sqrt(800000.0);
    private LinkedList<Instance> m_allInsts = null;

    public String sigmaTipText() {
        return "The value of the sigma parameter.";
    }

    public void setSigma(double sigma) {
        this.m_sigma = sigma;
    }

    public double getSigma() {
        return this.m_sigma;
    }

    public String globalInfo() {
        return "Implements the MILES transformation that maps multiple instance bags into a high-dimensional single-instance feature space.\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Y. Chen and J. Bi and J.Z. Wang");
        result.setValue(TechnicalInformation.Field.TITLE, "MILES: Multiple-instance learning via embedded instance selection");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE PAMI");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.VOLUME, "28");
        result.setValue(TechnicalInformation.Field.PAGES, "1931-1947");
        result.setValue(TechnicalInformation.Field.NUMBER, "12");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "James Foulds and Eibe Frank");
        additional.setValue(TechnicalInformation.Field.TITLE, "Revisiting multiple-instance learning via embedded instance selection");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "21st Australasian Joint Conference on Artificial Intelligence");
        additional.setValue(TechnicalInformation.Field.YEAR, "2008");
        additional.setValue(TechnicalInformation.Field.PAGES, "300-310");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) {
        int i;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        this.m_allInsts = new LinkedList();
        for (i = 0; i < this.getInputFormat().numInstances(); ++i) {
            Instances bag = this.getInputFormat().instance(i).relationalValue(1);
            for (int j = 0; j < bag.numInstances(); ++j) {
                this.m_allInsts.add(bag.instance(j));
            }
        }
        for (i = 0; i < this.m_allInsts.size(); ++i) {
            atts.addElement(new Attribute("" + i));
        }
        atts.addElement(inputFormat.attribute(2));
        Instances returner = new Instances("", atts, 0);
        returner.setClassIndex(returner.numAttributes() - 1);
        return returner;
    }

    protected Instances process(Instances inst) {
        Instances result = this.getOutputFormat();
        result.setClassIndex(result.numAttributes() - 1);
        if (inst.numInstances() == 0) {
            return result;
        }
        for (int i = 0; i < inst.numInstances(); ++i) {
            double label;
            double[] outputInstance = new double[result.numAttributes()];
            Instances bag = inst.instance(i).relationalValue(1);
            int k = 0;
            for (Instance x_k : this.m_allInsts) {
                double dSquared = Double.MAX_VALUE;
                for (int j = 0; j < bag.numInstances(); ++j) {
                    double total = 0.0;
                    Instance x_ij = bag.instance(j);
                    double numMissingValues = 0.0;
                    for (int l = 0; l < x_k.numAttributes(); ++l) {
                        if (x_k.isMissing(l)) continue;
                        if (!x_ij.isMissing(l)) {
                            total += (x_ij.value(l) - x_k.value(l)) * (x_ij.value(l) - x_k.value(l));
                            continue;
                        }
                        numMissingValues += 1.0;
                    }
                    if (!((total *= (double)x_k.numAttributes() / ((double)x_k.numAttributes() - numMissingValues)) < dSquared) && dSquared != Double.MAX_VALUE) continue;
                    dSquared = total;
                }
                outputInstance[k] = dSquared == Double.MAX_VALUE ? 0.0 : Math.exp(-1.0 * dSquared / (this.m_sigma * this.m_sigma));
                ++k;
            }
            outputInstance[outputInstance.length - 1] = label = inst.instance(i).value(2);
            result.add(new DenseInstance(inst.instance(i).weight(), outputInstance));
        }
        return result;
    }

    public Enumeration listOptions() {
        FastVector<Option> newVector = new FastVector<Option>(1);
        newVector.addElement(new Option("\tSpecify the sigma parameter (default: sqrt(800000)", "S", 1, "-S <num>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String sigmaString = Utils.getOption('S', options);
        if (sigmaString.length() != 0) {
            this.setSigma(Double.parseDouble(sigmaString));
        } else {
            this.setSigma(Math.sqrt(800000.0));
        }
    }

    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.getSigma();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public static void main(String[] args) {
        MILESFilter.runFilter(new MILESFilter(), args);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }
}

