/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.StreamableFilter;
import weka.filters.SupervisedFilter;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ConfigurationListener;
import weka.gui.beans.ConfigurationProducer;
import weka.gui.beans.ConnectionNotificationConsumer;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.LogWriter;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Filter
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener,
TrainingSetProducer,
TestSetProducer,
DataSource,
DataSourceListener,
InstanceListener,
EventConstraints,
ConfigurationProducer {
    private static final long serialVersionUID = 8249759470189439321L;
    protected BeanVisual m_visual = new BeanVisual("Filter", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    private static int IDLE = 0;
    private static int FILTERING_TRAINING = 1;
    private static int FILTERING_TEST = 2;
    private int m_state = IDLE;
    protected Thread m_filterThread = null;
    private transient Instances m_trainingSet;
    private transient Instances m_testingSet;
    protected String m_globalInfo;
    private final Hashtable m_listenees = new Hashtable();
    private final Vector m_trainingListeners = new Vector();
    private final Vector m_testListeners = new Vector();
    private final Vector m_instanceListeners = new Vector();
    private final Vector m_dataListeners = new Vector();
    private weka.filters.Filter m_Filter = new AllFilter();
    private final InstanceEvent m_ie = new InstanceEvent(this);
    private transient Logger m_log = null;
    private transient int m_instanceCount;
    private boolean m_structurePassedOn = false;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Filter() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setFilter(this.m_Filter);
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setFilter(weka.filters.Filter c) {
        boolean loadImages = true;
        if (c.getClass().getName().compareTo(this.m_Filter.getClass().getName()) == 0) {
            loadImages = false;
        }
        this.m_Filter = c;
        String filterName = c.getClass().toString();
        filterName = filterName.substring(filterName.indexOf(46) + 1, filterName.length());
        if (loadImages) {
            if (this.m_Filter instanceof Visible) {
                this.m_visual = ((Visible)((Object)this.m_Filter)).getVisual();
            } else if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + filterName + ".gif", "weka/gui/beans/icons/" + filterName + "_animated.gif")) {
                this.useDefaultVisual();
            }
        }
        this.m_visual.setText(filterName.substring(filterName.lastIndexOf(46) + 1, filterName.length()));
        if (this.m_Filter instanceof LogWriter && this.m_log != null) {
            ((LogWriter)((Object)this.m_Filter)).setLog(this.m_log);
        }
        if (!(this.m_Filter instanceof StreamableFilter) && this.m_listenees.containsKey("instance") && this.m_log != null) {
            this.m_log.logMessage("[Filter] " + this.statusMessagePrefix() + " WARNING : " + this.m_Filter.getClass().getName() + " is not an incremental filter");
            this.m_log.statusMessage(this.statusMessagePrefix() + "WARNING: Not an incremental filter.");
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Filter);
    }

    public weka.filters.Filter getFilter() {
        return this.m_Filter;
    }

    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.filters.Filter)) {
            throw new IllegalArgumentException(algorithm.getClass() + " : incorrect " + "type of algorithm (Filter)");
        }
        this.setFilter((weka.filters.Filter)algorithm);
    }

    public Object getWrappedAlgorithm() {
        return this.getFilter();
    }

    public void acceptTrainingSet(TrainingSetEvent e) {
        this.processTrainingOrDataSourceEvents(e);
    }

    public void acceptInstance(InstanceEvent e) {
        if (this.m_filterThread != null) {
            String messg = "[Filter] " + this.statusMessagePrefix() + " is currently batch processing!";
            if (this.m_log != null) {
                this.m_log.logMessage(messg);
                this.m_log.statusMessage(this.statusMessagePrefix() + "WARNING: Filter is currently batch processing.");
            } else {
                System.err.println(messg);
            }
            return;
        }
        if (!(this.m_Filter instanceof StreamableFilter)) {
            this.stop();
            if (this.m_log != null) {
                this.m_log.logMessage("[Filter] " + this.statusMessagePrefix() + " ERROR : " + this.m_Filter.getClass().getName() + "can't process streamed instances; can't continue");
                this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR: Can't process streamed instances; can't continue.");
            }
            return;
        }
        if (e.getStatus() == 0) {
            block46: {
                try {
                    this.m_instanceCount = 0;
                    Instances dataset = e.getStructure();
                    if (this.m_Filter instanceof SupervisedFilter && dataset.classIndex() < 0) {
                        dataset.setClassIndex(dataset.numAttributes() - 1);
                    }
                    this.m_Filter.setInputFormat(dataset);
                    this.m_structurePassedOn = false;
                    try {
                        if (this.m_Filter.isOutputFormatDefined()) {
                            this.m_ie.setStructure(new Instances(this.m_Filter.getOutputFormat(), 0));
                            this.m_ie.m_formatNotificationOnly = e.m_formatNotificationOnly;
                            this.notifyInstanceListeners(this.m_ie);
                            this.m_structurePassedOn = true;
                        }
                    }
                    catch (Exception ex) {
                        this.stop();
                        if (this.m_log != null) {
                            this.m_log.logMessage("[Filter] " + this.statusMessagePrefix() + " Error in obtaining post-filter structure. " + ex.getMessage());
                            this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details).");
                            break block46;
                        }
                        System.err.println("[Filter] " + this.statusMessagePrefix() + " Error in obtaining post-filter structure");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        if (e.getStatus() == 2 || e.getInstance() == null) {
            Instance filteredInstance;
            try {
                if (this.m_log != null) {
                    this.m_log.statusMessage(this.statusMessagePrefix() + "Stream finished.");
                }
                if (e.getInstance() != null && this.m_Filter.input(e.getInstance()) && (filteredInstance = this.m_Filter.output()) != null) {
                    if (!this.m_structurePassedOn) {
                        this.m_ie.setStructure(new Instances(filteredInstance.dataset(), 0));
                        this.notifyInstanceListeners(this.m_ie);
                        this.m_structurePassedOn = true;
                    }
                    this.m_ie.setInstance(filteredInstance);
                    if (this.m_Filter.batchFinished() && this.m_Filter.numPendingOutput() > 0) {
                        this.m_ie.setStatus(1);
                    } else {
                        this.m_ie.setStatus(e.getStatus());
                    }
                    this.notifyInstanceListeners(this.m_ie);
                }
                if (this.m_log != null) {
                    this.m_log.statusMessage(this.statusMessagePrefix() + "Finished.");
                }
            }
            catch (Exception ex) {
                this.stop();
                if (this.m_log != null) {
                    this.m_log.logMessage("[Filter] " + this.statusMessagePrefix() + ex.getMessage());
                    this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details).");
                }
                ex.printStackTrace();
            }
            try {
                if (this.m_Filter.batchFinished() && this.m_Filter.numPendingOutput() > 0) {
                    if (this.m_log != null) {
                        this.m_log.statusMessage(this.statusMessagePrefix() + "Passing on pending instances...");
                    }
                    if ((filteredInstance = this.m_Filter.output()) != null) {
                        if (!this.m_structurePassedOn) {
                            this.m_ie.setStructure((Instances)new SerializedObject(filteredInstance.dataset()).getObject());
                            this.notifyInstanceListeners(this.m_ie);
                            this.m_structurePassedOn = true;
                        }
                        this.m_ie.setInstance(filteredInstance);
                        this.m_ie.setStatus(1);
                        this.notifyInstanceListeners(this.m_ie);
                    }
                    while (this.m_Filter.numPendingOutput() > 0) {
                        filteredInstance = this.m_Filter.output();
                        if (filteredInstance.dataset().checkForStringAttributes()) {
                            for (int i = 0; i < filteredInstance.dataset().numAttributes(); ++i) {
                                if (!filteredInstance.dataset().attribute(i).isString() || filteredInstance.isMissing(i)) continue;
                                String val = filteredInstance.stringValue(i);
                                this.m_ie.getStructure().attribute(i).setStringValue(val);
                                filteredInstance.setValue(i, 0.0);
                            }
                        }
                        filteredInstance.setDataset(this.m_ie.getStructure());
                        this.m_ie.setInstance(filteredInstance);
                        if (this.m_Filter.numPendingOutput() == 0) {
                            this.m_ie.setStatus(2);
                        } else {
                            this.m_ie.setStatus(1);
                        }
                        this.notifyInstanceListeners(this.m_ie);
                    }
                    if (this.m_log != null) {
                        this.m_log.statusMessage(this.statusMessagePrefix() + "Finished.");
                    }
                }
            }
            catch (Exception ex) {
                this.stop();
                if (this.m_log != null) {
                    this.m_log.logMessage("[Filter] " + this.statusMessagePrefix() + ex.toString());
                    this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details.");
                }
                ex.printStackTrace();
            }
        } else {
            try {
                if (!this.m_Filter.input(e.getInstance())) {
                    return;
                }
                Instance filteredInstance = this.m_Filter.output();
                if (filteredInstance == null) {
                    return;
                }
                ++this.m_instanceCount;
                if (!this.m_structurePassedOn) {
                    this.m_ie.setStructure(new Instances(filteredInstance.dataset(), 0));
                    this.notifyInstanceListeners(this.m_ie);
                    this.m_structurePassedOn = true;
                }
                filteredInstance.setDataset(this.m_ie.getStructure());
                if (filteredInstance.dataset().checkForStringAttributes()) {
                    for (int i = 0; i < filteredInstance.dataset().numAttributes(); ++i) {
                        if (!filteredInstance.dataset().attribute(i).isString() || filteredInstance.isMissing(i)) continue;
                        String val = filteredInstance.stringValue(i);
                        filteredInstance.dataset().attribute(i).setStringValue(val);
                        filteredInstance.setValue(i, 0.0);
                    }
                }
                this.m_ie.setInstance(filteredInstance);
                this.m_ie.setStatus(e.getStatus());
                if (this.m_log != null && this.m_instanceCount % 10000 == 0) {
                    this.m_log.statusMessage(this.statusMessagePrefix() + "Received " + this.m_instanceCount + " instances.");
                }
                this.notifyInstanceListeners(this.m_ie);
            }
            catch (Exception ex) {
                this.stop();
                if (this.m_log != null) {
                    this.m_log.logMessage("[Filter] " + this.statusMessagePrefix() + ex.toString());
                    this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details).");
                }
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTrainingOrDataSourceEvents(final EventObject e) {
        block9: {
            boolean structureOnly = false;
            if (e instanceof DataSetEvent && (structureOnly = ((DataSetEvent)e).isStructureOnly())) {
                this.notifyDataOrTrainingListeners(e);
            }
            if (e instanceof TrainingSetEvent && (structureOnly = ((TrainingSetEvent)e).isStructureOnly())) {
                this.notifyDataOrTrainingListeners(e);
            }
            if (structureOnly && !(this.m_Filter instanceof StreamableFilter)) {
                return;
            }
            if (this.m_filterThread == null) {
                try {
                    if (this.m_state != IDLE) break block9;
                    Filter filter = this;
                    synchronized (filter) {
                        this.m_state = FILTERING_TRAINING;
                    }
                    this.m_trainingSet = e instanceof TrainingSetEvent ? ((TrainingSetEvent)e).getTrainingSet() : ((DataSetEvent)e).getDataSet();
                    this.m_filterThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block20: {
                                    try {
                                        EventObject ne;
                                        if (Filter.this.m_trainingSet == null) break block20;
                                        Filter.this.m_visual.setAnimated();
                                        if (Filter.this.m_log != null) {
                                            Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Filtering training data (" + Filter.this.m_trainingSet.relationName() + ")");
                                        }
                                        Filter.this.m_Filter.setInputFormat(Filter.this.m_trainingSet);
                                        Instances filteredData = weka.filters.Filter.useFilter(Filter.this.m_trainingSet, Filter.this.m_Filter);
                                        Filter.this.m_visual.setStatic();
                                        if (e instanceof TrainingSetEvent) {
                                            ne = new TrainingSetEvent(Filter.this, filteredData);
                                            ne.m_setNumber = ((TrainingSetEvent)e).m_setNumber;
                                            ne.m_maxSetNumber = ((TrainingSetEvent)e).m_maxSetNumber;
                                        } else {
                                            ne = new DataSetEvent(Filter.this, filteredData);
                                        }
                                        Filter.this.notifyDataOrTrainingListeners(ne);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        if (Filter.this.m_log != null) {
                                            Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + ex.getMessage());
                                            Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "ERROR (See log for details).");
                                        }
                                        Filter.this.stop();
                                        Object var4_5 = null;
                                        Filter.this.m_visual.setStatic();
                                        Filter.this.m_state = IDLE;
                                        if (this.isInterrupted()) {
                                            Filter.this.m_trainingSet = null;
                                            if (Filter.this.m_log != null) {
                                                Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + " training set interrupted!");
                                                Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "INTERRUPTED");
                                            }
                                        } else if (Filter.this.m_log != null) {
                                            Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Finished.");
                                        }
                                        Filter.this.block(false);
                                        return;
                                    }
                                }
                                Object var4_4 = null;
                                Filter.this.m_visual.setStatic();
                                Filter.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Filter.this.m_trainingSet = null;
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + " training set interrupted!");
                                        Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "INTERRUPTED");
                                    }
                                } else if (Filter.this.m_log != null) {
                                    Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Finished.");
                                }
                                Filter.this.block(false);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                Filter.this.m_visual.setStatic();
                                Filter.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Filter.this.m_trainingSet = null;
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + " training set interrupted!");
                                        Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "INTERRUPTED");
                                    }
                                } else if (Filter.this.m_log != null) {
                                    Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Finished.");
                                }
                                Filter.this.block(false);
                                throw throwable;
                            }
                        }
                    };
                    this.m_filterThread.setPriority(1);
                    this.m_filterThread.start();
                    this.block(true);
                    this.m_filterThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void acceptTestSet(final TestSetEvent e) {
        if (e.isStructureOnly()) {
            this.notifyTestListeners(e);
        }
        if (this.m_trainingSet != null && this.m_trainingSet.equalHeaders(e.getTestSet()) && this.m_filterThread == null) {
            try {
                if (this.m_state == IDLE) {
                    this.m_state = FILTERING_TEST;
                }
                this.m_testingSet = e.getTestSet();
                this.m_filterThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            block18: {
                                try {
                                    if (Filter.this.m_testingSet == null) break block18;
                                    Filter.this.m_visual.setAnimated();
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Filtering test data (" + Filter.this.m_testingSet.relationName() + ")");
                                    }
                                    Instances filteredTest = weka.filters.Filter.useFilter(Filter.this.m_testingSet, Filter.this.m_Filter);
                                    Filter.this.m_visual.setStatic();
                                    TestSetEvent ne = new TestSetEvent(Filter.this, filteredTest);
                                    ne.m_setNumber = e.m_setNumber;
                                    ne.m_maxSetNumber = e.m_maxSetNumber;
                                    Filter.this.notifyTestListeners(ne);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    if (Filter.this.m_log != null) {
                                        Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + ex.getMessage());
                                        Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "ERROR (See log for details).");
                                    }
                                    Filter.this.stop();
                                    Object var4_5 = null;
                                    Filter.this.m_visual.setStatic();
                                    Filter.this.m_state = IDLE;
                                    if (this.isInterrupted()) {
                                        Filter.this.m_trainingSet = null;
                                        if (Filter.this.m_log != null) {
                                            Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + " test set interrupted!");
                                            Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "INTERRUPTED");
                                        }
                                    } else if (Filter.this.m_log != null) {
                                        Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Finished.");
                                    }
                                    Filter.this.block(false);
                                    return;
                                }
                            }
                            Object var4_4 = null;
                            Filter.this.m_visual.setStatic();
                            Filter.this.m_state = IDLE;
                            if (this.isInterrupted()) {
                                Filter.this.m_trainingSet = null;
                                if (Filter.this.m_log != null) {
                                    Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + " test set interrupted!");
                                    Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "INTERRUPTED");
                                }
                            } else if (Filter.this.m_log != null) {
                                Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Finished.");
                            }
                            Filter.this.block(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            Filter.this.m_visual.setStatic();
                            Filter.this.m_state = IDLE;
                            if (this.isInterrupted()) {
                                Filter.this.m_trainingSet = null;
                                if (Filter.this.m_log != null) {
                                    Filter.this.m_log.logMessage("[Filter] " + Filter.this.statusMessagePrefix() + " test set interrupted!");
                                    Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "INTERRUPTED");
                                }
                            } else if (Filter.this.m_log != null) {
                                Filter.this.m_log.statusMessage(Filter.this.statusMessagePrefix() + "Finished.");
                            }
                            Filter.this.block(false);
                            throw throwable;
                        }
                    }
                };
                this.m_filterThread.setPriority(1);
                this.m_filterThread.start();
                this.block(true);
                this.m_filterThread = null;
                this.m_state = IDLE;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void acceptDataSet(DataSetEvent e) {
        this.processTrainingOrDataSourceEvents(e);
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    }

    public synchronized void addTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingListeners.addElement(tsl);
    }

    public synchronized void removeTrainingSetListener(TrainingSetListener tsl) {
        this.m_trainingListeners.removeElement(tsl);
    }

    public synchronized void addTestSetListener(TestSetListener tsl) {
        this.m_testListeners.addElement(tsl);
    }

    public synchronized void removeTestSetListener(TestSetListener tsl) {
        this.m_testListeners.removeElement(tsl);
    }

    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.addElement(dsl);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.remove(dsl);
    }

    public synchronized void addInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.addElement(tsl);
    }

    public synchronized void removeInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.removeElement(tsl);
    }

    public synchronized void addConfigurationListener(ConfigurationListener cl) {
    }

    public synchronized void removeConfigurationListener(ConfigurationListener cl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataOrTrainingListeners(EventObject ce) {
        Vector l;
        Filter filter = this;
        synchronized (filter) {
            l = ce instanceof TrainingSetEvent ? (Vector)this.m_trainingListeners.clone() : (Vector)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                if (ce instanceof TrainingSetEvent) {
                    ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet((TrainingSetEvent)ce);
                    continue;
                }
                ((DataSourceListener)l.elementAt(i)).acceptDataSet((DataSetEvent)ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTestListeners(TestSetEvent ce) {
        Vector l;
        Filter filter = this;
        synchronized (filter) {
            l = (Vector)this.m_testListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TestSetListener)l.elementAt(i)).acceptTestSet(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceListeners(InstanceEvent tse) {
        Vector l;
        Filter filter = this;
        synchronized (filter) {
            l = (Vector)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.elementAt(i)).acceptInstance(tse);
            }
        }
    }

    public boolean connectionAllowed(String eventName) {
        if (this.m_listenees.containsKey(eventName)) {
            return false;
        }
        if (this.m_listenees.containsKey("dataSet") && (eventName.compareTo("trainingSet") == 0 || eventName.compareTo("testSet") == 0 || eventName.compareTo("instance") == 0)) {
            return false;
        }
        if ((this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet")) && (eventName.compareTo("dataSet") == 0 || eventName.compareTo("instance") == 0)) {
            return false;
        }
        if (this.m_listenees.containsKey("instance") && (eventName.compareTo("trainingSet") == 0 || eventName.compareTo("testSet") == 0 || eventName.compareTo("dataSet") == 0)) {
            return false;
        }
        return eventName.compareTo("instance") != 0 || this.m_Filter instanceof StreamableFilter;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenees.put(eventName, source);
            if (this.m_Filter instanceof ConnectionNotificationConsumer) {
                ((ConnectionNotificationConsumer)((Object)this.m_Filter)).connectionNotification(eventName, source);
            }
        }
    }

    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (this.m_Filter instanceof ConnectionNotificationConsumer) {
            ((ConnectionNotificationConsumer)((Object)this.m_Filter)).disconnectionNotification(eventName, source);
        }
        this.m_listenees.remove(eventName);
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_filterThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        Enumeration en = this.m_listenees.keys();
        while (en.hasMoreElements()) {
            Object tempO = this.m_listenees.get(en.nextElement());
            if (!(tempO instanceof BeanCommon)) continue;
            ((BeanCommon)tempO).stop();
        }
        if (this.m_filterThread != null) {
            this.m_filterThread.interrupt();
            this.m_filterThread.stop();
            this.m_filterThread = null;
            this.m_visual.setStatic();
        }
    }

    public boolean isBusy() {
        return this.m_filterThread != null;
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
        if (this.m_Filter != null && this.m_Filter instanceof LogWriter) {
            ((LogWriter)((Object)this.m_Filter)).setLog(this.m_log);
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_filterThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(request + " not supported (Filter)");
        }
        this.stop();
    }

    public boolean eventGeneratable(String eventName) {
        if (eventName.equals("configuration") && this.m_Filter != null) {
            return true;
        }
        if (!this.m_listenees.containsKey(eventName)) {
            return false;
        }
        Object source = this.m_listenees.get(eventName);
        if (source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable(eventName)) {
            return false;
        }
        return eventName.compareTo("instance") != 0 || this.m_Filter instanceof StreamableFilter;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Filter instanceof OptionHandler && Utils.joinOptions(((OptionHandler)((Object)this.m_Filter)).getOptions()).length() > 0 ? Utils.joinOptions(((OptionHandler)((Object)this.m_Filter)).getOptions()) + "|" : "");
    }
}

