/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class SingleClassifierEnhancer
extends AbstractClassifier {
    private static final long serialVersionUID = -3665885256363525164L;
    protected Classifier m_Classifier = new ZeroR();

    protected String defaultClassifierString() {
        return "weka.classifiers.rules.ZeroR";
    }

    protected String[] defaultClassifierOptions() {
        return new String[0];
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tFull name of base classifier.\n\t(default: " + this.defaultClassifierString() + (this.defaultClassifierOptions().length > 0 ? " with options " + Utils.joinOptions(this.defaultClassifierOptions()) + ")" : ")"), "W", 1, "-W"));
        newVector.addAll(Collections.list(super.listOptions()));
        newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
        newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_Classifier)).listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String classifierName = Utils.getOption('W', options);
        if (classifierName.length() > 0) {
            this.setClassifier(AbstractClassifier.forName(classifierName, null));
            this.setClassifier(AbstractClassifier.forName(classifierName, Utils.partitionOptions(options)));
        } else {
            this.setClassifier(AbstractClassifier.forName(this.defaultClassifierString(), null));
            String[] classifierOptions = Utils.partitionOptions(options);
            if (classifierOptions.length > 0) {
                this.setClassifier(AbstractClassifier.forName(this.defaultClassifierString(), classifierOptions));
            } else {
                this.setClassifier(AbstractClassifier.forName(this.defaultClassifierString(), this.defaultClassifierOptions()));
            }
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-W");
        options.add(this.getClassifier().getClass().getName());
        Collections.addAll(options, super.getOptions());
        String[] classifierOptions = ((OptionHandler)((Object)this.m_Classifier)).getOptions();
        if (classifierOptions.length > 0) {
            options.add("--");
            Collections.addAll(options, classifierOptions);
        }
        return options.toArray(new String[0]);
    }

    public String classifierTipText() {
        return "The base classifier to be used.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getClassifier() != null) {
            result = this.getClassifier().getCapabilities();
        } else {
            result = new Capabilities(this);
            result.disableAll();
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        result.setOwner(this);
        return result;
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected String getClassifierSpec() {
        Classifier c = this.getClassifier();
        return c.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions());
    }
}

