/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import weka.classifiers.rules.ZeroR;
import weka.core.Check;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CheckGOE
extends Check {
    protected Object m_Object = new ZeroR();
    protected boolean m_Success;
    protected HashSet<String> m_IgnoredProperties = new HashSet();

    public CheckGOE() {
        try {
            this.setOptions(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tSkipped properties.\n\t(default: capabilities,options)", "ignored", 1, "-ignored <comma-separated list of properties>"));
        result.addElement(new Option("\tFull name of the class analysed.\n\teg: weka.classifiers.rules.ZeroR\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() == 0) {
            tmpStr = ZeroR.class.getName();
        }
        this.setObject(Utils.forName(Object.class, tmpStr, null));
        tmpStr = Utils.getOption("ignored", options);
        if (tmpStr.length() == 0) {
            tmpStr = "capabilities,options";
        }
        this.setIgnoredProperties(tmpStr);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-ignored");
        result.add(this.getIgnoredProperties());
        if (this.getObject() != null) {
            result.add("-W");
            result.add(this.getObject().getClass().getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setObject(Object value) {
        this.m_Object = value;
    }

    public Object getObject() {
        return this.m_Object;
    }

    public void setIgnoredProperties(String value) {
        this.m_IgnoredProperties.clear();
        String[] props = value.split(",");
        for (int i = 0; i < props.length; ++i) {
            this.m_IgnoredProperties.add(props[i]);
        }
    }

    public String getIgnoredProperties() {
        Vector<String> list = new Vector<String>();
        Iterator<String> iter = this.m_IgnoredProperties.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (list.size() > 1) {
            Collections.sort(list);
        }
        String result = "";
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + (String)list.get(i);
        }
        return result;
    }

    public boolean getSuccess() {
        return this.m_Success;
    }

    public boolean checkGlobalInfo() {
        this.print("Global info...");
        boolean result = true;
        Class<?> cls = this.getObject().getClass();
        try {
            cls.getMethod("globalInfo", null);
        }
        catch (Exception e) {
            result = false;
        }
        if (result) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return result;
    }

    public boolean checkToolTips() {
        PropertyDescriptor[] desc;
        this.print("Tool tips...");
        boolean result = true;
        String suffix = "TipText";
        Class<?> cls = this.getObject().getClass();
        try {
            BeanInfo info = Introspector.getBeanInfo(cls, Object.class);
            desc = info.getPropertyDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
            desc = null;
        }
        if (desc != null) {
            Vector<String> missing = new Vector<String>();
            for (int i = 0; i < desc.length; ++i) {
                if (this.m_IgnoredProperties.contains(desc[i].getName()) || desc[i].getReadMethod() == null || desc[i].getWriteMethod() == null) continue;
                try {
                    cls.getMethod(desc[i].getName() + suffix, null);
                    continue;
                }
                catch (Exception e) {
                    result = false;
                    missing.add(desc[i].getName() + suffix);
                }
            }
            if (result) {
                this.println("yes");
            } else {
                this.println("no (missing: " + missing + ")");
            }
        } else {
            this.println("maybe");
        }
        return result;
    }

    public void doTests() {
        this.println("Object: " + this.m_Object.getClass().getName() + "\n");
        this.println("--> Tests");
        this.m_Success = this.checkGlobalInfo();
        if (this.m_Success) {
            this.m_Success = this.checkToolTips();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] args) {
        CheckGOE check = new CheckGOE();
        CheckGOE.runCheck(check, args);
        if (check.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

