/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class Resample
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 3119607037607101160L;
    protected double m_SampleSizePercent = 100.0;
    protected int m_RandomSeed = 1;
    protected boolean m_NoReplacement = false;
    protected boolean m_InvertSelection = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using either sampling with replacement or without replacement. The original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified. When used in batch mode, subsequent batches are NOT resampled.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        result.addElement(new Option("\tDisables replacement of instances\n\t(default: with replacement)", "no-replacement", 0, "-no-replacement"));
        result.addElement(new Option("\tInverts the selection - only available with '-no-replacement'.", "V", 0, "-V"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(1);
        }
        tmpStr = Utils.getOption('Z', options);
        if (tmpStr.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        this.setNoReplacement(Utils.getFlag("no-replacement", options));
        if (this.getNoReplacement()) {
            this.setInvertSelection(Utils.getFlag('V', options));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getRandomSeed());
        result.add("-Z");
        result.add("" + this.getSampleSizePercent());
        if (this.getNoReplacement()) {
            result.add("-no-replacement");
            if (this.getInvertSelection()) {
                result.add("-V");
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String randomSeedTipText() {
        return "The seed used for random sampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int newSeed) {
        this.m_RandomSeed = newSeed;
    }

    public String sampleSizePercentTipText() {
        return "Size of the subsample as a percentage of the original dataset.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double newSampleSizePercent) {
        this.m_SampleSizePercent = newSampleSizePercent;
    }

    public String noReplacementTipText() {
        return "Disables the replacement of instances.";
    }

    public boolean getNoReplacement() {
        return this.m_NoReplacement;
    }

    public void setNoReplacement(boolean value) {
        this.m_NoReplacement = value;
    }

    public String invertSelectionTipText() {
        return "Inverts the selection (only if instances are drawn WITHOUT replacement).";
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public void setInvertSelection(boolean value) {
        this.m_InvertSelection = value;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public void createSubsampleWithReplacement(Random random, int origSize, int sampleSize) {
        for (int i = 0; i < sampleSize; ++i) {
            int index = random.nextInt(origSize);
            this.push((Instance)this.getInputFormat().instance(index).copy());
        }
    }

    public void createSubsampleWithoutReplacement(Random random, int origSize, int sampleSize) {
        int i;
        if (sampleSize > origSize) {
            sampleSize = origSize;
            System.err.println("Resampling with replacement can only use percentage <=100% - Using full dataset!");
        }
        Vector<Integer> indices = new Vector<Integer>(origSize);
        Vector indicesNew = new Vector(sampleSize);
        for (i = 0; i < origSize; ++i) {
            indices.add(i);
        }
        for (i = 0; i < sampleSize; ++i) {
            int index = random.nextInt(indices.size());
            indicesNew.add(indices.get(index));
            indices.remove(index);
        }
        if (this.getInvertSelection()) {
            indicesNew = indices;
        } else {
            Collections.sort(indicesNew);
        }
        for (i = 0; i < indicesNew.size(); ++i) {
            this.push((Instance)this.getInputFormat().instance((Integer)indicesNew.get(i)).copy());
        }
        indices.clear();
        indicesNew.clear();
        indices = null;
        indicesNew = null;
    }

    protected void createSubsample() {
        int origSize = this.getInputFormat().numInstances();
        int sampleSize = (int)((double)origSize * this.m_SampleSizePercent / 100.0);
        Random random = new Random(this.m_RandomSeed);
        if (this.getNoReplacement()) {
            this.createSubsampleWithoutReplacement(random, origSize, sampleSize);
        } else {
            this.createSubsampleWithReplacement(random, origSize, sampleSize);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5499 $");
    }

    public static void main(String[] argv) {
        Resample.runFilter(new Resample(), argv);
    }
}

