/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Random;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class AttributeSelection
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 4170171824147584330L;
    private Instances m_trainInstances;
    private ASEvaluation m_ASEvaluator;
    private ASSearch m_searchMethod;
    private int m_numFolds;
    private StringBuffer m_selectionResults;
    private boolean m_doRank;
    private boolean m_doXval;
    private int m_seed;
    private int m_numToSelect;
    private int[] m_selectedAttributeSet;
    private double[][] m_attributeRanking;
    private AttributeTransformer m_transformer = null;
    private Remove m_attributeFilter = null;
    private double[][] m_rankResults = null;
    private double[] m_subsetResults = null;
    private int m_trials = 0;

    public int numberAttributesSelected() throws Exception {
        int[] att = this.selectedAttributes();
        return att.length - 1;
    }

    public int[] selectedAttributes() throws Exception {
        if (this.m_selectedAttributeSet == null) {
            throw new Exception("Attribute selection has not been performed yet!");
        }
        return this.m_selectedAttributeSet;
    }

    public double[][] rankedAttributes() throws Exception {
        if (this.m_attributeRanking == null) {
            throw new Exception("Ranking has not been performed");
        }
        return this.m_attributeRanking;
    }

    public void setEvaluator(ASEvaluation evaluator) {
        this.m_ASEvaluator = evaluator;
    }

    public void setSearch(ASSearch search) {
        this.m_searchMethod = search;
        if (this.m_searchMethod instanceof RankedOutputSearch) {
            this.setRanking(((RankedOutputSearch)((Object)this.m_searchMethod)).getGenerateRanking());
        }
    }

    public void setFolds(int folds) {
        this.m_numFolds = folds;
    }

    public void setRanking(boolean r) {
        this.m_doRank = r;
    }

    public void setXval(boolean x) {
        this.m_doXval = x;
    }

    public void setSeed(int s) {
        this.m_seed = s;
    }

    public String toResultsString() {
        return this.m_selectionResults.toString();
    }

    public Instances reduceDimensionality(Instances in) throws Exception {
        if (this.m_attributeFilter == null) {
            throw new Exception("No feature selection has been performed yet!");
        }
        if (this.m_transformer != null) {
            Instances transformed = new Instances(this.m_transformer.transformedHeader(), in.numInstances());
            for (int i = 0; i < in.numInstances(); ++i) {
                transformed.add(this.m_transformer.convertInstance(in.instance(i)));
            }
            return Filter.useFilter(transformed, this.m_attributeFilter);
        }
        return Filter.useFilter(in, this.m_attributeFilter);
    }

    public Instance reduceDimensionality(Instance in) throws Exception {
        if (this.m_attributeFilter == null) {
            throw new Exception("No feature selection has been performed yet!");
        }
        if (this.m_transformer != null) {
            in = this.m_transformer.convertInstance(in);
        }
        this.m_attributeFilter.input(in);
        this.m_attributeFilter.batchFinished();
        Instance result = this.m_attributeFilter.output();
        return result;
    }

    public AttributeSelection() {
        this.setFolds(10);
        this.setRanking(false);
        this.setXval(false);
        this.setSeed(1);
        this.setEvaluator(new CfsSubsetEval());
        this.setSearch(new GreedyStepwise());
        this.m_selectionResults = new StringBuffer();
        this.m_selectedAttributeSet = null;
        this.m_attributeRanking = null;
    }

    public static String SelectAttributes(ASEvaluation ASEvaluator, String[] options) throws Exception {
        String trainFileName;
        Instances train = null;
        ASSearch searchMethod = null;
        String[] optionsTmp = (String[])options.clone();
        boolean helpRequested = false;
        try {
            trainFileName = Utils.getOption('i', options);
            helpRequested = Utils.getFlag('h', optionsTmp);
            if (helpRequested || trainFileName.length() == 0) {
                String searchName = Utils.getOption('s', optionsTmp);
                if (searchName.length() != 0) {
                    String[] searchOptions = Utils.splitOptions(searchName);
                    searchMethod = (ASSearch)Class.forName(searchOptions[0]).newInstance();
                }
                if (helpRequested) {
                    throw new Exception("Help requested.");
                }
                throw new Exception("No training file given.");
            }
        }
        catch (Exception e) {
            throw new Exception('\n' + e.getMessage() + AttributeSelection.makeOptionString(ASEvaluator, searchMethod));
        }
        ConverterUtils.DataSource source = new ConverterUtils.DataSource(trainFileName);
        train = source.getDataSet();
        return AttributeSelection.SelectAttributes(ASEvaluator, options, train);
    }

    public String CVResultsString() throws Exception {
        StringBuffer CvString = new StringBuffer();
        if (this.m_subsetResults == null && this.m_rankResults == null || this.m_trainInstances == null) {
            throw new Exception("Attribute selection has not been performed yet!");
        }
        int fieldWidth = (int)(Math.log(this.m_trainInstances.numAttributes()) + 1.0);
        CvString.append("\n\n=== Attribute selection " + this.m_numFolds + " fold cross-validation ");
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) && this.m_trainInstances.classAttribute().isNominal()) {
            CvString.append("(stratified), seed: ");
            CvString.append(this.m_seed + " ===\n\n");
        } else {
            CvString.append("seed: " + this.m_seed + " ===\n\n");
        }
        if (this.m_searchMethod instanceof RankedOutputSearch && this.m_doRank) {
            CvString.append("average merit      average rank  attribute\n");
            for (int i = 0; i < this.m_rankResults[0].length; ++i) {
                double[] dArray = this.m_rankResults[0];
                int n = i;
                dArray[n] = dArray[n] / (double)this.m_numFolds;
                double var = this.m_rankResults[0][i] * this.m_rankResults[0][i] * (double)this.m_numFolds;
                var = this.m_rankResults[2][i] - var;
                if ((var /= (double)this.m_numFolds) <= 0.0) {
                    var = 0.0;
                    this.m_rankResults[2][i] = 0.0;
                } else {
                    this.m_rankResults[2][i] = Math.sqrt(var);
                }
                double[] dArray2 = this.m_rankResults[1];
                int n2 = i;
                dArray2[n2] = dArray2[n2] / (double)this.m_numFolds;
                var = this.m_rankResults[1][i] * this.m_rankResults[1][i] * (double)this.m_numFolds;
                var = this.m_rankResults[3][i] - var;
                var /= (double)this.m_numFolds;
                if (var <= 0.0) {
                    var = 0.0;
                    this.m_rankResults[3][i] = 0.0;
                    continue;
                }
                this.m_rankResults[3][i] = Math.sqrt(var);
            }
            int[] s = Utils.sort(this.m_rankResults[1]);
            for (int i = 0; i < s.length; ++i) {
                if (!(this.m_rankResults[1][s[i]] > 0.0)) continue;
                CvString.append(Utils.doubleToString(Math.abs(this.m_rankResults[0][s[i]]), 6, 3) + " +-" + Utils.doubleToString(this.m_rankResults[2][s[i]], 6, 3) + "   " + Utils.doubleToString(this.m_rankResults[1][s[i]], fieldWidth + 2, 1) + " +-" + Utils.doubleToString(this.m_rankResults[3][s[i]], 5, 2) + "  " + Utils.doubleToString(s[i] + 1, fieldWidth, 0) + " " + this.m_trainInstances.attribute(s[i]).name() + "\n");
            }
        } else {
            CvString.append("number of folds (%)  attribute\n");
            for (int i = 0; i < this.m_subsetResults.length; ++i) {
                if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && i == this.m_trainInstances.classIndex()) continue;
                CvString.append(Utils.doubleToString(this.m_subsetResults[i], 12, 0) + "(" + Utils.doubleToString(this.m_subsetResults[i] / (double)this.m_numFolds * 100.0, 3, 0) + " %)  " + Utils.doubleToString(i + 1, fieldWidth, 0) + " " + this.m_trainInstances.attribute(i).name() + "\n");
            }
        }
        return CvString.toString();
    }

    public void selectAttributesCVSplit(Instances split) throws Exception {
        double[][] attributeRanking = null;
        if (this.m_trainInstances == null) {
            this.m_trainInstances = split;
        }
        if (this.m_rankResults == null && this.m_subsetResults == null) {
            this.m_subsetResults = new double[split.numAttributes()];
            this.m_rankResults = new double[4][split.numAttributes()];
        }
        this.m_ASEvaluator.buildEvaluator(split);
        int[] attributeSet = this.m_searchMethod.search(this.m_ASEvaluator, split);
        attributeSet = this.m_ASEvaluator.postProcess(attributeSet);
        if (this.m_searchMethod instanceof RankedOutputSearch && this.m_doRank) {
            attributeRanking = ((RankedOutputSearch)((Object)this.m_searchMethod)).rankedAttributes();
            for (int j = 0; j < attributeRanking.length; ++j) {
                double[] dArray = this.m_rankResults[0];
                int n = (int)attributeRanking[j][0];
                dArray[n] = dArray[n] + attributeRanking[j][1];
                double[] dArray2 = this.m_rankResults[2];
                int n2 = (int)attributeRanking[j][0];
                dArray2[n2] = dArray2[n2] + attributeRanking[j][1] * attributeRanking[j][1];
                double[] dArray3 = this.m_rankResults[1];
                int n3 = (int)attributeRanking[j][0];
                dArray3[n3] = dArray3[n3] + (double)(j + 1);
                double[] dArray4 = this.m_rankResults[3];
                int n4 = (int)attributeRanking[j][0];
                dArray4[n4] = dArray4[n4] + (double)((j + 1) * (j + 1));
            }
        } else {
            for (int j = 0; j < attributeSet.length; ++j) {
                int n = attributeSet[j];
                this.m_subsetResults[n] = this.m_subsetResults[n] + 1.0;
            }
        }
        ++this.m_trials;
    }

    public String CrossValidateAttributes() throws Exception {
        Instances cvData = new Instances(this.m_trainInstances);
        Random random = new Random(this.m_seed);
        cvData.randomize(random);
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) && cvData.classAttribute().isNominal()) {
            cvData.stratify(this.m_numFolds);
        }
        for (int i = 0; i < this.m_numFolds; ++i) {
            Instances train = cvData.trainCV(this.m_numFolds, i, random);
            this.selectAttributesCVSplit(train);
        }
        return this.CVResultsString();
    }

    public void SelectAttributes(Instances data) throws Exception {
        this.m_transformer = null;
        this.m_attributeFilter = null;
        this.m_trainInstances = data;
        if (this.m_doXval && this.m_ASEvaluator instanceof AttributeTransformer) {
            throw new Exception("Can't cross validate an attribute transformer.");
        }
        if (this.m_ASEvaluator instanceof SubsetEvaluator && this.m_searchMethod instanceof Ranker) {
            throw new Exception(this.m_ASEvaluator.getClass().getName() + " must use a search method other than Ranker");
        }
        if (this.m_ASEvaluator instanceof AttributeEvaluator && !(this.m_searchMethod instanceof Ranker)) {
            throw new Exception("AttributeEvaluators must use the Ranker search method");
        }
        if (this.m_searchMethod instanceof RankedOutputSearch) {
            this.m_doRank = ((RankedOutputSearch)((Object)this.m_searchMethod)).getGenerateRanking();
        }
        if (!(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && this.m_trainInstances.classIndex() < 0) {
            this.m_trainInstances.setClassIndex(this.m_trainInstances.numAttributes() - 1);
        }
        this.m_ASEvaluator.buildEvaluator(this.m_trainInstances);
        if (this.m_ASEvaluator instanceof AttributeTransformer) {
            this.m_trainInstances = ((AttributeTransformer)((Object)this.m_ASEvaluator)).transformedHeader();
            this.m_transformer = (AttributeTransformer)((Object)this.m_ASEvaluator);
        }
        int fieldWidth = (int)(Math.log(this.m_trainInstances.numAttributes()) + 1.0);
        int[] attributeSet = this.m_searchMethod.search(this.m_ASEvaluator, this.m_trainInstances);
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.m_searchMethod.getClass());
            PropertyDescriptor[] properties = bi.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                Class[] args;
                ASEvaluation tempEval;
                String name = properties[i].getDisplayName();
                Method meth = properties[i].getReadMethod();
                Class<?> retType = meth.getReturnType();
                if (!retType.equals(ASEvaluation.class) || !((tempEval = (ASEvaluation)meth.invoke((Object)this.m_searchMethod, (Object[])(args = new Class[0]))) instanceof AttributeTransformer)) continue;
                this.m_trainInstances = ((AttributeTransformer)((Object)tempEval)).transformedHeader();
                this.m_transformer = (AttributeTransformer)((Object)tempEval);
            }
        }
        catch (IntrospectionException ex) {
            System.err.println("AttributeSelection: Couldn't introspect");
        }
        attributeSet = this.m_ASEvaluator.postProcess(attributeSet);
        if (!this.m_doRank) {
            this.m_selectionResults.append(this.printSelectionResults());
        }
        if (this.m_searchMethod instanceof RankedOutputSearch && this.m_doRank) {
            int i;
            this.m_attributeRanking = ((RankedOutputSearch)((Object)this.m_searchMethod)).rankedAttributes();
            this.m_selectionResults.append(this.printSelectionResults());
            this.m_selectionResults.append("Ranked attributes:\n");
            this.m_numToSelect = ((RankedOutputSearch)((Object)this.m_searchMethod)).getCalculatedNumToSelect();
            int f_p = 0;
            int w_p = 0;
            for (i = 0; i < this.m_numToSelect; ++i) {
                double precision = Math.abs(this.m_attributeRanking[i][1]) - (double)((int)Math.abs(this.m_attributeRanking[i][1]));
                double intPart = (int)Math.abs(this.m_attributeRanking[i][1]);
                if (precision > 0.0) {
                    precision = Math.abs(Math.log(Math.abs(precision)) / Math.log(10.0)) + 3.0;
                }
                if (precision > (double)f_p) {
                    f_p = (int)precision;
                }
                if (intPart == 0.0) {
                    if (w_p >= 2) continue;
                    w_p = 2;
                    continue;
                }
                if (!(Math.abs(Math.log(Math.abs(this.m_attributeRanking[i][1])) / Math.log(10.0)) + 1.0 > (double)w_p) || !(this.m_attributeRanking[i][1] > 0.0)) continue;
                w_p = (int)Math.abs(Math.log(Math.abs(this.m_attributeRanking[i][1])) / Math.log(10.0)) + 1;
            }
            for (i = 0; i < this.m_numToSelect; ++i) {
                this.m_selectionResults.append(Utils.doubleToString(this.m_attributeRanking[i][1], f_p + w_p + 1, f_p) + Utils.doubleToString(this.m_attributeRanking[i][0] + 1.0, fieldWidth + 1, 0) + " " + this.m_trainInstances.attribute((int)this.m_attributeRanking[i][0]).name() + "\n");
            }
            if (this.m_trainInstances.classIndex() >= 0) {
                if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) || this.m_ASEvaluator instanceof AttributeTransformer) {
                    this.m_selectedAttributeSet = new int[this.m_numToSelect + 1];
                    this.m_selectedAttributeSet[this.m_numToSelect] = this.m_trainInstances.classIndex();
                } else {
                    this.m_selectedAttributeSet = new int[this.m_numToSelect];
                }
            } else {
                this.m_selectedAttributeSet = new int[this.m_numToSelect];
            }
            this.m_selectionResults.append("\nSelected attributes: ");
            for (i = 0; i < this.m_numToSelect; ++i) {
                this.m_selectedAttributeSet[i] = (int)this.m_attributeRanking[i][0];
                if (i == this.m_numToSelect - 1) {
                    this.m_selectionResults.append((int)this.m_attributeRanking[i][0] + 1 + " : " + (i + 1) + "\n");
                    continue;
                }
                this.m_selectionResults.append((int)this.m_attributeRanking[i][0] + 1);
                this.m_selectionResults.append(",");
            }
        } else {
            int i;
            if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) || this.m_trainInstances.classIndex() >= 0) {
                this.m_selectedAttributeSet = new int[attributeSet.length + 1];
                this.m_selectedAttributeSet[attributeSet.length] = this.m_trainInstances.classIndex();
            } else {
                this.m_selectedAttributeSet = new int[attributeSet.length];
            }
            for (i = 0; i < attributeSet.length; ++i) {
                this.m_selectedAttributeSet[i] = attributeSet[i];
            }
            this.m_selectionResults.append("Selected attributes: ");
            for (i = 0; i < attributeSet.length; ++i) {
                if (i == attributeSet.length - 1) {
                    this.m_selectionResults.append(attributeSet[i] + 1 + " : " + attributeSet.length + "\n");
                    continue;
                }
                this.m_selectionResults.append(attributeSet[i] + 1 + ",");
            }
            for (i = 0; i < attributeSet.length; ++i) {
                this.m_selectionResults.append("                     " + this.m_trainInstances.attribute(attributeSet[i]).name() + "\n");
            }
        }
        if (this.m_doXval) {
            this.m_selectionResults.append(this.CrossValidateAttributes());
        }
        if (this.m_selectedAttributeSet != null && !this.m_doXval) {
            this.m_attributeFilter = new Remove();
            this.m_attributeFilter.setAttributeIndicesArray(this.m_selectedAttributeSet);
            this.m_attributeFilter.setInvertSelection(true);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
        }
        this.m_trainInstances = new Instances(this.m_trainInstances, 0);
    }

    public static String SelectAttributes(ASEvaluation ASEvaluator, String[] options, Instances train) throws Exception {
        int seed = 1;
        int folds = 10;
        String[] searchOptions = null;
        ASSearch searchMethod = null;
        boolean doCrossVal = false;
        int classIndex = -1;
        boolean helpRequested = false;
        AttributeSelection trainSelector = new AttributeSelection();
        try {
            String searchClassName;
            String foldsString;
            String classString;
            if (Utils.getFlag('h', options)) {
                helpRequested = true;
            }
            if (train.classIndex() != -1) {
                classIndex = train.classIndex() + 1;
            }
            if ((classString = Utils.getOption('c', options)).length() != 0) {
                classIndex = classString.equals("first") ? 1 : (classString.equals("last") ? train.numAttributes() : Integer.parseInt(classString));
            }
            if (classIndex != -1 && (classIndex == 0 || classIndex > train.numAttributes())) {
                throw new Exception("Class index out of range.");
            }
            if (classIndex != -1) {
                train.setClassIndex(classIndex - 1);
            }
            if ((foldsString = Utils.getOption('x', options)).length() != 0) {
                folds = Integer.parseInt(foldsString);
                doCrossVal = true;
            }
            trainSelector.setFolds(folds);
            trainSelector.setXval(doCrossVal);
            String seedString = Utils.getOption('n', options);
            if (seedString.length() != 0) {
                seed = Integer.parseInt(seedString);
            }
            trainSelector.setSeed(seed);
            String searchName = Utils.getOption('s', options);
            if (searchName.length() == 0 && !(ASEvaluator instanceof AttributeEvaluator)) {
                throw new Exception("No search method given.");
            }
            if (searchName.length() != 0) {
                searchName = searchName.trim();
                int breakLoc = searchName.indexOf(32);
                searchClassName = searchName;
                String searchOptionsString = "";
                if (breakLoc != -1) {
                    searchClassName = searchName.substring(0, breakLoc);
                    searchOptionsString = searchName.substring(breakLoc).trim();
                    searchOptions = Utils.splitOptions(searchOptionsString);
                }
            } else {
                try {
                    searchClassName = new String("weka.attributeSelection.Ranker");
                    searchMethod = (ASSearch)Class.forName(searchClassName).newInstance();
                }
                catch (Exception e) {
                    throw new Exception("Can't create Ranker object");
                }
            }
            if (searchMethod == null) {
                searchMethod = ASSearch.forName(searchClassName, searchOptions);
            }
            trainSelector.setSearch(searchMethod);
        }
        catch (Exception e) {
            throw new Exception('\n' + e.getMessage() + AttributeSelection.makeOptionString(ASEvaluator, searchMethod));
        }
        try {
            if (ASEvaluator instanceof OptionHandler) {
                ((OptionHandler)((Object)ASEvaluator)).setOptions(options);
            }
        }
        catch (Exception e) {
            throw new Exception("\n" + e.getMessage() + AttributeSelection.makeOptionString(ASEvaluator, searchMethod));
        }
        try {
            Utils.checkForRemainingOptions(options);
        }
        catch (Exception e) {
            throw new Exception('\n' + e.getMessage() + AttributeSelection.makeOptionString(ASEvaluator, searchMethod));
        }
        if (helpRequested) {
            System.out.println(AttributeSelection.makeOptionString(ASEvaluator, searchMethod));
            System.exit(0);
        }
        trainSelector.setEvaluator(ASEvaluator);
        trainSelector.SelectAttributes(train);
        return trainSelector.toResultsString();
    }

    private String printSelectionResults() {
        StringBuffer text = new StringBuffer();
        text.append("\n\n=== Attribute Selection on all input data ===\n\nSearch Method:\n");
        text.append(this.m_searchMethod.toString());
        text.append("\nAttribute ");
        if (this.m_ASEvaluator instanceof SubsetEvaluator) {
            text.append("Subset Evaluator (");
        } else {
            text.append("Evaluator (");
        }
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator)) {
            text.append("supervised, ");
            text.append("Class (");
            if (this.m_trainInstances.attribute(this.m_trainInstances.classIndex()).isNumeric()) {
                text.append("numeric): ");
            } else {
                text.append("nominal): ");
            }
            text.append(this.m_trainInstances.classIndex() + 1 + " " + this.m_trainInstances.attribute(this.m_trainInstances.classIndex()).name() + "):\n");
        } else {
            text.append("unsupervised):\n");
        }
        text.append(this.m_ASEvaluator.toString() + "\n");
        return text.toString();
    }

    private static String makeOptionString(ASEvaluation ASEvaluator, ASSearch searchMethod) throws Exception {
        Option option;
        Enumeration enu;
        StringBuffer optionsText = new StringBuffer("");
        optionsText.append("\n\nGeneral options:\n\n");
        optionsText.append("-h\n\tdisplay this help\n");
        optionsText.append("-i <name of input file>\n");
        optionsText.append("\tSets training file.\n");
        optionsText.append("-c <class index>\n");
        optionsText.append("\tSets the class index for supervised attribute\n");
        optionsText.append("\tselection. Default=last column.\n");
        optionsText.append("-s <class name>\n");
        optionsText.append("\tSets search method for subset evaluators.\n");
        optionsText.append("-x <number of folds>\n");
        optionsText.append("\tPerform a cross validation.\n");
        optionsText.append("-n <random number seed>\n");
        optionsText.append("\tUse in conjunction with -x.\n");
        if (ASEvaluator instanceof OptionHandler) {
            optionsText.append("\nOptions specific to " + ASEvaluator.getClass().getName() + ":\n\n");
            enu = ((OptionHandler)((Object)ASEvaluator)).listOptions();
            while (enu.hasMoreElements()) {
                option = (Option)enu.nextElement();
                optionsText.append(option.synopsis() + '\n');
                optionsText.append(option.description() + "\n");
            }
        }
        if (searchMethod != null) {
            if (searchMethod instanceof OptionHandler) {
                optionsText.append("\nOptions specific to " + searchMethod.getClass().getName() + ":\n\n");
                enu = ((OptionHandler)((Object)searchMethod)).listOptions();
                while (enu.hasMoreElements()) {
                    option = (Option)enu.nextElement();
                    optionsText.append(option.synopsis() + '\n');
                    optionsText.append(option.description() + "\n");
                }
            }
        } else if (ASEvaluator instanceof SubsetEvaluator) {
            System.out.println("No search method given.");
        }
        return optionsText.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("The first argument must be the name of an attribute/subset evaluator");
            }
            String EvaluatorName = args[0];
            args[0] = "";
            ASEvaluation newEval = ASEvaluation.forName(EvaluatorName, null);
            System.out.println(AttributeSelection.SelectAttributes(newEval, args));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.47 $");
    }
}

