/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.util.List;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.Perspective;
import weka.gui.knowledgeflow.AbstractGraphicalCommand;
import weka.gui.knowledgeflow.MainKFPerspective;

public class SendToPerspectiveGraphicalCommand
extends AbstractGraphicalCommand {
    public static final String SEND_TO_PERSPECTIVE_COMMAND_KEY = "sendToPerspective";
    protected MainKFPerspective m_mainPerspective;

    @Override
    public void setGraphicalEnvironment(Object graphicalEnvironment) {
        super.setGraphicalEnvironment(graphicalEnvironment);
        if (graphicalEnvironment instanceof MainKFPerspective) {
            this.m_mainPerspective = (MainKFPerspective)graphicalEnvironment;
        }
    }

    @Override
    public String getCommandName() {
        return SEND_TO_PERSPECTIVE_COMMAND_KEY;
    }

    @Override
    public String getCommandDescription() {
        return "Send the supplied instances to the named perspective";
    }

    public Object performCommand(Object ... commandArgs) throws WekaException {
        if (commandArgs.length != 2 && !(commandArgs[1] instanceof Instances)) {
            throw new WekaException("Was expecting two arguments: 1) perspective name, and 2) argument of type weka.core.Instances");
        }
        Instances toSend = (Instances)commandArgs[1];
        String perspectiveName = commandArgs[0].toString();
        List<Perspective> perspectives = this.m_mainPerspective.getMainApplication().getPerspectiveManager().getVisiblePerspectives();
        Perspective target = null;
        String targetID = null;
        for (Perspective p : perspectives) {
            if (!p.acceptsInstances() || !p.getPerspectiveTitle().equalsIgnoreCase(perspectiveName)) continue;
            targetID = p.getPerspectiveID();
            target = p;
            break;
        }
        if (target == null) {
            throw new WekaException("Was unable to find requested perspective");
        }
        target.setInstances(toSend);
        this.m_mainPerspective.getMainApplication().getPerspectiveManager().setActivePerspective(targetID);
        this.m_mainPerspective.getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(targetID, true);
        return null;
    }
}

