% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_inun.R
\name{p_inun}
\alias{p_inun}
\alias{p_incrandb}
\alias{p_inun_crandb}
\title{List of Installed, Uninstalled and Non-Existing Packages}
\usage{
p_incrandb(..., char = NULL, crandb = get("crandb", envir = .GlobalEnv))

p_inun(..., char = NULL)

p_inun_crandb(..., char = NULL, crandb = get("crandb", envir = .GlobalEnv))
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, including list.
A vector or a list of packages.}

\item{char}{(name to) a character vector or a list. Use this argument if 
\code{...} fails or if you call the function from another function. 
If used, argument \code{...} is ignored.}

\item{crandb}{data.frame \code{crandb}.}
}
\description{
\code{p_incrandb} returns TRUE if all packages are listed in \code{crandb} and a vector 
of FALSE with the names of the packages not listed in \code{crandb}.

\code{p_inun} returns a list of packages installed or not installed in the computer.

\code{p_inun_crandb} checks if the packages exist or do not exist 
in \code{crandb} (see CRAN archives, Bioconductor, Github, your own packages).

The missing packages available on CRAN can be downloaded with \code{\link{p_down0}}, 
downloaded and checked (by R CMD check) with \code{xfun::rev_check} or installed 
with \code{install.packages}. The packages removed from CRAN but available in
CRAN archive can be downloaded with \code{\link{p_downarch}}.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))

## Check if packages are installed or not, and exist or not in crandb
p_incrandb(RWsearch, NotAPkg1, pacman, NotAPkg2, sos) 
p_inun(RWsearch, NotAPkg1, pacman, NotAPkg2, sos) 
p_inun_crandb(RWsearch, NotAPkg1, pacman, NotAPkg2, sos)  

}
