% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_sos.R
\name{s_sos}
\alias{s_sos}
\alias{s_man}
\alias{s_Rman}
\title{Search Packages and Functions on R-Project Help pages and RDocumentation}
\usage{
s_sos(..., char = NULL)

s_man(..., char = NULL)

s_Rman(..., char = NULL)
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, except list.
One or several keywords.}

\item{char}{(name to) a character vector. Use this argument if \code{...} fails
or if you call the function from another function. If used,
argument \code{...} is ignored.}
}
\description{
\code{s_sos} searchs in all R documentation packages and functions that contain
one or several keywords, open the default browser and display the results in a html page.
For one or two keywords, \code{s_sos} may find more results than \code{\link{s_crandb}}
as it goes deeper in the documentation, down to the function level. An internet
connection is required to reach the website maintained by the R-Project.
This service replaces the one maintained by the University of Pennsylvania up to 2021.

\code{s_sos} is a minimal wrapper of the function \emph{sos::findFn}.
Use directly the package \emph{sos} and read its vignette for advanced search options.

\code{s_man} and \code{s_Rman} display the results in the query's raw format.
}
\examples{
## Search using standard or non-standard content
## and display the results in a browser.
if (interactive()) {
s_sos("chemical reaction")
(res <- s_sos(distillation))
tail(data.frame(res))
s_man("cran_incoming")
}
}
\seealso{
\url{https://search.r-project.org} to search for functions rather than packages,

          \url{https://CRAN.R-project.org/package=sos} (index and vignette).
}
