  require(RXshrink)
  #
  # Read in the Portland Cement data.frame...
  data(haldport)
  #
  # Next, define a regression model formula...
  form <- heat~p3ca+p3cs+p4caf+p2cs
  #
  # First, perform QM (2-parameter) generalized Ridge Shrinkage...
  rxqmobj <- qm.ridge(form, data=haldport)
  #
  # Display all 5 qm.ridge() TRACE Diagnostics in 1 plot...
  plot(rxqmobj)
  #
  # Print qm.ridge() Summary Statistics...
  rxqmobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from qm.ridge()...
  #
  # Next, results for (augmented) Least Angle Regression,
  # aug.lars(), will be PLOTTED and PRINTED...
  #
  # Perform Augmented lars() model fitting...  
  rxlaobj <- aug.lars(form, data=haldport)
  #
  # Display all 5 aug.lars() TRACE Diagnostics in 1 plot...
  plot(rxlaobj)
  #
  # Print Summary Statistics from aug.lars()...
  rxlaobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from aug.lars()...
  #
  # Next, results from RX augmented lars() model fitting to the
  # Uncorrelated Components of the haldport data.frame, 
  # uc.lars(), will be PLOTTED and PRINTED...  
  #
  # Perform uc.lars() model fitting...  
  rxucobj <- uc.lars(form, data=haldport)
  #
  # Display all 5 uc.lars() TRACE Diagnostics in 1 plot...
  plot(rxucobj)
  #
  # Print Summary Statistics from uc.lars()...
  rxucobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from uc.lars()...
  #
  # Finally, results for UNRESTRICTED (p-parameter)
  # generalized ridge regression (GRR) model-fitting,
  # unr.ridge() or eff.ridge() , will be PLOTTED and PRINTED...  
  #
  # Perform unr.ridge() model fitting...  
  rxunobj <- unr.ridge(form, data=haldport)
  #
  # Display all 5 unr.ridge() TRACE Diagnostics in 1 plot...
  plot(rxunobj)
  #
  # Print Summary Statistics from unr.ridge()...  
  rxunobj
  #
  # Perform eff.ridge() model fitting...  
  rxefobj <- eff.ridge(form, data=haldport)
  #
  # Display all 5 unr.ridge() TRACE Diagnostics in 1 plot...
  plot(rxefobj)
  #
  # Print Summary Statistics from unr.ridge()...  
  rxefobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from unr.ridge() and eff.ridge()...
  #
  # Did you notice how DIFFERENT these FIVE main types of GRR Paths
  # [qm.ridge(), aug.lars() uc.lars() and unr.ridge() or eff.ridge()] LOOK
  # for the "haldport" data.frame? Any of these 5 DISTINCT types of Shrinkage
  # "pattern" could be "best" for a given set of ill-conditioned
  # (confounded) X-variables.
  #
  # Since the unr.ridge() and eff.ridge() Paths are "most flexible" and
  # always contain the beta-coefficient vector with Maximum Overall Normal
  # theory Likelihood of Minimal MSE risk, a good strategy is to explore
  # these 2 PATHS First !!!
  #
  #################### END of "haldport" Demo...
  