% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{optimizeMap}
\alias{optimizeMap}
\title{Optimize an acmap}
\usage{
optimizeMap(
  map,
  number_of_dimensions,
  number_of_optimizations,
  minimum_column_basis = "none",
  fixed_column_bases = NULL,
  titer_weights = NULL,
  sort_optimizations = TRUE,
  check_convergence = TRUE,
  verbose = TRUE,
  options = list()
)
}
\arguments{
\item{map}{The acmap data object}

\item{number_of_dimensions}{The number of dimensions for the new map}

\item{number_of_optimizations}{The number of optimization runs to perform}

\item{minimum_column_basis}{The minimum column basis to use (see details)}

\item{fixed_column_bases}{A vector of fixed values to use as column bases
directly, rather than calculating them from the titer table.}

\item{titer_weights}{An optional matrix of weights to assign each titer when optimizing}

\item{sort_optimizations}{Should optimizations be sorted by stress
afterwards?}

\item{check_convergence}{Should a basic check for convergence of lowest stress
optimization runs onto a similar solution be performed.}

\item{verbose}{Should progress messages be reported, see also
\code{RacOptimizer.options()}}

\item{options}{List of named optimizer options, see \code{RacOptimizer.options()}}
}
\value{
Returns the acmap object updated with new optimizations.
}
\description{
Take an acmap object with a table of titer data and perform optimization runs
to try and find the best arrangement of antigens and sera to represent their
antigenic similarity. Optimizations generated from each run with different
random starting conditions will be added to the acmap object.
}
\details{
This is the core function to run map optimizations. In essence, for
each optimization run, points are randomly distributed in n-dimensional
space, the L-BFGS gradient-based optimization algorithm is applied to move
points into an optimal position. Depending on the map, this may not be a
trivial optimization process and results will depend upon the starting
conditions so multiple optimization runs may be required. For a full
explanation see \code{vignette("intro-to-antigenic-cartography")}.
\subsection{Minimum column basis and fixed column bases}{

Fixed column bases is a vector of fixed column bases for each sera, where
NA is specified (the default) column bases will be calculated according to
the \code{minimum_column_basis} setting. Again for a full explanation of column
bases and what they mean see \code{vignette("intro-to-antigenic-cartography")}.
}
}
\seealso{
See \code{relaxMap()} for optimizing a given optimization starting from
its current coordinates.

Other map optimization functions: 
\code{\link{RacOptimizer.options}()},
\code{\link{make.acmap}()},
\code{\link{moveTrappedPoints}()},
\code{\link{randomizeCoords}()},
\code{\link{relaxMapOneStep}()},
\code{\link{relaxMap}()}
}
\concept{map optimization functions}
