% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_hyd_plot.R
\name{rvn_hyd_plot}
\alias{rvn_hyd_plot}
\title{Create Hydrograph Plot}
\usage{
rvn_hyd_plot(
  sim = NULL,
  obs = NULL,
  inflow = NULL,
  precip = NULL,
  prd = NULL,
  winter_shading = FALSE,
  wsdates = c(12, 1, 3, 31)
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{inflow}{time series object of inflows to subbasin}

\item{precip}{time series object of precipitation}

\item{prd}{period to use in plotting}

\item{winter_shading}{optionally adds shading for winter months (default FALSE)}

\item{wsdates}{integer vector of winter shading period dates (see details)}
}
\value{
\item{p1}{returns ggplot plot object}
}
\description{
rvn_hyd_plot creates a hydrograph plot object for the supplied flow series, or
equivalently a stage plot for reservoir stages.
}
\details{
This function creates a hydrograph plot using the supplied time series; any
series not supplied will not be plotted. If the precip time series is
supplied, the secondary y axis will be used to plot the precip time series.

The function assumes that the supplied time series have the same length and
duration in time. If this is not true, then the defined period or period
calculated from the first available flow series will be used to determine
the plotting limits in time. If the data is used directly from Raven output,
this is not a concern. The supplied time series should be in xts format,
which again can be obtained directly by using the hyd.extract function.

The winter_shading argument will add a transparent grey shading for the
specified period by wsdates in each year that is plotted.

wsdates is formatted as c(winter start month, winter start day, winter end month, winter end day).

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
ff <- system.file("extdata","run1_Hydrographs.csv", package="RavenR")
run1 <- rvn_hyd_read(ff)
sim <- run1$hyd$Sub36
obs <- run1$hyd$Sub36_obs
precip <- run1$hyd$precip

# create a nice hydrograph
rvn_hyd_plot(sim,obs)

# create a hydrograph with precip as well;
rvn_hyd_plot(sim,obs,precip=precip)

# create a hydrograph with precip as well for a specific subperiod
prd <- "2003-10-01/2004-10-01"
rvn_hyd_plot(sim,obs,precip=precip,prd=prd)

# add the winter shading
rvn_hyd_plot(sim,obs,precip=precip,prd=prd, winter_shading=TRUE)

# change winter shading dates (Nov 1st to April 15th)
rvn_hyd_plot(sim,obs,precip=precip,prd=prd, winter_shading=TRUE, wsdates=c(11,1,4,15))

}
\seealso{
\code{\link{rvn_flow_spaghetti}} to create a spaghetti plot of annual
flow series

\code{\link{rvn_hyd_extract}} to extract time series from Raven objects
}
