% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBars.R
\name{getBars}
\alias{getBars}
\title{Get Open/High/Low/Close/Volume Bars from Bloomberg}
\usage{
getBars(security, eventType = "TRADE", barInterval = 60,
  startTime = Sys.time() - 60 * 60 * 6, endTime = Sys.time(),
  options = NULL, verbose = FALSE, returnAs = getOption("blpType",
  "matrix"), tz = Sys.getenv("TZ", unset = "UTC"),
  con = defaultConnection())
}
\arguments{
\item{security}{A character variable describing a valid security ticker}

\item{eventType}{A character variable describing an event type;
default is \sQuote{TRADE}}

\item{barInterval}{A integer denoting the number of minutes for each bar}

\item{startTime}{A Datetime object with the start time, defaults
to one hour before current time}

\item{endTime}{A Datetime object with the end time, defaults
to current time}

\item{options}{An optional named character vector with option
values. Each field must have both a name (designating the option
being set) as well as a value.}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{returnAs}{A character variable describing the type of return
object; currently supported are \sQuote{matrix} (also the default),
\sQuote{fts}, \sQuote{xts} and \sQuote{zoo}}

\item{tz}{A character variable with the desired local timezone,
defaulting to the value \sQuote{TZ} environment variable, and
\sQuote{UTC} if unset}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A numeric matrix with elements \sQuote{time} (as a
\sQuote{POSIXct} object), \sQuote{open}, \sQuote{high},
\sQuote{low}, \sQuote{close}, \sQuote{numEvents}, \sQuote{volume},
\sQuote{value} or an object of the type selected in \code{returnAs}.
Note that the \sQuote{time} value is adjusted: Bloomberg returns the
\emph{opening} time of the bar interval, whereas financial studies
typically refer to the most recent timestamp. For this reason we
add the length of the bar interval to time value from Bloomberg to
obtain the time at the end of the interval.
}
\description{
This function uses the Bloomberg API to retrieve bars for the requested security.
}
\examples{
\dontrun{
  getBars("ES1 Index")
}
}
\author{
Dirk Eddelbuettel
}

