\name{create.mask}
\alias{create.mask}
\alias{create.cellID.mask}

\title{Create mask image}
\description{
creates a mask image of the cell regions for future quantification 
}
\usage{
create.cellID.mask(X
  ,subset=NULL,channel="TFP.out",min.area=5,threshold=0.99
  ,output.path=NULL,return.mask.list=FALSE,savemask=!return.mask.list)
}
\arguments{
  \item{X}{cell.data object}
  \item{subset}{condition defining images (pos and t.frame) to use to create masks. Use variables in X$images}
  \item{channel}{character of length 1 indicating the channel used to create the masks. See details. }	
  \item{min.area}{minimal area of blobs to be considered}	
  \item{threshold}{intensity threshold used to separate boundaries from background}	
  \item{output.path}{character containing path to output directory. If NULL the same path were the images are is used}	
  \item{return.mask.list}{if TRUE a mask.list object is returned instead of a cell.data object}	
  \item{savemask}{boolean indicating if the masks should be saved as .rds files.}
}
\details{
  \code{create.cellID.mask} creates a mask for each cell from the .out.tif images generated by Cell-ID. The \code{channel} argument defines which channel to use to create the masks. This should be a .out channel. For the function to work the originall image shouldn't be saturated, i.e. in the out.tif image the only saturated pixels should correspond to cell boundaries. If the BF were pre-processed by the ImageJ fft filter, they won't work for this. Use a TFP.out or a fluorescence channel instead. 
}
\value{
  returns a cell.data object, with a new "mask" channel and maskID variable.
}
\author{Alan Bush, Rocio Espada}
\seealso{ \code{\link{calculate.features}}}
\examples{
\dontrun{
  X<-create.cellID.mask(X)
}
}
\keyword{manip}