% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeCSC}
\alias{computeCSC}
\title{Constrained Spectral Clustering}
\usage{
computeCSC(
  x,
  K = 0,
  K.max = 20,
  mustLink = list(),
  cantLink = list(),
  alphas = seq(from = 0, to = 1, length = 100)
)
}
\arguments{
\item{x}{matrix of raw data (point by line).}

\item{K}{number of clusters. If K=0 (default), this number is automatically computed thanks to the Elbow method.}

\item{K.max}{maximal number of clusters (K.Max=20 by default).}

\item{mustLink}{list of ML (must-link) constrained pairs.}

\item{cantLink}{list of CNL (cannot-link) constrained pairs.}

\item{alphas}{numeric vector for the weight of constraints considered.}
}
\value{
res.csc results obtained from KwaySSSC algorithm.
}
\description{
Perform Constrained Spectral Clustering from a similarity matrix computation.
}
\details{
computeCSC performs Constrained Spectral Clustering from a similarity matrix computation
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf, dir.save=tempdir())

ML=list(c(sel="10",mem="20"))
CNL=list(c(sel="1",mem="140"))

res.csc <- computeCSC(x$features$preprocessed$x, K=0, mustLink=ML, cantLink=CNL)
plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
col = res.csc$label, main = "Constrained Spectral clustering")


}
\seealso{
\code{\link{computeSemiSupervised}}, \code{\link{KwaySSSC}}
}
\keyword{internal}
