\name{Menu.fac}
\alias{Menu.fac}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Menu for generating orthogonal full factorial designs}
\description{
  This menu is for generating full factorial designs. 
  The menu calls function function fac.design from package DoE.base 
  and has been opened internally using the function shown in the usage section, 
  which normal users will never have to deal with.
}
\usage{
Menu.fac()
}
%- maybe also 'usage' for other objects documented here.
\section{Prior Remark for Windows users}{The most important technical point about this menu and the R-Commander in general: \cr
The R GUI should be installed with the Single Document Interface (SDI) mode 
instead of the default MDI mode. John Fox, the author of R-Commander, has described 
how to change MDI to SDI, if R has been installed in the wrong mode. 
It is strongly discouraged to run the R-Commander under the MDI mode, 
as it happens very frequently that windows suddenly disappear. They usually 
have iconized only and can be retrieved from the taskbar; nevertheless, this behavior 
can be very annoying and can be avoided by using R in SDI mode.}


\section{User form structure}{
This user form is structured as a notebook with several tabs, and each tab has its 
own specific help button. 
It is recommended to work through the tabs from left 
to right, although it is possible to switch between tabs back and forth. 

The buttons to the right of the tabs store or load form settings (cf. next section) 
for the complete form with all tabs.
}

\section{What happens when pressing OK?}{
  On OK, the menu will create an experimental design as an R data frame with 
  some attributes (\code{desnum}, \code{run.order} and \code{design.info}). 
  The list \code{design.info} contains, among other things, the element 
  \code{creator}, which contains the stored form. \cr

  If requested on the Export tab, the R workspace with ONLY the experimental 
  design will be saved at the specified location with the ending \code{rda}, 
  and an Excel-readable html-file or a csv-file will be generated, depending 
  on the users choice. Alternatively, it is possible to permanently store an 
  R workspace with ONLY the design later using the menu entry 
  \dQuote{Export design} from the \dQuote{Design} menu, 
  or the full R workspace can be stored using the appropriate entry in the 
  \dQuote{File} menu of R commander.
  The menu entry for loading the stored R workspace in a future session 
  can be found under \dQuote{Data Management}.
}
\section{Storing and loading form settings}{
  The settings of the form (all tabs) can be saved at any time with the 
  button \dQuote{Store form}, which generates an object (of class \code{menu.design2pb}). 
  The button \dQuote{Load form} can be used for loading these settings 
  into the form again in order to continue working on the entries. 
  The purpose of this functionality: work can be safely interrupted, 
  or a finished design can be modified after a team discussion or ... 

  The stored inputs will be an object within the R session. 
  If they are to be kept for future R sessions, the R workspace must be stored 
  on disk or on another storage medium (file type \code{RData} or \code{rda}). 
  This can be done from the file menu of the R commander (usually the leftmost menu). 
  The menu entry for loading the stored R workspace in a future session 
  can be found under \dQuote{Data Management}.

  Within an R session, the latest stored form inputs are normally loaded automatically 
  on next usage of the menu. If you want to restart fresh, 
  the button \dQuote{Reset form} sets everything to default again.

  As pointed out above, if a design is actually generated by pressing the OK button, 
  the menu settings are saved within the design object. The button \dQuote{Load form} 
  knows how to load the form settings from designs, so that it is not necessary to 
  separately store the form settings in this case. 
}
\author{ Ulrike Groemping }
\seealso{ See Also \code{\link[DoE.base]{fac.design}} for the function behind this menu, 
\code{\link{Menu.General}} for choice between full factorial designs and orthogonal 
main effects designs.}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ design }
\keyword{ array }% __ONLY ONE__ keyword per line
