% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movEmean}
\alias{movEmean}
\title{Basic Exponential Moving Mean}
\usage{
movEmean(vec, n = 1L, smFac = NULL)
}
\arguments{
\item{vec}{A numeric vector.}

\item{n}{An integer: moving window size, with \eqn{1} as default}

\item{smFac}{A number: smoothing factor, with default \eqn{2/(n+1)},  see \strong{details} below.}
}
\value{
This function returns a vector whose length is the same as that of \emph{vec}.
}
\description{
This function returns a basic exponential moving average (EMA) of the given vector.
}
\details{
This function makes fairly efficient the computation of EMA, which dubbed as basic 
exponential smoothing, the same section of \url{https://en.wikipedia.org/wiki/Exponential_smoothing}.
It provides an access to define \emph{smFac} yourself, i.e the smoothing factor, 
whose default is \eqn{2/(n+1)}.
}
\examples{
movEmean(c(1, 4, 3, 6, 8), 2, smFac = 1/3)
movEmean(c(1, 4, 3, 6, 8), 2)
}
