% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-aliases.R
\name{aliases}
\alias{aliases}
\alias{s}
\alias{cl}
\alias{undim}
\alias{named}
\alias{clean_Rd}
\alias{get_attr}
\alias{forward_attributes}
\alias{fwd}
\alias{is_whitespace}
\title{Internal Utilities

These utilities are used internally and not exported.
They are however documented for completeness}
\usage{
s(x, ...)

cl(x, new)

undim(x)

named(...)

clean_Rd(obj, ...)

get_attr(x, which, default = NULL, exact = TRUE)

forward_attributes(x, obj)

fwd(x, obj)

is_whitespace(x)
}
\arguments{
\item{x, obj}{An object, any object.}

\item{...}{passed on to other function(s).}

\item{new}{the new class(es) to append.}

\item{which}{name of the attribute to extract.}

\item{default}{the default value to return if not found.}

\item{exact}{exact or partial matching?}
}
\description{
Internal Utilities

These utilities are used internally and not exported.
They are however documented for completeness
}
\section{Functions}{
\itemize{
\item \code{s}: Alias for structure, but also adds automatic naming when unnamed,

\item \code{cl}: Specify an additional class for an object, or class when none is set.

\item \code{undim}: Remove the \code{dim} attribute.

\item \code{named}: Create a named list with names inferred if needed.

\item \code{clean_Rd}: Alias for \code{\link[tools:toRd.default]{tools::toRd.default()}}

\item \code{get_attr}: Alias for \code{attr(x, which) \%||\% default}.

\item \code{forward_attributes}: Forward attributes from object to value.

\item \code{fwd}: Alias for \code{forward_attributes()}.

\item \code{is_whitespace}: Check if a string is composed of only whitespace, with \link[base:grep]{regex} pattern \code{"^\\s+$"}.
}}

\seealso{
\code{\link[purrr:\%||\%]{purrr::\%||\%()}}

\code{\link[base:attributes]{base::attributes()}}
}
