% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SPCA.R
\name{do.spca}
\alias{do.spca}
\title{Sparse Principal Component Analysis}
\usage{
do.spca(X, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), mu = 1, rho = 1, abstol = 1e-04,
  reltol = 0.01, maxiter = 1000)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{mu}{an augmented Lagrangian parameter.}

\item{rho}{a regularization parameter for sparsity.}

\item{abstol}{absolute tolerance stopping criterion.}

\item{reltol}{relative tolerance stopping criterion.}

\item{maxiter}{maximum number of iterations.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are principal components.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{history}{a length-\code{ndim} list where each element is an iteration history.}
}
}
\description{
Sparse PCA (\code{do.spca}) is a variant of PCA in that each loading - or, principal
component - should be sparse. Instead of using generic optimization package,
we opt for formulating a problem as semidefinite relaxation and utilizing ADMM.
}
\examples{
\dontrun{
## generate default dataset and make its dimension three-folds.
Xp <- aux.gensamples()
X  <- cbind(Xp,Xp,Xp)

## try different regularization parameters for sparsity
out1 <- do.spca(X,ndim=2,rho=0.01)
out2 <- do.spca(X,ndim=2,rho=1)
out3 <- do.spca(X,ndim=2,rho=100)

## Visualize principal components as columns in an image
par(mfrow=c(1,3))
image(t(out1$projection), main="SPCA::rho=0.01")
image(t(out2$projection), main="SPCA::rho=1")
image(t(out3$projection), main="SPCA::rho=100")
}

}
\references{
\insertRef{zou_sparse_2006}{Rdimtools}

\insertRef{daspremont_direct_2007}{Rdimtools}

\insertRef{ma_alternating_2013}{ADMM}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Changhee Suh
}
