% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.dfunc.R
\name{coef.dfunc}
\alias{coef.dfunc}
\title{Coefficients of an estimated detection function}
\usage{
\method{coef}{dfunc}(object, \dots)
}
\arguments{
\item{object}{An estimated distance function object.  An estimated distance 
function object has class 'dfunc', and is usually produced by a call to 
\code{dfuncEstim}.}

\item{\dots}{Required for compatibility with the general \code{coef} method.  Any 
extra arguments to this function are ignored.}
}
\value{
The estimated parameter vector for the detection function. Length and interpretation of values 
  in this vector vary depending on the form of the detection function and expansion terms.
}
\description{
Extract the coefficients and estimated parameters (if any) from 
  a estimated detection function object.
}
\details{
This is an extractor function for the parameters of an estimated detection function. 
  This function is equivalent to \code{obj$parameters} for classical detection functions.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)

# Fit half-normal detection function
dfunc <- dfuncEstim(formula=dist~1
                  , detectionData=sparrowDetectionData)

# Print results
dfunc
  
# Extract the coefficient(s)
coef(dfunc)

}
\seealso{
\code{\link{AIC}}, \code{\link{dfuncEstim}}
}
\keyword{model}
