% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressDec.R
\name{ReduceX}
\alias{ReduceX}
\title{Suppressed tabular data: Reduce dummy matrix, X (and estimate Y)}
\usage{
ReduceX(x, z = NULL, y = NULL, digits = 9)
}
\arguments{
\item{x}{X as a matrix}

\item{z}{Z as a matrix}

\item{y}{Y as a matrix}

\item{digits}{When non-NULL and when NULL y input, output y estimates close to whole numbers will be rounded using 
\code{digits} as input to \code{\link{RoundWhole}}.}
}
\value{
A list of four elements:
        \item{\code{x}}{Reduced \code{x}}
        \item{\code{z}}{Corresponding reduced \code{z} or NULL when no \code{z} in input}
        \item{\code{yKnown}}{Logical vector specifying elements of y that can be found directly as elements in z}
        \item{\code{y}}{As \code{y} in input (not reduced) or estimated \code{y} when NULL y in input}
}
\description{
In section 7 in the paper \code{ Z = t(X) \%*\% Y} where \code{X} is a dummy matrix. 
Some elements of Y can be found directly as elements in Z. Corresponding rows of X will be removed. 
After removing rows, some columns will only have zeros and these will also be removed.
}
\details{
To estimate Y, this function finds some values directly from Z and other values by running \code{\link{Z2Yhat}} on reduced versions of X and Z.
}
\examples{
# Same data as in the paper
z <- RegSDCdata("sec7z")
x <- RegSDCdata("sec7x")
y <- RegSDCdata("sec7y")  # Now z is t(x) \%*\% y 

a <- ReduceX(x, z, y)
b <- ReduceX(x, z)
d <- ReduceX(x, z = NULL, y)  # No z in output

# Identical output for x and z
identical(a$x, b$x)
identical(a$x, d$x)
identical(a$z, b$z)

# Same y in output as input
identical(a$y, y)
identical(d$y, y)

# Estimate of y (yHat) when NULL y input
b$y

# These elements of y can be found directly in in z
y[a$yKnown, , drop = FALSE]
# They can be found by searching for unit colSums
colSums(x)[colSums(x) == 1]

# These trivial data rows can be omitted when processing data
x[!a$yKnown, ]
# Now several columns can be omitted since zero colSums
colSums0 <- colSums(x[!a$yKnown, ]) == 0
# The resulting matrix is output from the function
identical(x[!a$yKnown, !colSums0], a$x)

# Output z can be computed from this output x
identical(t(a$x) \%*\% y[!a$yKnown, , drop = FALSE], a$z)
}
\author{
Øyvind Langsrud
}
\keyword{internal}
