% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSlide.R
\name{addSlide}
\alias{addSlide}
\alias{addSlide.pptx}
\title{Add a slide into a document object}
\usage{
addSlide(doc, ...)

\method{addSlide}{pptx}(doc, slide.layout, bookmark, ...)
}
\arguments{
\item{doc}{document object}

\item{...}{further arguments passed to other methods}

\item{slide.layout}{layout name of the slide to create. See \code{\link{slide.layouts.pptx}}}

\item{bookmark}{\code{"integer"} page number to specify where slide has to be replaced with a new empty one.}
}
\value{
a document object
}
\description{
Add a slide into a document object
}
\details{
\code{addSlide} only works with pptx documents. See \code{\link{addSlide.pptx}} for examples.

This function is a key function ; if no slide has been added into the document object
no content (tables, plots, images, text) can be added.

If creating a slide of type "Title and Content", only one content can be added because there is only one content shape in the layout.
If creating a slide of type "Two Content", two content can be added because there are 2 content shapes in the layout.

Content shapes are boxes with dotted borders that hold content in its place on a slide layout.
If you need a new layout, create it in PowerPoint :

On the View tab, in the Presentation Views group, click Slide Master.

Function \code{slide.layouts} returns available layout names of the template used when pptx object has been created.
It is important to know that when using addParagraph.pptx, paragraph and defaut font formats will be defined
by the properties of the shape of the \code{slide.layout} where content will be added.
For example, if you set the shape formatting properties to a 'no bullet', paragraphs of text won't have any bullet.

Also when using addPlot, plot dimensions will be the shape dimensions. It means that if you want to change plot dimensions
, this has to be done in the PowerPoint template used when creating the \code{pptx} object.
}
\examples{
\donttest{
doc.filename = "addSlide_example.pptx"
doc <- pptx()
doc <- addSlide(doc, "Title and Content")
doc <- addTitle(doc, "Title example")
writeDoc( doc, file = doc.filename )
}


# demo slide replacement --------
\donttest{
# define 2 FlexTables
ft1 = vanilla.table( mtcars[1:6,] , add.rownames = TRUE )
ft2 = vanilla.table( iris[1:10,], add.rownames = TRUE )

# create an doc to be used as template later
mydoc = pptx( )
mydoc = addSlide( mydoc, slide.layout = "Title and Content")
mydoc = addTitle( mydoc, "a table")
mydoc = addFlexTable( mydoc, ft1 )
mydoc = addSlide( mydoc, slide.layout = "Title and Content")
mydoc = addTitle( mydoc, "some text")
mydoc = addParagraph( mydoc, "text example" )
writeDoc( mydoc, "template_example.pptx" )

# use file pp_template_example.pptx as template
# and replace slide 1
mydoc = pptx(template = "template_example.pptx" )
mydoc = addSlide( mydoc, slide.layout = "Title and Content", bookmark = 1)
mydoc = addTitle( mydoc, "a new table")
mydoc = addFlexTable( mydoc, ft2 )
writeDoc( mydoc, "slide_replacement.pptx" )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{slide.layouts}}
}

