/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.util.Map;
import org.docx4j.model.datastorage.BindingHyperlinkResolver;
import org.docx4j.model.datastorage.BindingTraverserXSLT;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTDataBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHandler {
    private static Logger log = LoggerFactory.getLogger(BindingHandler.class);
    private static BindingHyperlinkResolver hyperlinkResolver;
    public static final String CORE_PROPERTIES_STOREITEMID = "{6C3C8BC8-F283-45AE-878A-BAB7291924A1}";
    public static final String EXTENDED_PROPERTIES_STOREITEMID = "{6668398D-A668-4E3E-A5EB-62B293D839F1}";
    public static final String COVERPAGE_PROPERTIES_STOREITEMID = "{55AF091B-3C7A-41E3-B477-F2FDAA23CFDA}";

    public static void setHyperlinkStyle(String hyperlinkStyleID) {
        BindingHandler.getHyperlinkResolver().setHyperlinkStyle(hyperlinkStyleID);
    }

    public static String getHyperlinkStyleId() {
        return BindingHandler.getHyperlinkResolver().getHyperlinkStyleId();
    }

    public static BindingHyperlinkResolver getHyperlinkResolver() {
        if (hyperlinkResolver == null) {
            hyperlinkResolver = new BindingHyperlinkResolver();
        }
        return hyperlinkResolver;
    }

    public static void setHyperlinkResolver(BindingHyperlinkResolver hyperlinkResolver) {
        BindingHandler.hyperlinkResolver = hyperlinkResolver;
    }

    public static void applyBindings(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        BindingHandler.getHyperlinkResolver().activateHyperlinkStyle(wordMLPackage);
        BindingHandler.applyBindings(wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                BindingHandler.applyBindings((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            BindingHandler.applyBindings((FooterPart)rp.getPart(r));
        }
    }

    public static void applyBindings(JaxbXmlPart part) throws Docx4JException {
        OpcPackage pkg = part.getPackage();
        if (pkg instanceof WordprocessingMLPackage) {
            BindingHandler.getHyperlinkResolver().activateHyperlinkStyle((WordprocessingMLPackage)pkg);
        }
        XPathsPart xPathsPart = null;
        if (((WordprocessingMLPackage)pkg).getMainDocumentPart().getXPathsPart() == null) {
            log.error("OpenDoPE XPaths part missing");
        } else {
            xPathsPart = ((WordprocessingMLPackage)pkg).getMainDocumentPart().getXPathsPart();
        }
        BindingTraverserXSLT traverser = new BindingTraverserXSLT();
        part.setJaxbElement(traverser.traverseToBind(part, pkg, xPathsPart));
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, CTDataBinding db) {
        return BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, db.getStoreItemID(), db.getXpath(), db.getPrefixMappings());
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        try {
            if (storeItemId.toUpperCase().equals(CORE_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsCorePart().xpathGetString(xpath, prefixMappings);
            }
            if (storeItemId.toUpperCase().equals(EXTENDED_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsExtendedPart().xpathGetString(xpath, prefixMappings);
            }
            CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
            if (part == null) {
                throw new InputIntegrityException("Couldn't locate part by storeItemId " + storeItemId);
            }
            String r = part.xpathGetString(xpath, prefixMappings);
            if (r == null) {
                log.error(xpath + " unexpectedly null!");
                return r;
            }
            if (r.equals("")) {
                log.debug("XML element is missing (or empty) for xpath: " + xpath);
                return r;
            }
            if (log.isDebugEnabled()) {
                log.debug(xpath + " yielded result '" + r + "'");
                return r;
            }
            return r;
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new InputIntegrityException(e.getMessage());
        }
    }
}

