\name{Many score based negative binomial regressions}
\alias{score.negbinregs}
\title{
Many score based negative binomial regressions
}

\description{
Many score based negative binomial regressions.
}

\usage{
score.negbinregs(y, x, logged = FALSE ) 
}

\arguments{
\item{y}{
A vector with discrete data, counts.
}
\item{x}{
A matrix with data, the predictor variables. 
}
\item{logged}{
A boolean variable; it will return the logarithm of the pvalue if set to TRUE.
}
}

\details{
Instead of maximising the log-likelihood via the Newton-Raphson algorithm in order to perform the hypothesis testing that \eqn{\beta_i=0} we use the score test. 
This is dramatcially faster as no model need to be fitted. The first derivative of the log-likelihood is known in closed form and under the null hypothesis the 
fitted values are all equal to the mean of the response variable y. The test is not the same as the likelihood ratio test. It is size correct nonetheless but it is 
a bit less efficient and less powerful. For big sample sizes though (5000 or more) the results are the same. It is also much faster then the classical likelihood ratio test.  
}

\value{
A matrix with two columns, the test statistic and its associated (logged) p-value.  
}

\references{
Joseph M.H. (2011). Negative Binomial Regression. Cambridge University Press, 2nd edition.

Campbell, M.J. (2001). Statistics at Square Two: Understand Modern Statistical Applications in Medicine, pg. 112.
London, BMJ Books. 

}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris <mtsagris@yahoo.gr> and Manos Papadakis <papadakm95@gmail.com>.
}
%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{score.glms}, \link{univglms}, \link{logistic_only},  \link{poisson_only}, \link{regression}
}
}

\examples{
## 200 variables, hence 200 univariate regressions are to be fitted
x <- matrix( rnorm(200 * 200), ncol = 200 )
y <- rnbinom(200, 5, 0.6)   
system.time( score.negbinregs(y, x) )

## x <- matrix( rnorm(500 * 2000), ncol = 2000 )
## y <- rnbinon(500, 7, 0.6)   
## a <- score.negbinregs(y, x)
## hist(a[, 2])
## sum(a < 0.05) / 2000  ## estimated type I error 
}

\keyword{ Negative binomial regressions }
\keyword{ score based tests }