//Author: Manos Papadakis

// This file was generated by compileAttributes
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppArmadillo.h>
#include <Rinternals.h>
#include <R.h>
#include <cmath>

using namespace Rcpp;

SEXP Log(SEXP x){
  const int nrow=Rf_nrows(x),ncol=Rf_ncols(x),n=nrow*ncol;
  SEXP f;
  switch(TYPEOF(x)){
    case REALSXP:{
      f=PROTECT(Rf_allocMatrix(REALSXP,nrow,ncol));
      double *start_f=REAL(f),*start_x=REAL(x),*end_x=start_x+n;
      for(;start_x!=end_x;++start_x,++start_f)
        *start_f=std::log(*start_x);
      break;
    }
    default:{
      f=PROTECT(Rf_allocMatrix(INTSXP,nrow,ncol));
      int *start_f=INTEGER(f),*start_x=INTEGER(x),*end_x=start_x+n;
      for(;start_x!=end_x;++start_x,++start_f)
        *start_f=std::log(*start_x);
      break;
    }
  }
  UNPROTECT(1);
  return f;
}

RcppExport SEXP Rfast_Log(SEXP x) {
BEGIN_RCPP
    RObject __result;
    RNGScope __rngScope;
    __result = Log(x);
    return __result;
END_RCPP
}

//////////////////////////////////////////////////////////////////////////

using std::lgamma;

SEXP Lbeta(SEXP x,SEXP y){
  int n=LENGTH(x);
  SEXP f=PROTECT(Rf_duplicate(x));
  switch(TYPEOF(x)){
    case REALSXP:{
      double *start_f=REAL(f),*start_x=REAL(x),*start_y=REAL(y),*end_x=start_x+n,X,Y;
      for(;start_x!=end_x;++start_x,++start_y,++start_f){
        X=*start_x;
        Y=*start_y;
        *start_f=lgamma(X)+lgamma(Y)-lgamma(X+Y);
      }
      break;
    }
    default:{
      int *start_f=INTEGER(f),*start_x=INTEGER(x),*start_y=INTEGER(y),*end_x=start_x+n,X,Y;
      for(;start_x!=end_x;++start_x,++start_y,++start_f){
        X=*start_x;
        Y=*start_y;
        *start_f=lgamma(X)+lgamma(Y)-lgamma(X+Y);
      }
      break;
    }
  }
  UNPROTECT(1);
  return f;
}


RcppExport SEXP Rfast_Lbeta(SEXP x,SEXP y) {
BEGIN_RCPP
    RObject __result;
    RNGScope __rngScope;
    __result = Lbeta(x,y);
    return __result;
END_RCPP
}

//////////////////////////////////////////////////////////////////////////////
