test_that("Tests large node size", {

  x <- iris[, -1]
  y <- iris[, 1]

  context("Large node sizes")
  # Set seed for reproductivity
  set.seed(24750371)

  # Test forestry (mimic RF)
  forest <- forestry(
    x,
    y,
    ntree = 500,
    replace = TRUE,
    sampsize = nrow(x),
    mtry = 4,
    nodesizeStrictSpl = 80,
    nthread = 2,
    splitrule = "variance",
    splitratio = 1,
    nodesizeStrictAvg = 80
  )

  # Test predict
  y_pred <- predict(forest, x)

  # Mean Square Error
  #sum((y_pred - y) ^ 2) %>% dput
  expect_equal(sum((y_pred - y) ^ 2), 102.16933076160000, tolerance=1e-12)

})

