% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_test_adjusted_pvalue.R
\name{gof_test_adjusted_pvalue}
\alias{gof_test_adjusted_pvalue}
\title{This function performs a number of gof tests and finds the adjusted p value for the combined test}
\usage{
gof_test_adjusted_pvalue(
  x,
  vals = NA,
  pnull,
  rnull,
  w = function(x) -99,
  phat = function(x) -99,
  TS,
  TSextra = NA,
  nbins = c(50, 10),
  rate = 0,
  Range = c(-Inf, Inf),
  B = c(5000, 1000),
  minexpcount = 5,
  ChiUsePhat = TRUE,
  doMethods
)
}
\arguments{
\item{x}{data set}

\item{vals}{=NA, values of discrete RV, or NA if data is continuous}

\item{pnull}{cdf under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{w}{(Optional) function to calculate weights, returns -99 if no weights}

\item{phat}{=function(x) -99, function to estimate parameters from the data, or -99 if no parameters are estimated}

\item{TS}{user supplied function to find test statistics, if any}

\item{TSextra}{=NA, list passed to TS, if desired, or NA}

\item{nbins}{=c(100, 10) number of bins for chi-square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any, for chi-square tests}

\item{B}{=c(5000,1000)  number of simulation runs for individual and for adjusted p values}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{= TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}

\item{doMethods}{Methods to include in tests}
}
\value{
None
}
\description{
This function performs a number of gof tests and finds the adjusted p value for the combined test
}
\examples{
# Tests to see whether data comes from a standard normal distribution.
pnull = function(x) pnorm(x)
rnull = function()  rnorm(100)
x = rnorm(100)
gof_test_adjusted_pvalue(x, NA, pnull, rnull, B=c(1000, 200))
# Tests to see whether data comes from a normal distribution with standard deviation 1 
# and the mean estimated.
pnull=function(x, m) pnorm(x, m)
rnull=function(m) rnorm(100, m)
TSextra = list(qnull=function(x, m=0) qnorm(x, m), 
          pnull=function(x, m=0) pnorm(x, m), phat=function(x) mean(x))
phat=function(x) mean(x)
x = rnorm(100, 1, 2)
gof_test_adjusted_pvalue(x, NA, pnull, rnull, phat=phat, TSextra=TSextra, B=c(1000, 200))
# Tests to see whether data comes from a binomial (10, 0.5) distribution.
vals=0:10
pnull = function() pbinom(0:10, 10, 0.5)
rnull = function() table(c(0:10, rbinom(1000, 10, 0.5)))-1
x = rnull() 
gof_test_adjusted_pvalue(x, vals, pnull, rnull, B=c(1000, 200))
# Tests to see whether data comes from a binomial distribution with 
# the success probability estimated from the data.
pnull = function(p=0.5) pbinom(0:10, 10, ifelse(p>0&&p<1, p, 0.001))
rnull = function(p=0.5) table(c(0:10, rbinom(1000, 10, 
                  ifelse(p>0&&p<1, p, 0.001))))-1
phat=function(x) mean(rep(0:10,x))/10 
gof_test_adjusted_pvalue(x, vals, pnull, rnull, phat=phat, B=c(1000, 200)) 

}
