% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_sphere.R
\name{predict.mixspnorm}
\alias{predict.mixspnorm}
\title{S3 Method for Prediction upon Fitted 'mixspnorm' Model}
\usage{
\method{predict}{mixspnorm}(object, newdata, ...)
}
\arguments{
\item{object}{an object of \code{mixspnorm} class. See \code{\link{mixspnorm}} for more details.}

\item{newdata}{data vectors in form of either an \eqn{(m\times p)} matrix or a length-\eqn{m} list.  See \code{\link{wrap.sphere}} for descriptions on supported input types.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a length-\eqn{m} vector of class labels.
}
\description{
Given new data with the fitted mixture of spherical normals on a sphere, predict the 
class labels for the newly provided data according to the fitted model.
}
\examples{
\donttest{
# LOAD THE CITY DATA AND WRAP AS RIEMOBJ
data(cities)
locations = cities$cartesian
embed2    = array(0,c(60,2)) 
for (i in 1:60){
   embed2[i,] = sphere.xyz2geo(locations[i,])
 }
 
# FIT THE MODEL K=3
k3fit     = mixspnorm(locations, k=3)
k3fitlab  = k3fit$cluster

# PREDICT THE CLASS LABEL WITH THE SAME DATA
k3predict = predict(k3fit, locations)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(embed2, col=k3fitlab,  pch=19, main="fitted")
plot(embed2, col=k3predict, pch=19, main="predicted")
par(opar)
}

}
\seealso{
\code{\link{mixspnorm}}
}
\concept{sphere}
