/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0

#include <stan/model/model_header.hpp>

namespace model_SGT_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_SGT");
    reader.add_event(193, 191, "end", "model_SGT");
    return reader;
}

class model_SGT
  : public stan::model::model_base_crtp<model_SGT> {
private:
        int SEASONALITY;
        double SEASONALITY_F;
        double CAUCHY_SD;
        double MIN_POW_TREND;
        double MAX_POW_TREND;
        double MIN_SIGMA;
        double MIN_NU;
        double MAX_NU;
        int N;
        vector_d y;
        double POW_TREND_ALPHA;
        double POW_TREND_BETA;
        double POW_SEASON_ALPHA;
        double POW_SEASON_BETA;
        int USE_REGRESSION;
        int SEASONALITY_TYPE;
        int USE_SMOOTHED_ERROR;
        int NUM_OF_SEASON_INIT_CYCLES;
        int LEVEL_CALC_METHOD;
        int J;
        matrix_d xreg;
        vector_d REG_CAUCHY_SD;
        double fractSeasonality;
        double reg0CauchySd;
public:
    model_SGT(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_SGT(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_SGT_namespace::model_SGT";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "SEASONALITY", "int", context__.to_vec());
            SEASONALITY = int(0);
            vals_i__ = context__.vals_i("SEASONALITY");
            pos__ = 0;
            SEASONALITY = vals_i__[pos__++];
            check_greater_or_equal(function__, "SEASONALITY", SEASONALITY, 2);

            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "SEASONALITY_F", "double", context__.to_vec());
            SEASONALITY_F = double(0);
            vals_r__ = context__.vals_r("SEASONALITY_F");
            pos__ = 0;
            SEASONALITY_F = vals_r__[pos__++];
            check_greater_or_equal(function__, "SEASONALITY_F", SEASONALITY_F, SEASONALITY);
            check_less_or_equal(function__, "SEASONALITY_F", SEASONALITY_F, (SEASONALITY + 1));

            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "CAUCHY_SD", "double", context__.to_vec());
            CAUCHY_SD = double(0);
            vals_r__ = context__.vals_r("CAUCHY_SD");
            pos__ = 0;
            CAUCHY_SD = vals_r__[pos__++];
            check_greater_or_equal(function__, "CAUCHY_SD", CAUCHY_SD, 0);

            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "MIN_POW_TREND", "double", context__.to_vec());
            MIN_POW_TREND = double(0);
            vals_r__ = context__.vals_r("MIN_POW_TREND");
            pos__ = 0;
            MIN_POW_TREND = vals_r__[pos__++];

            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "MAX_POW_TREND", "double", context__.to_vec());
            MAX_POW_TREND = double(0);
            vals_r__ = context__.vals_r("MAX_POW_TREND");
            pos__ = 0;
            MAX_POW_TREND = vals_r__[pos__++];

            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "MIN_SIGMA", "double", context__.to_vec());
            MIN_SIGMA = double(0);
            vals_r__ = context__.vals_r("MIN_SIGMA");
            pos__ = 0;
            MIN_SIGMA = vals_r__[pos__++];
            check_greater_or_equal(function__, "MIN_SIGMA", MIN_SIGMA, 0);

            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "MIN_NU", "double", context__.to_vec());
            MIN_NU = double(0);
            vals_r__ = context__.vals_r("MIN_NU");
            pos__ = 0;
            MIN_NU = vals_r__[pos__++];
            check_greater_or_equal(function__, "MIN_NU", MIN_NU, 1);

            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "MAX_NU", "double", context__.to_vec());
            MAX_NU = double(0);
            vals_r__ = context__.vals_r("MAX_NU");
            pos__ = 0;
            MAX_NU = vals_r__[pos__++];
            check_greater_or_equal(function__, "MAX_NU", MAX_NU, 1);

            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, (SEASONALITY + 1));

            current_statement_begin__ = 11;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "y", y, 0);

            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "POW_TREND_ALPHA", "double", context__.to_vec());
            POW_TREND_ALPHA = double(0);
            vals_r__ = context__.vals_r("POW_TREND_ALPHA");
            pos__ = 0;
            POW_TREND_ALPHA = vals_r__[pos__++];
            check_greater_or_equal(function__, "POW_TREND_ALPHA", POW_TREND_ALPHA, 0);

            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "POW_TREND_BETA", "double", context__.to_vec());
            POW_TREND_BETA = double(0);
            vals_r__ = context__.vals_r("POW_TREND_BETA");
            pos__ = 0;
            POW_TREND_BETA = vals_r__[pos__++];
            check_greater_or_equal(function__, "POW_TREND_BETA", POW_TREND_BETA, 0);

            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "POW_SEASON_ALPHA", "double", context__.to_vec());
            POW_SEASON_ALPHA = double(0);
            vals_r__ = context__.vals_r("POW_SEASON_ALPHA");
            pos__ = 0;
            POW_SEASON_ALPHA = vals_r__[pos__++];
            check_greater_or_equal(function__, "POW_SEASON_ALPHA", POW_SEASON_ALPHA, 0);

            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "POW_SEASON_BETA", "double", context__.to_vec());
            POW_SEASON_BETA = double(0);
            vals_r__ = context__.vals_r("POW_SEASON_BETA");
            pos__ = 0;
            POW_SEASON_BETA = vals_r__[pos__++];
            check_greater_or_equal(function__, "POW_SEASON_BETA", POW_SEASON_BETA, 0);

            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "USE_REGRESSION", "int", context__.to_vec());
            USE_REGRESSION = int(0);
            vals_i__ = context__.vals_i("USE_REGRESSION");
            pos__ = 0;
            USE_REGRESSION = vals_i__[pos__++];
            check_greater_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 0);
            check_less_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 1);

            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "SEASONALITY_TYPE", "int", context__.to_vec());
            SEASONALITY_TYPE = int(0);
            vals_i__ = context__.vals_i("SEASONALITY_TYPE");
            pos__ = 0;
            SEASONALITY_TYPE = vals_i__[pos__++];
            check_greater_or_equal(function__, "SEASONALITY_TYPE", SEASONALITY_TYPE, 0);
            check_less_or_equal(function__, "SEASONALITY_TYPE", SEASONALITY_TYPE, 1);

            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "USE_SMOOTHED_ERROR", "int", context__.to_vec());
            USE_SMOOTHED_ERROR = int(0);
            vals_i__ = context__.vals_i("USE_SMOOTHED_ERROR");
            pos__ = 0;
            USE_SMOOTHED_ERROR = vals_i__[pos__++];
            check_greater_or_equal(function__, "USE_SMOOTHED_ERROR", USE_SMOOTHED_ERROR, 0);
            check_less_or_equal(function__, "USE_SMOOTHED_ERROR", USE_SMOOTHED_ERROR, 1);

            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "NUM_OF_SEASON_INIT_CYCLES", "int", context__.to_vec());
            NUM_OF_SEASON_INIT_CYCLES = int(0);
            vals_i__ = context__.vals_i("NUM_OF_SEASON_INIT_CYCLES");
            pos__ = 0;
            NUM_OF_SEASON_INIT_CYCLES = vals_i__[pos__++];
            check_greater_or_equal(function__, "NUM_OF_SEASON_INIT_CYCLES", NUM_OF_SEASON_INIT_CYCLES, 0);

            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "LEVEL_CALC_METHOD", "int", context__.to_vec());
            LEVEL_CALC_METHOD = int(0);
            vals_i__ = context__.vals_i("LEVEL_CALC_METHOD");
            pos__ = 0;
            LEVEL_CALC_METHOD = vals_i__[pos__++];
            check_greater_or_equal(function__, "LEVEL_CALC_METHOD", LEVEL_CALC_METHOD, 0);
            check_less_or_equal(function__, "LEVEL_CALC_METHOD", LEVEL_CALC_METHOD, 3);

            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);

            current_statement_begin__ = 20;
            validate_non_negative_index("xreg", "N", N);
            validate_non_negative_index("xreg", "J", J);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(N,J));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, J);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = J;
            size_t xreg_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 21;
            validate_non_negative_index("REG_CAUCHY_SD", "J", J);
            context__.validate_dims("data initialization", "REG_CAUCHY_SD", "vector_d", context__.to_vec(J));
            REG_CAUCHY_SD = Eigen::Matrix<double, Eigen::Dynamic, 1>(J);
            vals_r__ = context__.vals_r("REG_CAUCHY_SD");
            pos__ = 0;
            size_t REG_CAUCHY_SD_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < REG_CAUCHY_SD_j_1_max__; ++j_1__) {
                REG_CAUCHY_SD(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "REG_CAUCHY_SD", REG_CAUCHY_SD, 0);


            // initialize transformed data variables
            current_statement_begin__ = 24;
            fractSeasonality = double(0);
            stan::math::fill(fractSeasonality, DUMMY_VAR__);

            current_statement_begin__ = 25;
            reg0CauchySd = double(0);
            stan::math::fill(reg0CauchySd, DUMMY_VAR__);
            stan::math::assign(reg0CauchySd,(mean(REG_CAUCHY_SD) * 10));

            // execute transformed data statements
            current_statement_begin__ = 27;
            if (as_bool(logical_gt(SEASONALITY_F, SEASONALITY))) {

                current_statement_begin__ = 28;
                stan::math::assign(fractSeasonality, (SEASONALITY_F - SEASONALITY));
            } else {
                current_statement_begin__ = 32;
                stan::math::assign(fractSeasonality, 0);
            }

            // validate transformed data
            current_statement_begin__ = 24;
            check_greater_or_equal(function__, "fractSeasonality", fractSeasonality, 0);
            check_less_or_equal(function__, "fractSeasonality", fractSeasonality, 1);

            current_statement_begin__ = 25;
            check_greater_or_equal(function__, "reg0CauchySd", reg0CauchySd, 0);


            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 35;
            validate_non_negative_index("regCoef", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 35;
            num_params_r__ += 1;
            current_statement_begin__ = 36;
            num_params_r__ += 1;
            current_statement_begin__ = 37;
            num_params_r__ += 1;
            current_statement_begin__ = 38;
            num_params_r__ += 1;
            current_statement_begin__ = 39;
            num_params_r__ += 1;
            current_statement_begin__ = 40;
            num_params_r__ += 1;
            current_statement_begin__ = 41;
            num_params_r__ += 1;
            current_statement_begin__ = 42;
            num_params_r__ += 1;
            current_statement_begin__ = 43;
            num_params_r__ += 1;
            current_statement_begin__ = 44;
            num_params_r__ += 1;
            current_statement_begin__ = 45;
            num_params_r__ += 1;
            current_statement_begin__ = 46;
            num_params_r__ += 1;
            current_statement_begin__ = 47;
            validate_non_negative_index("initS", "SEASONALITY", SEASONALITY);
            num_params_r__ += SEASONALITY;
            current_statement_begin__ = 48;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_SGT() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 35;
        if (!(context__.contains_r("regCoef")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable regCoef missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("regCoef");
        pos__ = 0U;
        validate_non_negative_index("regCoef", "J", J);
        context__.validate_dims("parameter initialization", "regCoef", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> regCoef(J);
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            regCoef(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(regCoef);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable regCoef: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 35;
        if (!(context__.contains_r("regOffset")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable regOffset missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("regOffset");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "regOffset", "double", context__.to_vec());
        double regOffset(0);
        regOffset = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(regOffset);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable regOffset: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 36;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(MIN_NU, MAX_NU, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 37;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 38;
        if (!(context__.contains_r("levSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable levSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("levSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "levSm", "double", context__.to_vec());
        double levSm(0);
        levSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, levSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable levSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 39;
        if (!(context__.contains_r("llevSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable llevSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("llevSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "llevSm", "double", context__.to_vec());
        double llevSm(0);
        llevSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, llevSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable llevSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 40;
        if (!(context__.contains_r("sSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sSm", "double", context__.to_vec());
        double sSm(0);
        sSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, sSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 41;
        if (!(context__.contains_r("powx")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable powx missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("powx");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "powx", "double", context__.to_vec());
        double powx(0);
        powx = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, powx);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable powx: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 42;
        if (!(context__.contains_r("powTrendBeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable powTrendBeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("powTrendBeta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "powTrendBeta", "double", context__.to_vec());
        double powTrendBeta(0);
        powTrendBeta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, powTrendBeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable powTrendBeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 43;
        if (!(context__.contains_r("coefTrend")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable coefTrend missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("coefTrend");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "coefTrend", "double", context__.to_vec());
        double coefTrend(0);
        coefTrend = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(coefTrend);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable coefTrend: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 44;
        if (!(context__.contains_r("offsetSigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable offsetSigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("offsetSigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "offsetSigma", "double", context__.to_vec());
        double offsetSigma(0);
        offsetSigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(MIN_SIGMA, offsetSigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable offsetSigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 45;
        if (!(context__.contains_r("innovSm")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable innovSm missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("innovSm");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "innovSm", "double", context__.to_vec());
        double innovSm(0);
        innovSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, innovSm);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable innovSm: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 46;
        if (!(context__.contains_r("innovSizeInit")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable innovSizeInit missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("innovSizeInit");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "innovSizeInit", "double", context__.to_vec());
        double innovSizeInit(0);
        innovSizeInit = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, innovSizeInit);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable innovSizeInit: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 47;
        if (!(context__.contains_r("initS")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable initS missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("initS");
        pos__ = 0U;
        validate_non_negative_index("initS", "SEASONALITY", SEASONALITY);
        context__.validate_dims("parameter initialization", "initS", "vector_d", context__.to_vec(SEASONALITY));
        Eigen::Matrix<double, Eigen::Dynamic, 1> initS(SEASONALITY);
        size_t initS_j_1_max__ = SEASONALITY;
        for (size_t j_1__ = 0; j_1__ < initS_j_1_max__; ++j_1__) {
            initS(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(initS);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable initS: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 48;
        if (!(context__.contains_r("powSeason")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable powSeason missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("powSeason");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "powSeason", "double", context__.to_vec());
        double powSeason(0);
        powSeason = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, powSeason);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable powSeason: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 35;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> regCoef;
            (void) regCoef;  // dummy to suppress unused var warning
            if (jacobian__)
                regCoef = in__.vector_constrain(J, lp__);
            else
                regCoef = in__.vector_constrain(J);

            current_statement_begin__ = 35;
            local_scalar_t__ regOffset;
            (void) regOffset;  // dummy to suppress unused var warning
            if (jacobian__)
                regOffset = in__.scalar_constrain(lp__);
            else
                regOffset = in__.scalar_constrain();

            current_statement_begin__ = 36;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lub_constrain(MIN_NU, MAX_NU, lp__);
            else
                nu = in__.scalar_lub_constrain(MIN_NU, MAX_NU);

            current_statement_begin__ = 37;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);

            current_statement_begin__ = 38;
            local_scalar_t__ levSm;
            (void) levSm;  // dummy to suppress unused var warning
            if (jacobian__)
                levSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                levSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 39;
            local_scalar_t__ llevSm;
            (void) llevSm;  // dummy to suppress unused var warning
            if (jacobian__)
                llevSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                llevSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 40;
            local_scalar_t__ sSm;
            (void) sSm;  // dummy to suppress unused var warning
            if (jacobian__)
                sSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                sSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 41;
            local_scalar_t__ powx;
            (void) powx;  // dummy to suppress unused var warning
            if (jacobian__)
                powx = in__.scalar_lub_constrain(0, 1, lp__);
            else
                powx = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 42;
            local_scalar_t__ powTrendBeta;
            (void) powTrendBeta;  // dummy to suppress unused var warning
            if (jacobian__)
                powTrendBeta = in__.scalar_lub_constrain(0, 1, lp__);
            else
                powTrendBeta = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 43;
            local_scalar_t__ coefTrend;
            (void) coefTrend;  // dummy to suppress unused var warning
            if (jacobian__)
                coefTrend = in__.scalar_constrain(lp__);
            else
                coefTrend = in__.scalar_constrain();

            current_statement_begin__ = 44;
            local_scalar_t__ offsetSigma;
            (void) offsetSigma;  // dummy to suppress unused var warning
            if (jacobian__)
                offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA, lp__);
            else
                offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA);

            current_statement_begin__ = 45;
            local_scalar_t__ innovSm;
            (void) innovSm;  // dummy to suppress unused var warning
            if (jacobian__)
                innovSm = in__.scalar_lub_constrain(0, 1, lp__);
            else
                innovSm = in__.scalar_lub_constrain(0, 1);

            current_statement_begin__ = 46;
            local_scalar_t__ innovSizeInit;
            (void) innovSizeInit;  // dummy to suppress unused var warning
            if (jacobian__)
                innovSizeInit = in__.scalar_lb_constrain(0, lp__);
            else
                innovSizeInit = in__.scalar_lb_constrain(0);

            current_statement_begin__ = 47;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> initS;
            (void) initS;  // dummy to suppress unused var warning
            if (jacobian__)
                initS = in__.vector_constrain(SEASONALITY, lp__);
            else
                initS = in__.vector_constrain(SEASONALITY);

            current_statement_begin__ = 48;
            local_scalar_t__ powSeason;
            (void) powSeason;  // dummy to suppress unused var warning
            if (jacobian__)
                powSeason = in__.scalar_lub_constrain(0, 1, lp__);
            else
                powSeason = in__.scalar_lub_constrain(0, 1);

            // transformed parameters
            current_statement_begin__ = 51;
            local_scalar_t__ powTrend;
            (void) powTrend;  // dummy to suppress unused var warning
            stan::math::initialize(powTrend, DUMMY_VAR__);
            stan::math::fill(powTrend, DUMMY_VAR__);

            current_statement_begin__ = 52;
            validate_non_negative_index("l", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> l(N);
            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l, DUMMY_VAR__);

            current_statement_begin__ = 53;
            validate_non_negative_index("l0", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> l0(N);
            stan::math::initialize(l0, DUMMY_VAR__);
            stan::math::fill(l0, DUMMY_VAR__);

            current_statement_begin__ = 54;
            validate_non_negative_index("s", "((N + SEASONALITY) + 1)", ((N + SEASONALITY) + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> s(((N + SEASONALITY) + 1));
            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s, DUMMY_VAR__);

            current_statement_begin__ = 55;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r(N);
            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r, DUMMY_VAR__);

            current_statement_begin__ = 56;
            validate_non_negative_index("expVal", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> expVal(N);
            stan::math::initialize(expVal, DUMMY_VAR__);
            stan::math::fill(expVal, DUMMY_VAR__);

            current_statement_begin__ = 57;
            validate_non_negative_index("smoothedInnovSize", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> smoothedInnovSize(N);
            stan::math::initialize(smoothedInnovSize, DUMMY_VAR__);
            stan::math::fill(smoothedInnovSize, DUMMY_VAR__);

            current_statement_begin__ = 58;
            local_scalar_t__ seasonalityP;
            (void) seasonalityP;  // dummy to suppress unused var warning
            stan::math::initialize(seasonalityP, DUMMY_VAR__);
            stan::math::fill(seasonalityP, DUMMY_VAR__);

            current_statement_begin__ = 59;
            local_scalar_t__ sumsu;
            (void) sumsu;  // dummy to suppress unused var warning
            stan::math::initialize(sumsu, DUMMY_VAR__);
            stan::math::fill(sumsu, DUMMY_VAR__);

            current_statement_begin__ = 60;
            local_scalar_t__ newLevelP;
            (void) newLevelP;  // dummy to suppress unused var warning
            stan::math::initialize(newLevelP, DUMMY_VAR__);
            stan::math::fill(newLevelP, DUMMY_VAR__);

            current_statement_begin__ = 61;
            local_scalar_t__ movingSum;
            (void) movingSum;  // dummy to suppress unused var warning
            stan::math::initialize(movingSum, DUMMY_VAR__);
            stan::math::fill(movingSum, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 63;
            if (as_bool(USE_REGRESSION)) {
                current_statement_begin__ = 64;
                stan::math::assign(r, add(multiply(xreg, regCoef), regOffset));
            } else {
                current_statement_begin__ = 66;
                stan::math::assign(r, rep_vector(0, N));
            }
            current_statement_begin__ = 68;
            if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                current_statement_begin__ = 69;
                stan::math::assign(sumsu, 0);
                current_statement_begin__ = 70;
                for (int i = 1; i <= SEASONALITY; ++i) {
                    current_statement_begin__ = 71;
                    stan::math::assign(sumsu, (sumsu + stan::math::exp(get_base1(initS, i, "initS", 1))));
                }
                current_statement_begin__ = 72;
                for (int i = 1; i <= SEASONALITY; ++i) {

                    current_statement_begin__ = 73;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((stan::math::exp(get_base1(initS, i, "initS", 1)) * SEASONALITY) / sumsu), 
                                "assigning variable s");
                }
                current_statement_begin__ = 76;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            ((get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)) / get_base1(s, 1, "s", 1)), 
                            "assigning variable l");
            } else {

                current_statement_begin__ = 78;
                for (int i = 1; i <= SEASONALITY; ++i) {
                    current_statement_begin__ = 79;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(initS, i, "initS", 1), 
                                "assigning variable s");
                }
                current_statement_begin__ = 80;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)), 
                            "assigning variable l");
            }
            current_statement_begin__ = 83;
            stan::model::assign(s, 
                        stan::model::cons_list(stan::model::index_uni(((N + SEASONALITY) + 1)), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable s");
            current_statement_begin__ = 84;
            stan::model::assign(s, 
                        stan::model::cons_list(stan::model::index_uni((SEASONALITY + 1)), stan::model::nil_index_list()), 
                        get_base1(s, 1, "s", 1), 
                        "assigning variable s");
            current_statement_begin__ = 85;
            stan::model::assign(s, 
                        stan::model::cons_list(stan::model::index_uni((SEASONALITY + 2)), stan::model::nil_index_list()), 
                        get_base1(s, 2, "s", 1), 
                        "assigning variable s");
            current_statement_begin__ = 87;
            if (as_bool(USE_SMOOTHED_ERROR)) {
                current_statement_begin__ = 88;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            innovSizeInit, 
                            "assigning variable smoothedInnovSize");
            } else {
                current_statement_begin__ = 90;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            1, 
                            "assigning variable smoothedInnovSize");
            }
            current_statement_begin__ = 92;
            stan::math::assign(powTrend, (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) + MIN_POW_TREND));
            current_statement_begin__ = 93;
            stan::model::assign(expVal, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        get_base1(y, 1, "y", 1), 
                        "assigning variable expVal");
            current_statement_begin__ = 95;
            if (as_bool(logical_eq(LEVEL_CALC_METHOD, 3))) {
                current_statement_begin__ = 96;
                stan::model::assign(l0, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(l, 1, "l", 1), 
                            "assigning variable l0");
            } else {
                current_statement_begin__ = 98;
                stan::math::assign(l0, rep_vector(0, N));
            }
            current_statement_begin__ = 100;
            if (as_bool(logical_gt(LEVEL_CALC_METHOD, 0))) {

                current_statement_begin__ = 101;
                stan::math::assign(movingSum, (get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)));
                current_statement_begin__ = 102;
                for (int t = 2; t <= SEASONALITY; ++t) {
                    current_statement_begin__ = 103;
                    stan::math::assign(movingSum, ((movingSum + get_base1(y, t, "y", 1)) - get_base1(r, t, "r", 1)));
                }
            }
            current_statement_begin__ = 106;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 107;
                if (as_bool((primitive_value(logical_gt(LEVEL_CALC_METHOD, 0)) && primitive_value(logical_gt(t, SEASONALITY))))) {
                    current_statement_begin__ = 108;
                    stan::math::assign(movingSum, ((movingSum + (get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1))) - (get_base1(y, (t - SEASONALITY), "y", 1) - get_base1(r, (t - SEASONALITY), "r", 1))));
                }
                current_statement_begin__ = 111;
                if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                    current_statement_begin__ = 112;
                    stan::model::assign(expVal, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (((get_base1(l, (t - 1), "l", 1) + (coefTrend * pow(get_base1(l, (t - 1), "l", 1), powTrend))) * get_base1(s, t, "s", 1)) + get_base1(r, t, "r", 1)), 
                                "assigning variable expVal");
                    current_statement_begin__ = 113;
                    stan::math::assign(newLevelP, ((get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1)) / get_base1(s, t, "s", 1)));
                } else {

                    current_statement_begin__ = 115;
                    stan::model::assign(expVal, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (((get_base1(l, (t - 1), "l", 1) + (coefTrend * pow(get_base1(l, (t - 1), "l", 1), powTrend))) + (get_base1(s, t, "s", 1) * pow(get_base1(l, (t - 1), "l", 1), powSeason))) + get_base1(r, t, "r", 1)), 
                                "assigning variable expVal");
                    current_statement_begin__ = 116;
                    stan::math::assign(newLevelP, ((get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1)) - (get_base1(s, t, "s", 1) * pow(get_base1(l, (t - 1), "l", 1), powSeason))));
                }
                current_statement_begin__ = 120;
                if (as_bool(logical_eq(LEVEL_CALC_METHOD, 0))) {
                    current_statement_begin__ = 121;
                    stan::model::assign(l, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((levSm * newLevelP) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                                "assigning variable l");
                } else if (as_bool(logical_eq(LEVEL_CALC_METHOD, 2))) {

                    current_statement_begin__ = 123;
                    if (as_bool(logical_lte(t, SEASONALITY))) {
                        current_statement_begin__ = 124;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    ((levSm * newLevelP) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                                    "assigning variable l");
                    } else {
                        current_statement_begin__ = 126;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    (((levSm * movingSum) / SEASONALITY) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                                    "assigning variable l");
                    }
                } else if (as_bool(logical_eq(LEVEL_CALC_METHOD, 3))) {

                    current_statement_begin__ = 129;
                    stan::model::assign(l0, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((levSm * newLevelP) + ((1 - levSm) * get_base1(l0, (t - 1), "l0", 1))), 
                                "assigning variable l0");
                    current_statement_begin__ = 130;
                    if (as_bool(logical_lte(t, SEASONALITY))) {
                        current_statement_begin__ = 131;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    get_base1(l0, t, "l0", 1), 
                                    "assigning variable l");
                    } else {
                        current_statement_begin__ = 133;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    ((llevSm * get_base1(l0, t, "l0", 1)) + (((1 - llevSm) * movingSum) / SEASONALITY)), 
                                    "assigning variable l");
                    }
                }
                current_statement_begin__ = 137;
                if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                    current_statement_begin__ = 138;
                    stan::math::assign(seasonalityP, (((sSm * (get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1))) / get_base1(l, t, "l", 1)) + ((1 - sSm) * get_base1(s, t, "s", 1))));
                } else {

                    current_statement_begin__ = 140;
                    stan::math::assign(seasonalityP, (((sSm * ((get_base1(y, t, "y", 1) - get_base1(l, t, "l", 1)) - get_base1(r, t, "r", 1))) / pow(get_base1(l, (t - 1), "l", 1), powSeason)) + ((1 - sSm) * get_base1(s, t, "s", 1))));
                }
                current_statement_begin__ = 143;
                if (as_bool(logical_gt(fractSeasonality, 0))) {

                    current_statement_begin__ = 144;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(((t + SEASONALITY) + 1)), stan::model::nil_index_list()), 
                                seasonalityP, 
                                "assigning variable s");
                    current_statement_begin__ = 145;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni((t + SEASONALITY)), stan::model::nil_index_list()), 
                                ((fractSeasonality * get_base1(s, (t + SEASONALITY), "s", 1)) + ((1 - fractSeasonality) * seasonalityP)), 
                                "assigning variable s");
                } else {
                    current_statement_begin__ = 147;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni((t + SEASONALITY)), stan::model::nil_index_list()), 
                                seasonalityP, 
                                "assigning variable s");
                }
                current_statement_begin__ = 150;
                if (as_bool(USE_SMOOTHED_ERROR)) {
                    current_statement_begin__ = 151;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((innovSm * stan::math::fabs((get_base1(y, t, "y", 1) - get_base1(expVal, t, "expVal", 1)))) + ((1 - innovSm) * get_base1(smoothedInnovSize, (t - 1), "smoothedInnovSize", 1))), 
                                "assigning variable smoothedInnovSize");
                } else {
                    current_statement_begin__ = 153;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable smoothedInnovSize");
                }
            }

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 51;
            if (stan::math::is_uninitialized(powTrend)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: powTrend";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable powTrend: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
            check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);

            current_statement_begin__ = 52;
            size_t l_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(l(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: l" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable l: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "l", l, 0);

            current_statement_begin__ = 53;
            size_t l0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l0_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(l0(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: l0" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable l0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "l0", l0, 0);

            current_statement_begin__ = 54;
            size_t s_j_1_max__ = ((N + SEASONALITY) + 1);
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(s(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: s" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable s: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 55;
            size_t r_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(r(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable r: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 56;
            size_t expVal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(expVal(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: expVal" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable expVal: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "expVal", expVal, 0);

            current_statement_begin__ = 57;
            size_t smoothedInnovSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(smoothedInnovSize(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: smoothedInnovSize" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable smoothedInnovSize: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "smoothedInnovSize", smoothedInnovSize, 0);

            current_statement_begin__ = 58;
            if (stan::math::is_uninitialized(seasonalityP)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: seasonalityP";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable seasonalityP: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 59;
            if (stan::math::is_uninitialized(sumsu)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sumsu";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sumsu: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 60;
            if (stan::math::is_uninitialized(newLevelP)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: newLevelP";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable newLevelP: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 61;
            if (stan::math::is_uninitialized(movingSum)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: movingSum";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable movingSum: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }

            // model body

            current_statement_begin__ = 157;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, CAUCHY_SD));
            if (sigma < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-cauchy_ccdf_log(0, 0, CAUCHY_SD));
            current_statement_begin__ = 158;
            lp_accum__.add(cauchy_log<propto__>(offsetSigma, MIN_SIGMA, CAUCHY_SD));
            if (offsetSigma < MIN_SIGMA) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-cauchy_ccdf_log(MIN_SIGMA, MIN_SIGMA, CAUCHY_SD));
            current_statement_begin__ = 159;
            lp_accum__.add(cauchy_log<propto__>(coefTrend, 0, CAUCHY_SD));
            current_statement_begin__ = 160;
            lp_accum__.add(beta_log<propto__>(powTrendBeta, POW_TREND_ALPHA, POW_TREND_BETA));
            current_statement_begin__ = 161;
            lp_accum__.add(beta_log<propto__>(levSm, 1, 2));
            current_statement_begin__ = 163;
            if (as_bool(USE_SMOOTHED_ERROR)) {
                current_statement_begin__ = 164;
                lp_accum__.add(cauchy_log<propto__>(innovSizeInit, (get_base1(y, 1, "y", 1) / 100), CAUCHY_SD));
                if (innovSizeInit < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-cauchy_ccdf_log(0, (get_base1(y, 1, "y", 1) / 100), CAUCHY_SD));
            } else {
                current_statement_begin__ = 166;
                lp_accum__.add(normal_log<propto__>(innovSizeInit, 0, 1));
                if (innovSizeInit < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, 0, 1));
            }
            current_statement_begin__ = 168;
            if (as_bool(USE_REGRESSION)) {

                current_statement_begin__ = 169;
                lp_accum__.add(cauchy_log<propto__>(regCoef, 0, REG_CAUCHY_SD));
                current_statement_begin__ = 170;
                lp_accum__.add(cauchy_log<propto__>(regOffset, 0, reg0CauchySd));
            } else {

                current_statement_begin__ = 172;
                lp_accum__.add(normal_log<propto__>(regCoef, 0, 1));
                current_statement_begin__ = 173;
                lp_accum__.add(normal_log<propto__>(regOffset, 0, 1));
            }
            current_statement_begin__ = 176;
            if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                current_statement_begin__ = 177;
                for (int t = 1; t <= SEASONALITY; ++t) {
                    current_statement_begin__ = 178;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(initS, t, "initS", 1), 0, 4));
                }
            } else {

                current_statement_begin__ = 180;
                lp_accum__.add(beta_log<propto__>(powSeason, POW_SEASON_ALPHA, POW_SEASON_BETA));
                current_statement_begin__ = 181;
                for (int t = 1; t <= SEASONALITY; ++t) {
                    current_statement_begin__ = 182;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(initS, t, "initS", 1), 0, (get_base1(y, t, "y", 1) * 0.3)));
                }
            }
            current_statement_begin__ = 185;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 186;
                if (as_bool(logical_eq(USE_SMOOTHED_ERROR, 0))) {
                    current_statement_begin__ = 187;
                    lp_accum__.add(student_t_log<propto__>(get_base1(y, t, "y", 1), nu, get_base1(expVal, t, "expVal", 1), ((sigma * pow(get_base1(expVal, t, "expVal", 1), powx)) + offsetSigma)));
                } else {
                    current_statement_begin__ = 189;
                    lp_accum__.add(student_t_log<propto__>(get_base1(y, t, "y", 1), nu, get_base1(expVal, t, "expVal", 1), ((sigma * get_base1(smoothedInnovSize, (t - 1), "smoothedInnovSize", 1)) + offsetSigma)));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("regCoef");
        names__.push_back("regOffset");
        names__.push_back("nu");
        names__.push_back("sigma");
        names__.push_back("levSm");
        names__.push_back("llevSm");
        names__.push_back("sSm");
        names__.push_back("powx");
        names__.push_back("powTrendBeta");
        names__.push_back("coefTrend");
        names__.push_back("offsetSigma");
        names__.push_back("innovSm");
        names__.push_back("innovSizeInit");
        names__.push_back("initS");
        names__.push_back("powSeason");
        names__.push_back("powTrend");
        names__.push_back("l");
        names__.push_back("l0");
        names__.push_back("s");
        names__.push_back("r");
        names__.push_back("expVal");
        names__.push_back("smoothedInnovSize");
        names__.push_back("seasonalityP");
        names__.push_back("sumsu");
        names__.push_back("newLevelP");
        names__.push_back("movingSum");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SEASONALITY);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((N + SEASONALITY) + 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_SGT_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> regCoef = in__.vector_constrain(J);
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            vars__.push_back(regCoef(j_1__));
        }

        double regOffset = in__.scalar_constrain();
        vars__.push_back(regOffset);

        double nu = in__.scalar_lub_constrain(MIN_NU, MAX_NU);
        vars__.push_back(nu);

        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);

        double levSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(levSm);

        double llevSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(llevSm);

        double sSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(sSm);

        double powx = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(powx);

        double powTrendBeta = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(powTrendBeta);

        double coefTrend = in__.scalar_constrain();
        vars__.push_back(coefTrend);

        double offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA);
        vars__.push_back(offsetSigma);

        double innovSm = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(innovSm);

        double innovSizeInit = in__.scalar_lb_constrain(0);
        vars__.push_back(innovSizeInit);

        Eigen::Matrix<double, Eigen::Dynamic, 1> initS = in__.vector_constrain(SEASONALITY);
        size_t initS_j_1_max__ = SEASONALITY;
        for (size_t j_1__ = 0; j_1__ < initS_j_1_max__; ++j_1__) {
            vars__.push_back(initS(j_1__));
        }

        double powSeason = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(powSeason);

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 51;
            double powTrend;
            (void) powTrend;  // dummy to suppress unused var warning
            stan::math::initialize(powTrend, DUMMY_VAR__);
            stan::math::fill(powTrend, DUMMY_VAR__);

            current_statement_begin__ = 52;
            validate_non_negative_index("l", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> l(N);
            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l, DUMMY_VAR__);

            current_statement_begin__ = 53;
            validate_non_negative_index("l0", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> l0(N);
            stan::math::initialize(l0, DUMMY_VAR__);
            stan::math::fill(l0, DUMMY_VAR__);

            current_statement_begin__ = 54;
            validate_non_negative_index("s", "((N + SEASONALITY) + 1)", ((N + SEASONALITY) + 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> s(((N + SEASONALITY) + 1));
            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s, DUMMY_VAR__);

            current_statement_begin__ = 55;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> r(N);
            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r, DUMMY_VAR__);

            current_statement_begin__ = 56;
            validate_non_negative_index("expVal", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> expVal(N);
            stan::math::initialize(expVal, DUMMY_VAR__);
            stan::math::fill(expVal, DUMMY_VAR__);

            current_statement_begin__ = 57;
            validate_non_negative_index("smoothedInnovSize", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> smoothedInnovSize(N);
            stan::math::initialize(smoothedInnovSize, DUMMY_VAR__);
            stan::math::fill(smoothedInnovSize, DUMMY_VAR__);

            current_statement_begin__ = 58;
            double seasonalityP;
            (void) seasonalityP;  // dummy to suppress unused var warning
            stan::math::initialize(seasonalityP, DUMMY_VAR__);
            stan::math::fill(seasonalityP, DUMMY_VAR__);

            current_statement_begin__ = 59;
            double sumsu;
            (void) sumsu;  // dummy to suppress unused var warning
            stan::math::initialize(sumsu, DUMMY_VAR__);
            stan::math::fill(sumsu, DUMMY_VAR__);

            current_statement_begin__ = 60;
            double newLevelP;
            (void) newLevelP;  // dummy to suppress unused var warning
            stan::math::initialize(newLevelP, DUMMY_VAR__);
            stan::math::fill(newLevelP, DUMMY_VAR__);

            current_statement_begin__ = 61;
            double movingSum;
            (void) movingSum;  // dummy to suppress unused var warning
            stan::math::initialize(movingSum, DUMMY_VAR__);
            stan::math::fill(movingSum, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 63;
            if (as_bool(USE_REGRESSION)) {
                current_statement_begin__ = 64;
                stan::math::assign(r, add(multiply(xreg, regCoef), regOffset));
            } else {
                current_statement_begin__ = 66;
                stan::math::assign(r, rep_vector(0, N));
            }
            current_statement_begin__ = 68;
            if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                current_statement_begin__ = 69;
                stan::math::assign(sumsu, 0);
                current_statement_begin__ = 70;
                for (int i = 1; i <= SEASONALITY; ++i) {
                    current_statement_begin__ = 71;
                    stan::math::assign(sumsu, (sumsu + stan::math::exp(get_base1(initS, i, "initS", 1))));
                }
                current_statement_begin__ = 72;
                for (int i = 1; i <= SEASONALITY; ++i) {

                    current_statement_begin__ = 73;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((stan::math::exp(get_base1(initS, i, "initS", 1)) * SEASONALITY) / sumsu), 
                                "assigning variable s");
                }
                current_statement_begin__ = 76;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            ((get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)) / get_base1(s, 1, "s", 1)), 
                            "assigning variable l");
            } else {

                current_statement_begin__ = 78;
                for (int i = 1; i <= SEASONALITY; ++i) {
                    current_statement_begin__ = 79;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(initS, i, "initS", 1), 
                                "assigning variable s");
                }
                current_statement_begin__ = 80;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)), 
                            "assigning variable l");
            }
            current_statement_begin__ = 83;
            stan::model::assign(s, 
                        stan::model::cons_list(stan::model::index_uni(((N + SEASONALITY) + 1)), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable s");
            current_statement_begin__ = 84;
            stan::model::assign(s, 
                        stan::model::cons_list(stan::model::index_uni((SEASONALITY + 1)), stan::model::nil_index_list()), 
                        get_base1(s, 1, "s", 1), 
                        "assigning variable s");
            current_statement_begin__ = 85;
            stan::model::assign(s, 
                        stan::model::cons_list(stan::model::index_uni((SEASONALITY + 2)), stan::model::nil_index_list()), 
                        get_base1(s, 2, "s", 1), 
                        "assigning variable s");
            current_statement_begin__ = 87;
            if (as_bool(USE_SMOOTHED_ERROR)) {
                current_statement_begin__ = 88;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            innovSizeInit, 
                            "assigning variable smoothedInnovSize");
            } else {
                current_statement_begin__ = 90;
                stan::model::assign(smoothedInnovSize, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            1, 
                            "assigning variable smoothedInnovSize");
            }
            current_statement_begin__ = 92;
            stan::math::assign(powTrend, (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) + MIN_POW_TREND));
            current_statement_begin__ = 93;
            stan::model::assign(expVal, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        get_base1(y, 1, "y", 1), 
                        "assigning variable expVal");
            current_statement_begin__ = 95;
            if (as_bool(logical_eq(LEVEL_CALC_METHOD, 3))) {
                current_statement_begin__ = 96;
                stan::model::assign(l0, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(l, 1, "l", 1), 
                            "assigning variable l0");
            } else {
                current_statement_begin__ = 98;
                stan::math::assign(l0, rep_vector(0, N));
            }
            current_statement_begin__ = 100;
            if (as_bool(logical_gt(LEVEL_CALC_METHOD, 0))) {

                current_statement_begin__ = 101;
                stan::math::assign(movingSum, (get_base1(y, 1, "y", 1) - get_base1(r, 1, "r", 1)));
                current_statement_begin__ = 102;
                for (int t = 2; t <= SEASONALITY; ++t) {
                    current_statement_begin__ = 103;
                    stan::math::assign(movingSum, ((movingSum + get_base1(y, t, "y", 1)) - get_base1(r, t, "r", 1)));
                }
            }
            current_statement_begin__ = 106;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 107;
                if (as_bool((primitive_value(logical_gt(LEVEL_CALC_METHOD, 0)) && primitive_value(logical_gt(t, SEASONALITY))))) {
                    current_statement_begin__ = 108;
                    stan::math::assign(movingSum, ((movingSum + (get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1))) - (get_base1(y, (t - SEASONALITY), "y", 1) - get_base1(r, (t - SEASONALITY), "r", 1))));
                }
                current_statement_begin__ = 111;
                if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                    current_statement_begin__ = 112;
                    stan::model::assign(expVal, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (((get_base1(l, (t - 1), "l", 1) + (coefTrend * pow(get_base1(l, (t - 1), "l", 1), powTrend))) * get_base1(s, t, "s", 1)) + get_base1(r, t, "r", 1)), 
                                "assigning variable expVal");
                    current_statement_begin__ = 113;
                    stan::math::assign(newLevelP, ((get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1)) / get_base1(s, t, "s", 1)));
                } else {

                    current_statement_begin__ = 115;
                    stan::model::assign(expVal, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (((get_base1(l, (t - 1), "l", 1) + (coefTrend * pow(get_base1(l, (t - 1), "l", 1), powTrend))) + (get_base1(s, t, "s", 1) * pow(get_base1(l, (t - 1), "l", 1), powSeason))) + get_base1(r, t, "r", 1)), 
                                "assigning variable expVal");
                    current_statement_begin__ = 116;
                    stan::math::assign(newLevelP, ((get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1)) - (get_base1(s, t, "s", 1) * pow(get_base1(l, (t - 1), "l", 1), powSeason))));
                }
                current_statement_begin__ = 120;
                if (as_bool(logical_eq(LEVEL_CALC_METHOD, 0))) {
                    current_statement_begin__ = 121;
                    stan::model::assign(l, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((levSm * newLevelP) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                                "assigning variable l");
                } else if (as_bool(logical_eq(LEVEL_CALC_METHOD, 2))) {

                    current_statement_begin__ = 123;
                    if (as_bool(logical_lte(t, SEASONALITY))) {
                        current_statement_begin__ = 124;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    ((levSm * newLevelP) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                                    "assigning variable l");
                    } else {
                        current_statement_begin__ = 126;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    (((levSm * movingSum) / SEASONALITY) + ((1 - levSm) * get_base1(l, (t - 1), "l", 1))), 
                                    "assigning variable l");
                    }
                } else if (as_bool(logical_eq(LEVEL_CALC_METHOD, 3))) {

                    current_statement_begin__ = 129;
                    stan::model::assign(l0, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((levSm * newLevelP) + ((1 - levSm) * get_base1(l0, (t - 1), "l0", 1))), 
                                "assigning variable l0");
                    current_statement_begin__ = 130;
                    if (as_bool(logical_lte(t, SEASONALITY))) {
                        current_statement_begin__ = 131;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    get_base1(l0, t, "l0", 1), 
                                    "assigning variable l");
                    } else {
                        current_statement_begin__ = 133;
                        stan::model::assign(l, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                    ((llevSm * get_base1(l0, t, "l0", 1)) + (((1 - llevSm) * movingSum) / SEASONALITY)), 
                                    "assigning variable l");
                    }
                }
                current_statement_begin__ = 137;
                if (as_bool(logical_eq(SEASONALITY_TYPE, 0))) {

                    current_statement_begin__ = 138;
                    stan::math::assign(seasonalityP, (((sSm * (get_base1(y, t, "y", 1) - get_base1(r, t, "r", 1))) / get_base1(l, t, "l", 1)) + ((1 - sSm) * get_base1(s, t, "s", 1))));
                } else {

                    current_statement_begin__ = 140;
                    stan::math::assign(seasonalityP, (((sSm * ((get_base1(y, t, "y", 1) - get_base1(l, t, "l", 1)) - get_base1(r, t, "r", 1))) / pow(get_base1(l, (t - 1), "l", 1), powSeason)) + ((1 - sSm) * get_base1(s, t, "s", 1))));
                }
                current_statement_begin__ = 143;
                if (as_bool(logical_gt(fractSeasonality, 0))) {

                    current_statement_begin__ = 144;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni(((t + SEASONALITY) + 1)), stan::model::nil_index_list()), 
                                seasonalityP, 
                                "assigning variable s");
                    current_statement_begin__ = 145;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni((t + SEASONALITY)), stan::model::nil_index_list()), 
                                ((fractSeasonality * get_base1(s, (t + SEASONALITY), "s", 1)) + ((1 - fractSeasonality) * seasonalityP)), 
                                "assigning variable s");
                } else {
                    current_statement_begin__ = 147;
                    stan::model::assign(s, 
                                stan::model::cons_list(stan::model::index_uni((t + SEASONALITY)), stan::model::nil_index_list()), 
                                seasonalityP, 
                                "assigning variable s");
                }
                current_statement_begin__ = 150;
                if (as_bool(USE_SMOOTHED_ERROR)) {
                    current_statement_begin__ = 151;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                ((innovSm * stan::math::fabs((get_base1(y, t, "y", 1) - get_base1(expVal, t, "expVal", 1)))) + ((1 - innovSm) * get_base1(smoothedInnovSize, (t - 1), "smoothedInnovSize", 1))), 
                                "assigning variable smoothedInnovSize");
                } else {
                    current_statement_begin__ = 153;
                    stan::model::assign(smoothedInnovSize, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable smoothedInnovSize");
                }
            }

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 51;
            check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
            check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);

            current_statement_begin__ = 52;
            check_greater_or_equal(function__, "l", l, 0);

            current_statement_begin__ = 53;
            check_greater_or_equal(function__, "l0", l0, 0);

            current_statement_begin__ = 56;
            check_greater_or_equal(function__, "expVal", expVal, 0);

            current_statement_begin__ = 57;
            check_greater_or_equal(function__, "smoothedInnovSize", smoothedInnovSize, 0);

            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(powTrend);
                size_t l_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                    vars__.push_back(l(j_1__));
                }
                size_t l0_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < l0_j_1_max__; ++j_1__) {
                    vars__.push_back(l0(j_1__));
                }
                size_t s_j_1_max__ = ((N + SEASONALITY) + 1);
                for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                    vars__.push_back(s(j_1__));
                }
                size_t r_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                    vars__.push_back(r(j_1__));
                }
                size_t expVal_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                    vars__.push_back(expVal(j_1__));
                }
                size_t smoothedInnovSize_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                    vars__.push_back(smoothedInnovSize(j_1__));
                }
                vars__.push_back(seasonalityP);
                vars__.push_back(sumsu);
                vars__.push_back(newLevelP);
                vars__.push_back(movingSum);
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    std::string model_name() const {
        return "model_SGT";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "regCoef" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "regOffset";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "levSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "llevSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powx";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powTrendBeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "coefTrend";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "offsetSigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSizeInit";
        param_names__.push_back(param_name_stream__.str());
        size_t initS_j_1_max__ = SEASONALITY;
        for (size_t j_1__ = 0; j_1__ < initS_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "initS" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "powSeason";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "powTrend";
            param_names__.push_back(param_name_stream__.str());
            size_t l_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t l0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t s_j_1_max__ = ((N + SEASONALITY) + 1);
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t expVal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "expVal" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t smoothedInnovSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "smoothedInnovSize" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "seasonalityP";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "sumsu";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "newLevelP";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "movingSum";
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t regCoef_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < regCoef_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "regCoef" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "regOffset";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "levSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "llevSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powx";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powTrendBeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "coefTrend";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "offsetSigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "innovSizeInit";
        param_names__.push_back(param_name_stream__.str());
        size_t initS_j_1_max__ = SEASONALITY;
        for (size_t j_1__ = 0; j_1__ < initS_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "initS" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "powSeason";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "powTrend";
            param_names__.push_back(param_name_stream__.str());
            size_t l_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t l0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < l0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t s_j_1_max__ = ((N + SEASONALITY) + 1);
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < r_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t expVal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < expVal_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "expVal" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t smoothedInnovSize_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < smoothedInnovSize_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "smoothedInnovSize" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "seasonalityP";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "sumsu";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "newLevelP";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "movingSum";
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}  // namespace

typedef model_SGT_namespace::model_SGT stan_model;

#ifndef USING_R

stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}

#endif


#endif
