% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_oil_model.R
\name{mbal_time}
\alias{mbal_time}
\title{A list object of class 'time' for material balance models}
\usage{
mbal_time(x, unit = "day")
}
\arguments{
\item{x}{a vector of times or a daily sequence of dates}

\item{unit}{time/date unit of vector x}
}
\value{
a list of class 'time' with all the required parameters for the mbal_perform_oil(), mbal_perform_gas(), mbal_optim_oil(), mbal_optim_gas(), mbal_forecast_oil(), and mbal_forecast_gas() S3 methods
}
\description{
Create an object of class 'time'
}
\examples{
mbal_time_1 <- mbal_time(c(0:4) * 365, unit = "day")

mbal_time_1

mbal_time_2 <- mbal_time(c(0:4), unit = "month")

mbal_time_2

mbal_time_3 <- mbal_time(c(0:4), unit = "year")

mbal_time_3

mbal_time_4 <- mbal_time(seq(as.Date("2020/1/1"), by = "year",
length.out = 5), unit = "date")

mbal_time_4
}
