% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{ctryShpLyrName2Num}
\alias{ctryShpLyrName2Num}
\title{Get the integer number of the layer.}
\usage{
ctryShpLyrName2Num(ctryCode, layerName,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{The ctryCode to process}

\item{layerName}{- the name of the polygon layer}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
Integer layer number
}
\description{
Get the integer number of the layer. Is the last character in the name 
    and is a digit. E.g. for the 3rd layer in Kenya shapefile polygon 
    named "KEN_adm3" the layer number is \code{3}. The lowest layer number
    is \code{0}
}
\examples{
\dontrun{
  Rnightlights:::ctryShpLyrName2Num("KEN", "KEN_adm1") #returns 1
}

}
