% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrycode.R
\name{getAllNlCtryCodes}
\alias{getAllNlCtryCodes}
\title{Get all known valid ISO3 country codes}
\usage{
getAllNlCtryCodes(omit = "none")
}
\arguments{
\item{omit}{The ctryCodes to exclude from processing based on observed
behaviour. The option can take the following values:
\itemize{
    \item{\code{missing}} ctryCodes that are in \code{rworldmap} but not on \code{GADM}
    \item{\code{long}} ctryCodes that take very long to process using 'rast'
        options. May improve using more processors or using 'gdal' 
        options.
    \item{\code{error}} ctryCodes whose polygons have caused processing to crash
        in tests. Not extensively tested and may work fine on other 
        systems.
    \item{\code{all}} Omit a combination of all the above options
    \item{\code{none}} Do not omit any ctryCodes
}}
}
\value{
character vector of country codes
}
\description{
Get a list of all known valid ISO3 country codes.
}
