// Generated by rstantools.  Do not edit by hand.

/*
    RoBTT is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    RoBTT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RoBTT.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_lognormal_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 180, column 2 to column 21)",
                                                      " (in 'string', line 181, column 2 to column 25)",
                                                      " (in 'string', line 182, column 2 to column 117)",
                                                      " (in 'string', line 183, column 2 to column 115)",
                                                      " (in 'string', line 186, column 2 to column 20)",
                                                      " (in 'string', line 187, column 2 to column 17)",
                                                      " (in 'string', line 188, column 2 to column 20)",
                                                      " (in 'string', line 189, column 2 to column 21)",
                                                      " (in 'string', line 190, column 2 to column 24)",
                                                      " (in 'string', line 197, column 4 to column 66)",
                                                      " (in 'string', line 198, column 4 to column 66)",
                                                      " (in 'string', line 199, column 4 to column 62)",
                                                      " (in 'string', line 196, column 7 to line 200, column 3)",
                                                      " (in 'string', line 193, column 4 to column 62)",
                                                      " (in 'string', line 194, column 4 to column 62)",
                                                      " (in 'string', line 195, column 4 to column 62)",
                                                      " (in 'string', line 192, column 15 to line 196, column 3)",
                                                      " (in 'string', line 192, column 2 to line 200, column 3)",
                                                      " (in 'string', line 205, column 4 to column 51)",
                                                      " (in 'string', line 206, column 4 to column 51)",
                                                      " (in 'string', line 204, column 7 to line 207, column 3)",
                                                      " (in 'string', line 202, column 4 to column 49)",
                                                      " (in 'string', line 203, column 4 to column 49)",
                                                      " (in 'string', line 201, column 15 to line 204, column 3)",
                                                      " (in 'string', line 201, column 2 to line 207, column 3)",
                                                      " (in 'string', line 209, column 4 to column 104)",
                                                      " (in 'string', line 210, column 4 to column 95)",
                                                      " (in 'string', line 208, column 15 to line 211, column 3)",
                                                      " (in 'string', line 208, column 2 to line 211, column 3)",
                                                      " (in 'string', line 215, column 2 to column 33)",
                                                      " (in 'string', line 216, column 2 to column 40)",
                                                      " (in 'string', line 219, column 4 to column 93)",
                                                      " (in 'string', line 218, column 15 to line 220, column 3)",
                                                      " (in 'string', line 218, column 2 to line 220, column 3)",
                                                      " (in 'string', line 222, column 4 to column 91)",
                                                      " (in 'string', line 221, column 15 to line 223, column 3)",
                                                      " (in 'string', line 221, column 2 to line 223, column 3)",
                                                      " (in 'string', line 229, column 4 to column 90)",
                                                      " (in 'string', line 228, column 7 to line 230, column 3)",
                                                      " (in 'string', line 226, column 4 to column 63)",
                                                      " (in 'string', line 227, column 4 to column 63)",
                                                      " (in 'string', line 225, column 16 to line 228, column 3)",
                                                      " (in 'string', line 225, column 2 to line 230, column 3)",
                                                      " (in 'string', line 153, column 2 to column 12)",
                                                      " (in 'string', line 155, column 2 to column 18)",
                                                      " (in 'string', line 156, column 2 to column 18)",
                                                      " (in 'string', line 158, column 9 to column 28)",
                                                      " (in 'string', line 158, column 2 to column 33)",
                                                      " (in 'string', line 159, column 9 to column 28)",
                                                      " (in 'string', line 159, column 2 to column 33)",
                                                      " (in 'string', line 161, column 9 to column 27)",
                                                      " (in 'string', line 161, column 2 to column 36)",
                                                      " (in 'string', line 162, column 9 to column 27)",
                                                      " (in 'string', line 162, column 2 to column 34)",
                                                      " (in 'string', line 164, column 2 to column 11)",
                                                      " (in 'string', line 165, column 2 to column 11)",
                                                      " (in 'string', line 167, column 9 to column 26)",
                                                      " (in 'string', line 167, column 2 to column 37)",
                                                      " (in 'string', line 168, column 9 to column 26)",
                                                      " (in 'string', line 168, column 2 to column 37)",
                                                      " (in 'string', line 169, column 20 to column 37)",
                                                      " (in 'string', line 169, column 2 to column 39)",
                                                      " (in 'string', line 170, column 20 to column 37)",
                                                      " (in 'string', line 170, column 2 to column 39)",
                                                      " (in 'string', line 172, column 9 to column 26)",
                                                      " (in 'string', line 172, column 2 to column 36)",
                                                      " (in 'string', line 173, column 9 to column 26)",
                                                      " (in 'string', line 173, column 2 to column 36)",
                                                      " (in 'string', line 174, column 9 to column 26)",
                                                      " (in 'string', line 174, column 2 to column 47)",
                                                      " (in 'string', line 175, column 9 to column 26)",
                                                      " (in 'string', line 175, column 2 to column 47)",
                                                      " (in 'string', line 176, column 2 to column 19)",
                                                      " (in 'string', line 177, column 2 to column 19)",
                                                      " (in 'string', line 182, column 111 to column 115)",
                                                      " (in 'string', line 183, column 109 to column 113)",
                                                      " (in 'string', line 6, column 4 to column 13)",
                                                      " (in 'string', line 5, column 32 to line 7, column 3)",
                                                      " (in 'string', line 9, column 4 to column 25)",
                                                      " (in 'string', line 8, column 39 to line 10, column 3)",
                                                      " (in 'string', line 14, column 4 to column 75)",
                                                      " (in 'string', line 13, column 61 to line 15, column 3)",
                                                      " (in 'string', line 19, column 4 to column 12)",
                                                      " (in 'string', line 23, column 6 to column 17)",
                                                      " (in 'string', line 21, column 6 to column 31)",
                                                      " (in 'string', line 20, column 4 to line 23, column 17)",
                                                      " (in 'string', line 24, column 4 to column 14)",
                                                      " (in 'string', line 18, column 38 to line 25, column 3)",
                                                      " (in 'string', line 27, column 4 to column 12)",
                                                      " (in 'string', line 31, column 6 to column 17)",
                                                      " (in 'string', line 29, column 6 to column 31)",
                                                      " (in 'string', line 28, column 4 to line 31, column 17)",
                                                      " (in 'string', line 32, column 4 to column 14)",
                                                      " (in 'string', line 26, column 38 to line 33, column 3)",
                                                      " (in 'string', line 45, column 4 to column 12)",
                                                      " (in 'string', line 134, column 6 to column 61)",
                                                      " (in 'string', line 143, column 8 to column 65)",
                                                      " (in 'string', line 142, column 35 to line 144, column 7)",
                                                      " (in 'string', line 142, column 12 to line 144, column 7)",
                                                      " (in 'string', line 141, column 8 to column 65)",
                                                      " (in 'string', line 140, column 35 to line 142, column 7)",
                                                      " (in 'string', line 140, column 12 to line 144, column 7)",
                                                      " (in 'string', line 136, column 8 to line 139, column 10)",
                                                      " (in 'string', line 135, column 52 to line 140, column 7)",
                                                      " (in 'string', line 135, column 6 to line 144, column 7)",
                                                      " (in 'string', line 133, column 29 to line 145, column 5)",
                                                      " (in 'string', line 133, column 10 to line 145, column 5)",
                                                      " (in 'string', line 122, column 6 to column 75)",
                                                      " (in 'string', line 131, column 8 to column 79)",
                                                      " (in 'string', line 130, column 35 to line 132, column 7)",
                                                      " (in 'string', line 130, column 12 to line 132, column 7)",
                                                      " (in 'string', line 129, column 8 to column 79)",
                                                      " (in 'string', line 128, column 35 to line 130, column 7)",
                                                      " (in 'string', line 128, column 12 to line 132, column 7)",
                                                      " (in 'string', line 124, column 8 to line 127, column 10)",
                                                      " (in 'string', line 123, column 52 to line 128, column 7)",
                                                      " (in 'string', line 123, column 6 to line 132, column 7)",
                                                      " (in 'string', line 121, column 29 to line 133, column 5)",
                                                      " (in 'string', line 121, column 10 to line 145, column 5)",
                                                      " (in 'string', line 120, column 6 to column 78)",
                                                      " (in 'string', line 119, column 29 to line 121, column 5)",
                                                      " (in 'string', line 119, column 10 to line 145, column 5)",
                                                      " (in 'string', line 108, column 6 to column 80)",
                                                      " (in 'string', line 117, column 8 to column 84)",
                                                      " (in 'string', line 116, column 35 to line 118, column 7)",
                                                      " (in 'string', line 116, column 12 to line 118, column 7)",
                                                      " (in 'string', line 115, column 8 to column 84)",
                                                      " (in 'string', line 114, column 35 to line 116, column 7)",
                                                      " (in 'string', line 114, column 12 to line 118, column 7)",
                                                      " (in 'string', line 110, column 8 to line 113, column 10)",
                                                      " (in 'string', line 109, column 52 to line 114, column 7)",
                                                      " (in 'string', line 109, column 6 to line 118, column 7)",
                                                      " (in 'string', line 107, column 29 to line 119, column 5)",
                                                      " (in 'string', line 107, column 10 to line 145, column 5)",
                                                      " (in 'string', line 96, column 6 to column 76)",
                                                      " (in 'string', line 105, column 8 to column 80)",
                                                      " (in 'string', line 104, column 35 to line 106, column 7)",
                                                      " (in 'string', line 104, column 12 to line 106, column 7)",
                                                      " (in 'string', line 103, column 8 to column 80)",
                                                      " (in 'string', line 102, column 35 to line 104, column 7)",
                                                      " (in 'string', line 102, column 12 to line 106, column 7)",
                                                      " (in 'string', line 98, column 8 to line 101, column 10)",
                                                      " (in 'string', line 97, column 52 to line 102, column 7)",
                                                      " (in 'string', line 97, column 6 to line 106, column 7)",
                                                      " (in 'string', line 95, column 29 to line 107, column 5)",
                                                      " (in 'string', line 95, column 10 to line 145, column 5)",
                                                      " (in 'string', line 84, column 6 to column 101)",
                                                      " (in 'string', line 93, column 8 to column 105)",
                                                      " (in 'string', line 92, column 35 to line 94, column 7)",
                                                      " (in 'string', line 92, column 12 to line 94, column 7)",
                                                      " (in 'string', line 91, column 8 to column 105)",
                                                      " (in 'string', line 90, column 35 to line 92, column 7)",
                                                      " (in 'string', line 90, column 12 to line 94, column 7)",
                                                      " (in 'string', line 86, column 8 to line 89, column 10)",
                                                      " (in 'string', line 85, column 52 to line 90, column 7)",
                                                      " (in 'string', line 85, column 6 to line 94, column 7)",
                                                      " (in 'string', line 83, column 29 to line 95, column 5)",
                                                      " (in 'string', line 83, column 10 to line 145, column 5)",
                                                      " (in 'string', line 72, column 6 to column 77)",
                                                      " (in 'string', line 81, column 8 to column 81)",
                                                      " (in 'string', line 80, column 35 to line 82, column 7)",
                                                      " (in 'string', line 80, column 12 to line 82, column 7)",
                                                      " (in 'string', line 79, column 8 to column 81)",
                                                      " (in 'string', line 78, column 35 to line 80, column 7)",
                                                      " (in 'string', line 78, column 12 to line 82, column 7)",
                                                      " (in 'string', line 74, column 8 to line 77, column 10)",
                                                      " (in 'string', line 73, column 52 to line 78, column 7)",
                                                      " (in 'string', line 73, column 6 to line 82, column 7)",
                                                      " (in 'string', line 71, column 29 to line 83, column 5)",
                                                      " (in 'string', line 71, column 10 to line 145, column 5)",
                                                      " (in 'string', line 60, column 6 to column 80)",
                                                      " (in 'string', line 69, column 8 to column 84)",
                                                      " (in 'string', line 68, column 35 to line 70, column 7)",
                                                      " (in 'string', line 68, column 12 to line 70, column 7)",
                                                      " (in 'string', line 67, column 8 to column 84)",
                                                      " (in 'string', line 66, column 35 to line 68, column 7)",
                                                      " (in 'string', line 66, column 12 to line 70, column 7)",
                                                      " (in 'string', line 62, column 8 to line 65, column 10)",
                                                      " (in 'string', line 61, column 52 to line 66, column 7)",
                                                      " (in 'string', line 61, column 6 to line 70, column 7)",
                                                      " (in 'string', line 59, column 29 to line 71, column 5)",
                                                      " (in 'string', line 59, column 10 to line 145, column 5)",
                                                      " (in 'string', line 48, column 6 to column 77)",
                                                      " (in 'string', line 57, column 8 to column 81)",
                                                      " (in 'string', line 56, column 35 to line 58, column 7)",
                                                      " (in 'string', line 56, column 12 to line 58, column 7)",
                                                      " (in 'string', line 55, column 8 to column 81)",
                                                      " (in 'string', line 54, column 35 to line 56, column 7)",
                                                      " (in 'string', line 54, column 12 to line 58, column 7)",
                                                      " (in 'string', line 50, column 8 to line 53, column 10)",
                                                      " (in 'string', line 49, column 52 to line 54, column 7)",
                                                      " (in 'string', line 49, column 6 to line 58, column 7)",
                                                      " (in 'string', line 47, column 23 to line 59, column 5)",
                                                      " (in 'string', line 47, column 4 to line 145, column 5)",
                                                      " (in 'string', line 147, column 4 to column 14)",
                                                      " (in 'string', line 44, column 107 to line 148, column 3)"};
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
Jeffreys_mu_lpdf(const T0__& mu, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 77;
    return 0;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct Jeffreys_mu_lpdf_functor__ {
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& mu, std::ostream* pstream__)  const 
{
return Jeffreys_mu_lpdf<propto__>(mu, pstream__);
}
};
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
Jeffreys_sigma_lpdf(const T0__& sigma2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 79;
    return stan::math::log((1 / sigma2));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct Jeffreys_sigma_lpdf_functor__ {
template <bool propto__, typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& sigma2, std::ostream* pstream__)  const 
{
return Jeffreys_sigma_lpdf<propto__>(sigma2, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<T0__, T1__, T2__,
T3__>
pool_sigma(const T0__& sigma1, const T1__& sigma2, const T2__& N1,
           const T3__& N2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 81;
    return stan::math::sqrt(
             (((pow(sigma1, 2) * N1) + (pow(sigma2, 2) * N2)) / (N1 + N2)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct pool_sigma_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<T0__, T1__, T2__,
T3__>
operator()(const T0__& sigma1, const T1__& sigma2, const T2__& N1,
           const T3__& N2, std::ostream* pstream__)  const 
{
return pool_sigma(sigma1, sigma2, N1, N2, pstream__);
}
};
template <typename T1__>
stan::promote_args_t<T1__>
coefs_lb(const int& type, const T1__& bound, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ lb;
    lb = DUMMY_VAR__;
    
    current_statement__ = 86;
    if (logical_eq(type, 0)) {
      current_statement__ = 85;
      lb = stan::math::negative_infinity();
    } else {
      current_statement__ = 84;
      lb = bound;
    }
    current_statement__ = 87;
    return lb;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct coefs_lb_functor__ {
template <typename T1__>
stan::promote_args_t<T1__>
operator()(const int& type, const T1__& bound, std::ostream* pstream__)  const 
{
return coefs_lb(type, bound, pstream__);
}
};
template <typename T1__>
stan::promote_args_t<T1__>
coefs_ub(const int& type, const T1__& bound, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ lb;
    lb = DUMMY_VAR__;
    
    current_statement__ = 92;
    if (logical_eq(type, 0)) {
      current_statement__ = 91;
      lb = stan::math::positive_infinity();
    } else {
      current_statement__ = 90;
      lb = bound;
    }
    current_statement__ = 93;
    return lb;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct coefs_ub_functor__ {
template <typename T1__>
stan::promote_args_t<T1__>
operator()(const int& type, const T1__& bound, std::ostream* pstream__)  const 
{
return coefs_ub(type, bound, pstream__);
}
};
template <typename T0__, typename T2__, typename T4__>
stan::promote_args_t<T0__, stan::value_type_t<T2__>,
stan::value_type_t<T4__>>
set_prior(const T0__& parameter, const int& prior_type,
          const T2__& prior_parameters_arg__,
          const std::vector<int>& bounds_type, const T4__& bounds_arg__,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T2__>,
          stan::value_type_t<T4__>>;
  const auto& prior_parameters = to_ref(prior_parameters_arg__);
  const auto& bounds = to_ref(bounds_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ ll;
    ll = DUMMY_VAR__;
    
    current_statement__ = 194;
    if (logical_eq(prior_type, 1)) {
      current_statement__ = 183;
      ll = normal_lpdf<false>(parameter, prior_parameters[(1 - 1)],
             prior_parameters[(2 - 1)]);
      current_statement__ = 192;
      if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
          primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
        current_statement__ = 190;
        ll = (ll -
               log_diff_exp(
                 normal_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)]),
                 normal_lcdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)])));
      } else {
        current_statement__ = 189;
        if (logical_neq(bounds_type[(1 - 1)], 0)) {
          current_statement__ = 187;
          ll = (ll -
                 normal_lccdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)]));
        } else {
          current_statement__ = 186;
          if (logical_neq(bounds_type[(2 - 1)], 0)) {
            current_statement__ = 184;
            ll = (ll -
                   normal_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)]));
          } 
        }
      }
    } else {
      current_statement__ = 182;
      if (logical_eq(prior_type, 2)) {
        current_statement__ = 171;
        ll = lognormal_lpdf<false>(parameter, prior_parameters[(1 - 1)],
               prior_parameters[(2 - 1)]);
        current_statement__ = 180;
        if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
            primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
          current_statement__ = 178;
          ll = (ll -
                 log_diff_exp(
                   lognormal_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)]),
                   lognormal_lcdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)])));
        } else {
          current_statement__ = 177;
          if (logical_neq(bounds_type[(1 - 1)], 0)) {
            current_statement__ = 175;
            ll = (ll -
                   lognormal_lccdf(bounds[(1 - 1)],
                     prior_parameters[(1 - 1)], prior_parameters[(2 - 1)]));
          } else {
            current_statement__ = 174;
            if (logical_neq(bounds_type[(2 - 1)], 0)) {
              current_statement__ = 172;
              ll = (ll -
                     lognormal_lcdf(bounds[(2 - 1)],
                       prior_parameters[(1 - 1)], prior_parameters[(2 - 1)]));
            } 
          }
        }
      } else {
        current_statement__ = 170;
        if (logical_eq(prior_type, 3)) {
          current_statement__ = 159;
          ll = cauchy_lpdf<false>(parameter, prior_parameters[(1 - 1)],
                 prior_parameters[(2 - 1)]);
          current_statement__ = 168;
          if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
              primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
            current_statement__ = 166;
            ll = (ll -
                   log_diff_exp(
                     cauchy_lcdf(bounds[(2 - 1)], prior_parameters[(1 - 1)],
                       prior_parameters[(2 - 1)]),
                     cauchy_lcdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                       prior_parameters[(2 - 1)])));
          } else {
            current_statement__ = 165;
            if (logical_neq(bounds_type[(1 - 1)], 0)) {
              current_statement__ = 163;
              ll = (ll -
                     cauchy_lccdf(bounds[(1 - 1)], prior_parameters[(1 - 1)],
                       prior_parameters[(2 - 1)]));
            } else {
              current_statement__ = 162;
              if (logical_neq(bounds_type[(2 - 1)], 0)) {
                current_statement__ = 160;
                ll = (ll -
                       cauchy_lcdf(bounds[(2 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)]));
              } 
            }
          }
        } else {
          current_statement__ = 158;
          if (logical_eq(prior_type, 4)) {
            current_statement__ = 147;
            ll = student_t_lpdf<false>(parameter, prior_parameters[(1 - 1)],
                   prior_parameters[(2 - 1)], prior_parameters[(3 - 1)]);
            current_statement__ = 156;
            if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
                primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
              current_statement__ = 154;
              ll = (ll -
                     log_diff_exp(
                       student_t_lcdf(bounds[(2 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)],
                         prior_parameters[(3 - 1)]),
                       student_t_lcdf(bounds[(1 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)],
                         prior_parameters[(3 - 1)])));
            } else {
              current_statement__ = 153;
              if (logical_neq(bounds_type[(1 - 1)], 0)) {
                current_statement__ = 151;
                ll = (ll -
                       student_t_lccdf(bounds[(1 - 1)],
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)],
                         prior_parameters[(3 - 1)]));
              } else {
                current_statement__ = 150;
                if (logical_neq(bounds_type[(2 - 1)], 0)) {
                  current_statement__ = 148;
                  ll = (ll -
                         student_t_lcdf(bounds[(2 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)],
                           prior_parameters[(3 - 1)]));
                } 
              }
            }
          } else {
            current_statement__ = 146;
            if (logical_eq(prior_type, 5)) {
              current_statement__ = 135;
              ll = gamma_lpdf<false>(parameter, prior_parameters[(1 - 1)],
                     prior_parameters[(2 - 1)]);
              current_statement__ = 144;
              if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
                  primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
                current_statement__ = 142;
                ll = (ll -
                       log_diff_exp(
                         gamma_lcdf(bounds[(2 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)]),
                         gamma_lcdf(bounds[(1 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)])));
              } else {
                current_statement__ = 141;
                if (logical_neq(bounds_type[(1 - 1)], 0)) {
                  current_statement__ = 139;
                  ll = (ll -
                         gamma_lccdf(bounds[(1 - 1)],
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)]));
                } else {
                  current_statement__ = 138;
                  if (logical_neq(bounds_type[(2 - 1)], 0)) {
                    current_statement__ = 136;
                    ll = (ll -
                           gamma_lcdf(bounds[(2 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)]));
                  } 
                }
              }
            } else {
              current_statement__ = 134;
              if (logical_eq(prior_type, 6)) {
                current_statement__ = 123;
                ll = inv_gamma_lpdf<false>(parameter,
                       prior_parameters[(1 - 1)], prior_parameters[(2 - 1)]);
                current_statement__ = 132;
                if ((primitive_value(logical_neq(bounds_type[(1 - 1)], 0)) &&
                    primitive_value(logical_neq(bounds_type[(2 - 1)], 0)))) {
                  current_statement__ = 130;
                  ll = (ll -
                         log_diff_exp(
                           inv_gamma_lcdf(bounds[(2 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)]),
                           inv_gamma_lcdf(bounds[(1 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)])));
                } else {
                  current_statement__ = 129;
                  if (logical_neq(bounds_type[(1 - 1)], 0)) {
                    current_statement__ = 127;
                    ll = (ll -
                           inv_gamma_lccdf(bounds[(1 - 1)],
                             prior_parameters[(1 - 1)],
                             prior_parameters[(2 - 1)]));
                  } else {
                    current_statement__ = 126;
                    if (logical_neq(bounds_type[(2 - 1)], 0)) {
                      current_statement__ = 124;
                      ll = (ll -
                             inv_gamma_lcdf(bounds[(2 - 1)],
                               prior_parameters[(1 - 1)],
                               prior_parameters[(2 - 1)]));
                    } 
                  }
                }
              } else {
                current_statement__ = 122;
                if (logical_eq(prior_type, 7)) {
                  current_statement__ = 120;
                  ll = uniform_lpdf<false>(parameter,
                         prior_parameters[(1 - 1)],
                         prior_parameters[(2 - 1)]);
                } else {
                  current_statement__ = 119;
                  if (logical_eq(prior_type, 8)) {
                    current_statement__ = 108;
                    ll = beta_lpdf<false>(parameter,
                           prior_parameters[(1 - 1)],
                           prior_parameters[(2 - 1)]);
                    current_statement__ = 117;
                    if ((primitive_value(
                        logical_neq(bounds_type[(1 - 1)], 0)) &&
                        primitive_value(
                        logical_neq(bounds_type[(2 - 1)], 0)))) {
                      current_statement__ = 115;
                      ll = (ll -
                             log_diff_exp(
                               beta_lcdf(bounds[(2 - 1)],
                                 prior_parameters[(1 - 1)],
                                 prior_parameters[(2 - 1)]),
                               beta_lcdf(bounds[(1 - 1)],
                                 prior_parameters[(1 - 1)],
                                 prior_parameters[(2 - 1)])));
                    } else {
                      current_statement__ = 114;
                      if (logical_neq(bounds_type[(1 - 1)], 0)) {
                        current_statement__ = 112;
                        ll = (ll -
                               beta_lccdf(bounds[(1 - 1)],
                                 prior_parameters[(1 - 1)],
                                 prior_parameters[(2 - 1)]));
                      } else {
                        current_statement__ = 111;
                        if (logical_neq(bounds_type[(2 - 1)], 0)) {
                          current_statement__ = 109;
                          ll = (ll -
                                 beta_lcdf(bounds[(2 - 1)],
                                   prior_parameters[(1 - 1)],
                                   prior_parameters[(2 - 1)]));
                        } 
                      }
                    }
                  } else {
                    current_statement__ = 107;
                    if (logical_eq(prior_type, 9)) {
                      current_statement__ = 96;
                      ll = exponential_lpdf<false>(parameter,
                             prior_parameters[(1 - 1)]);
                      current_statement__ = 105;
                      if ((primitive_value(
                          logical_neq(bounds_type[(1 - 1)], 0)) &&
                          primitive_value(
                          logical_neq(bounds_type[(2 - 1)], 0)))) {
                        current_statement__ = 103;
                        ll = (ll -
                               log_diff_exp(
                                 exponential_lcdf(bounds[(2 - 1)],
                                   prior_parameters[(1 - 1)]),
                                 exponential_lcdf(bounds[(1 - 1)],
                                   prior_parameters[(1 - 1)])));
                      } else {
                        current_statement__ = 102;
                        if (logical_neq(bounds_type[(1 - 1)], 0)) {
                          current_statement__ = 100;
                          ll = (ll -
                                 exponential_lccdf(bounds[(1 - 1)],
                                   prior_parameters[(1 - 1)]));
                        } else {
                          current_statement__ = 99;
                          if (logical_neq(bounds_type[(2 - 1)], 0)) {
                            current_statement__ = 97;
                            ll = (ll -
                                   exponential_lcdf(bounds[(2 - 1)],
                                     prior_parameters[(1 - 1)]));
                          } 
                        }
                      }
                    } 
                  }
                }
              }
            }
          }
        }
      }
    }
    current_statement__ = 195;
    return ll;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct set_prior_functor__ {
template <typename T0__, typename T2__, typename T4__>
stan::promote_args_t<T0__, stan::value_type_t<T2__>,
stan::value_type_t<T4__>>
operator()(const T0__& parameter, const int& prior_type,
           const T2__& prior_parameters, const std::vector<int>& bounds_type,
           const T4__& bounds, std::ostream* pstream__)  const 
{
return set_prior(parameter, prior_type, prior_parameters, bounds_type,
         bounds, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_lognormal final : public model_base_crtp<model_lognormal> {
private:
  int is_ss;
  int N1;
  int N2;
  Eigen::Matrix<double, -1, 1> x1;
  Eigen::Matrix<double, -1, 1> x2;
  Eigen::Matrix<double, -1, 1> mean_i;
  Eigen::Matrix<double, -1, 1> sd_i;
  int is_d;
  int is_r;
  Eigen::Matrix<double, -1, 1> bounds_d;
  Eigen::Matrix<double, -1, 1> bounds_r;
  std::vector<int> bounds_type_d;
  std::vector<int> bounds_type_r;
  Eigen::Matrix<double, -1, 1> fixed_d;
  Eigen::Matrix<double, -1, 1> fixed_r;
  Eigen::Matrix<double, -1, 1> prior_parameters_d;
  Eigen::Matrix<double, -1, 1> prior_parameters_r;
  int prior_type_d;
  int prior_type_r;
 
public:
  ~model_lognormal() { }
  
  inline std::string model_name() const final { return "model_lognormal"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_lognormal(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_lognormal_namespace::model_lognormal";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 44;
      context__.validate_dims("data initialization","is_ss","int",
          context__.to_vec());
      is_ss = std::numeric_limits<int>::min();
      
      current_statement__ = 44;
      is_ss = context__.vals_i("is_ss")[(1 - 1)];
      current_statement__ = 45;
      context__.validate_dims("data initialization","N1","int",
          context__.to_vec());
      N1 = std::numeric_limits<int>::min();
      
      current_statement__ = 45;
      N1 = context__.vals_i("N1")[(1 - 1)];
      current_statement__ = 45;
      current_statement__ = 45;
      check_greater_or_equal(function__, "N1", N1, 0);
      current_statement__ = 46;
      context__.validate_dims("data initialization","N2","int",
          context__.to_vec());
      N2 = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      N2 = context__.vals_i("N2")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "N2", N2, 0);
      current_statement__ = 47;
      validate_non_negative_index("x1", "is_ss == 0 ? N1 : 0",
                                  (logical_eq(is_ss, 0) ? N1 : 0));
      current_statement__ = 48;
      context__.validate_dims("data initialization","x1","double",
          context__.to_vec((logical_eq(is_ss, 0) ? N1 : 0)));
      x1 = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 0) ? N1 : 0));
      stan::math::fill(x1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> x1_flat__;
        current_statement__ = 48;
        assign(x1_flat__, nil_index_list(), context__.vals_r("x1"),
          "assigning variable x1_flat__");
        current_statement__ = 48;
        pos__ = 1;
        current_statement__ = 48;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 0) ? N1 : 0);
             ++sym1__) {
          current_statement__ = 48;
          assign(x1, cons_list(index_uni(sym1__), nil_index_list()),
            x1_flat__[(pos__ - 1)], "assigning variable x1");
          current_statement__ = 48;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 49;
      validate_non_negative_index("x2", "is_ss == 0 ? N2 : 0",
                                  (logical_eq(is_ss, 0) ? N2 : 0));
      current_statement__ = 50;
      context__.validate_dims("data initialization","x2","double",
          context__.to_vec((logical_eq(is_ss, 0) ? N2 : 0)));
      x2 = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 0) ? N2 : 0));
      stan::math::fill(x2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> x2_flat__;
        current_statement__ = 50;
        assign(x2_flat__, nil_index_list(), context__.vals_r("x2"),
          "assigning variable x2_flat__");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 0) ? N2 : 0);
             ++sym1__) {
          current_statement__ = 50;
          assign(x2, cons_list(index_uni(sym1__), nil_index_list()),
            x2_flat__[(pos__ - 1)], "assigning variable x2");
          current_statement__ = 50;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 51;
      validate_non_negative_index("mean_i", "is_ss == 1 ? 2 : 0",
                                  (logical_eq(is_ss, 1) ? 2 : 0));
      current_statement__ = 52;
      context__.validate_dims("data initialization","mean_i","double",
          context__.to_vec((logical_eq(is_ss, 1) ? 2 : 0)));
      mean_i = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 1) ? 2 : 0));
      stan::math::fill(mean_i, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mean_i_flat__;
        current_statement__ = 52;
        assign(mean_i_flat__, nil_index_list(), context__.vals_r("mean_i"),
          "assigning variable mean_i_flat__");
        current_statement__ = 52;
        pos__ = 1;
        current_statement__ = 52;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 52;
          assign(mean_i, cons_list(index_uni(sym1__), nil_index_list()),
            mean_i_flat__[(pos__ - 1)], "assigning variable mean_i");
          current_statement__ = 52;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 53;
      validate_non_negative_index("sd_i", "is_ss == 1 ? 2 : 0",
                                  (logical_eq(is_ss, 1) ? 2 : 0));
      current_statement__ = 54;
      context__.validate_dims("data initialization","sd_i","double",
          context__.to_vec((logical_eq(is_ss, 1) ? 2 : 0)));
      sd_i = Eigen::Matrix<double, -1, 1>((logical_eq(is_ss, 1) ? 2 : 0));
      stan::math::fill(sd_i, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sd_i_flat__;
        current_statement__ = 54;
        assign(sd_i_flat__, nil_index_list(), context__.vals_r("sd_i"),
          "assigning variable sd_i_flat__");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_ss, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 54;
          assign(sd_i, cons_list(index_uni(sym1__), nil_index_list()),
            sd_i_flat__[(pos__ - 1)], "assigning variable sd_i");
          current_statement__ = 54;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 55;
      context__.validate_dims("data initialization","is_d","int",
          context__.to_vec());
      is_d = std::numeric_limits<int>::min();
      
      current_statement__ = 55;
      is_d = context__.vals_i("is_d")[(1 - 1)];
      current_statement__ = 56;
      context__.validate_dims("data initialization","is_r","int",
          context__.to_vec());
      is_r = std::numeric_limits<int>::min();
      
      current_statement__ = 56;
      is_r = context__.vals_i("is_r")[(1 - 1)];
      current_statement__ = 57;
      validate_non_negative_index("bounds_d", "is_d == 1 ? 2 : 0",
                                  (logical_eq(is_d, 1) ? 2 : 0));
      current_statement__ = 58;
      context__.validate_dims("data initialization","bounds_d","double",
          context__.to_vec((logical_eq(is_d, 1) ? 2 : 0)));
      bounds_d = Eigen::Matrix<double, -1, 1>((logical_eq(is_d, 1) ? 2 : 0));
      stan::math::fill(bounds_d, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bounds_d_flat__;
        current_statement__ = 58;
        assign(bounds_d_flat__, nil_index_list(),
          context__.vals_r("bounds_d"), "assigning variable bounds_d_flat__");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_d, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 58;
          assign(bounds_d, cons_list(index_uni(sym1__), nil_index_list()),
            bounds_d_flat__[(pos__ - 1)], "assigning variable bounds_d");
          current_statement__ = 58;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 59;
      validate_non_negative_index("bounds_r", "is_r == 1 ? 2 : 0",
                                  (logical_eq(is_r, 1) ? 2 : 0));
      current_statement__ = 60;
      context__.validate_dims("data initialization","bounds_r","double",
          context__.to_vec((logical_eq(is_r, 1) ? 2 : 0)));
      bounds_r = Eigen::Matrix<double, -1, 1>((logical_eq(is_r, 1) ? 2 : 0));
      stan::math::fill(bounds_r, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bounds_r_flat__;
        current_statement__ = 60;
        assign(bounds_r_flat__, nil_index_list(),
          context__.vals_r("bounds_r"), "assigning variable bounds_r_flat__");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_r, 1) ? 2 : 0);
             ++sym1__) {
          current_statement__ = 60;
          assign(bounds_r, cons_list(index_uni(sym1__), nil_index_list()),
            bounds_r_flat__[(pos__ - 1)], "assigning variable bounds_r");
          current_statement__ = 60;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 61;
      validate_non_negative_index("bounds_type_d", "is_d == 1 ? 2 : 0",
                                  (logical_eq(is_d, 1) ? 2 : 0));
      current_statement__ = 62;
      context__.validate_dims("data initialization","bounds_type_d","int",
          context__.to_vec((logical_eq(is_d, 1) ? 2 : 0)));
      bounds_type_d = std::vector<int>((logical_eq(is_d, 1) ? 2 : 0), std::numeric_limits<int>::min());
      
      current_statement__ = 62;
      assign(bounds_type_d, nil_index_list(),
        context__.vals_i("bounds_type_d"), "assigning variable bounds_type_d");
      current_statement__ = 63;
      validate_non_negative_index("bounds_type_r", "is_r == 1 ? 2 : 0",
                                  (logical_eq(is_r, 1) ? 2 : 0));
      current_statement__ = 64;
      context__.validate_dims("data initialization","bounds_type_r","int",
          context__.to_vec((logical_eq(is_r, 1) ? 2 : 0)));
      bounds_type_r = std::vector<int>((logical_eq(is_r, 1) ? 2 : 0), std::numeric_limits<int>::min());
      
      current_statement__ = 64;
      assign(bounds_type_r, nil_index_list(),
        context__.vals_i("bounds_type_r"), "assigning variable bounds_type_r");
      current_statement__ = 65;
      validate_non_negative_index("fixed_d", "is_d == 0 ? 1 : 0",
                                  (logical_eq(is_d, 0) ? 1 : 0));
      current_statement__ = 66;
      context__.validate_dims("data initialization","fixed_d","double",
          context__.to_vec((logical_eq(is_d, 0) ? 1 : 0)));
      fixed_d = Eigen::Matrix<double, -1, 1>((logical_eq(is_d, 0) ? 1 : 0));
      stan::math::fill(fixed_d, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> fixed_d_flat__;
        current_statement__ = 66;
        assign(fixed_d_flat__, nil_index_list(), context__.vals_r("fixed_d"),
          "assigning variable fixed_d_flat__");
        current_statement__ = 66;
        pos__ = 1;
        current_statement__ = 66;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_d, 0) ? 1 : 0);
             ++sym1__) {
          current_statement__ = 66;
          assign(fixed_d, cons_list(index_uni(sym1__), nil_index_list()),
            fixed_d_flat__[(pos__ - 1)], "assigning variable fixed_d");
          current_statement__ = 66;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 67;
      validate_non_negative_index("fixed_r", "is_r == 0 ? 1 : 0",
                                  (logical_eq(is_r, 0) ? 1 : 0));
      current_statement__ = 68;
      context__.validate_dims("data initialization","fixed_r","double",
          context__.to_vec((logical_eq(is_r, 0) ? 1 : 0)));
      fixed_r = Eigen::Matrix<double, -1, 1>((logical_eq(is_r, 0) ? 1 : 0));
      stan::math::fill(fixed_r, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> fixed_r_flat__;
        current_statement__ = 68;
        assign(fixed_r_flat__, nil_index_list(), context__.vals_r("fixed_r"),
          "assigning variable fixed_r_flat__");
        current_statement__ = 68;
        pos__ = 1;
        current_statement__ = 68;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_r, 0) ? 1 : 0);
             ++sym1__) {
          current_statement__ = 68;
          assign(fixed_r, cons_list(index_uni(sym1__), nil_index_list()),
            fixed_r_flat__[(pos__ - 1)], "assigning variable fixed_r");
          current_statement__ = 68;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 69;
      validate_non_negative_index("prior_parameters_d", "is_d == 1 ? 3 : 0",
                                  (logical_eq(is_d, 1) ? 3 : 0));
      current_statement__ = 70;
      context__.validate_dims("data initialization","prior_parameters_d",
          "double",context__.to_vec((logical_eq(is_d, 1) ? 3 : 0)));
      prior_parameters_d = Eigen::Matrix<double, -1, 1>((logical_eq(is_d, 1)
                                                           ? 3 : 0));
      stan::math::fill(prior_parameters_d, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_parameters_d_flat__;
        current_statement__ = 70;
        assign(prior_parameters_d_flat__, nil_index_list(),
          context__.vals_r("prior_parameters_d"),
          "assigning variable prior_parameters_d_flat__");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_d, 1) ? 3 : 0);
             ++sym1__) {
          current_statement__ = 70;
          assign(prior_parameters_d,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_parameters_d_flat__[(pos__ - 1)],
            "assigning variable prior_parameters_d");
          current_statement__ = 70;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 71;
      validate_non_negative_index("prior_parameters_r", "is_r == 1 ? 3 : 0",
                                  (logical_eq(is_r, 1) ? 3 : 0));
      current_statement__ = 72;
      context__.validate_dims("data initialization","prior_parameters_r",
          "double",context__.to_vec((logical_eq(is_r, 1) ? 3 : 0)));
      prior_parameters_r = Eigen::Matrix<double, -1, 1>((logical_eq(is_r, 1)
                                                           ? 3 : 0));
      stan::math::fill(prior_parameters_r, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_parameters_r_flat__;
        current_statement__ = 72;
        assign(prior_parameters_r_flat__, nil_index_list(),
          context__.vals_r("prior_parameters_r"),
          "assigning variable prior_parameters_r_flat__");
        current_statement__ = 72;
        pos__ = 1;
        current_statement__ = 72;
        for (int sym1__ = 1; sym1__ <= (logical_eq(is_r, 1) ? 3 : 0);
             ++sym1__) {
          current_statement__ = 72;
          assign(prior_parameters_r,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_parameters_r_flat__[(pos__ - 1)],
            "assigning variable prior_parameters_r");
          current_statement__ = 72;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 73;
      context__.validate_dims("data initialization","prior_type_d","int",
          context__.to_vec());
      prior_type_d = std::numeric_limits<int>::min();
      
      current_statement__ = 73;
      prior_type_d = context__.vals_i("prior_type_d")[(1 - 1)];
      current_statement__ = 74;
      context__.validate_dims("data initialization","prior_type_r","int",
          context__.to_vec());
      prior_type_r = std::numeric_limits<int>::min();
      
      current_statement__ = 74;
      prior_type_r = context__.vals_i("prior_type_r")[(1 - 1)];
      current_statement__ = 75;
      validate_non_negative_index("delta", "is_d", is_d);
      current_statement__ = 76;
      validate_non_negative_index("rho", "is_r", is_r);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += is_d;
      num_params_r__ += is_r;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_lognormal_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ mu;
      mu = DUMMY_VAR__;
      
      current_statement__ = 1;
      mu = in__.scalar();
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        mu = stan::math::lb_constrain(mu, 0, lp__);
      } else {
        current_statement__ = 1;
        mu = stan::math::lb_constrain(mu, 0);
      }
      local_scalar_t__ sigma2;
      sigma2 = DUMMY_VAR__;
      
      current_statement__ = 2;
      sigma2 = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        sigma2 = stan::math::lb_constrain(sigma2, 0, lp__);
      } else {
        current_statement__ = 2;
        sigma2 = stan::math::lb_constrain(sigma2, 0);
      }
      std::vector<local_scalar_t__> delta;
      delta = std::vector<local_scalar_t__>(is_d, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delta");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(delta[(sym1__ - 1)],
              coefs_lb(bounds_type_d[(1 - 1)], bounds_d[(1 - 1)], pstream__),
              coefs_ub(bounds_type_d[(2 - 1)], bounds_d[(2 - 1)], pstream__),
              lp__), "assigning variable delta");
        } else {
          current_statement__ = 3;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(delta[(sym1__ - 1)],
              coefs_lb(bounds_type_d[(1 - 1)], bounds_d[(1 - 1)], pstream__),
              coefs_ub(bounds_type_d[(2 - 1)], bounds_d[(2 - 1)], pstream__)),
            "assigning variable delta");
        }}
      std::vector<local_scalar_t__> rho;
      rho = std::vector<local_scalar_t__>(is_r, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable rho");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rho[(sym1__ - 1)],
              coefs_lb(bounds_type_r[(1 - 1)], bounds_r[(1 - 1)], pstream__),
              coefs_ub(bounds_type_r[(2 - 1)], bounds_r[(2 - 1)], pstream__),
              lp__), "assigning variable rho");
        } else {
          current_statement__ = 4;
          assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(rho[(sym1__ - 1)],
              coefs_lb(bounds_type_r[(1 - 1)], bounds_r[(1 - 1)], pstream__),
              coefs_ub(bounds_type_r[(2 - 1)], bounds_r[(2 - 1)], pstream__)),
            "assigning variable rho");
        }}
      local_scalar_t__ pooled_sigma;
      pooled_sigma = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> mu_i;
      mu_i = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
      stan::math::fill(mu_i, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma_i;
      sigma_i = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
      stan::math::fill(sigma_i, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> mu_log_i;
      mu_log_i = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
      stan::math::fill(mu_log_i, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma_log_i;
      sigma_log_i = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
      stan::math::fill(sigma_log_i, DUMMY_VAR__);
      
      current_statement__ = 18;
      if (logical_eq(is_r, 1)) {
        current_statement__ = 14;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * rho[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 15;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - rho[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 16;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      } else {
        current_statement__ = 10;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * fixed_r[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 11;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt(
            (1 / (((2 * 1) / sigma2) * (1 - fixed_r[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 12;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      }
      current_statement__ = 25;
      if (logical_eq(is_d, 1)) {
        current_statement__ = 22;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 23;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      } else {
        current_statement__ = 19;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 20;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      }
      current_statement__ = 29;
      for (int i = 1; i <= 2; ++i) {
        current_statement__ = 26;
        assign(mu_log_i, cons_list(index_uni(i), nil_index_list()),
          (stan::math::log(mu_i[(i - 1)]) -
            (stan::math::log(
               (-(-pow(mu_i[(i - 1)], 2) - pow(sigma_i[(i - 1)], 2)) /
                 pow(mu_i[(i - 1)], 2))) / 2)), "assigning variable mu_log_i");
        current_statement__ = 27;
        assign(sigma_log_i, cons_list(index_uni(i), nil_index_list()),
          stan::math::sqrt(
            stan::math::log(
              (-(-pow(mu_i[(i - 1)], 2) - pow(sigma_i[(i - 1)], 2)) /
                pow(mu_i[(i - 1)], 2)))), "assigning variable sigma_log_i");}
      {
        current_statement__ = 30;
        lp_accum__.add(Jeffreys_mu_lpdf<false>(mu, pstream__));
        current_statement__ = 31;
        lp_accum__.add(Jeffreys_sigma_lpdf<false>(sigma2, pstream__));
        current_statement__ = 34;
        if (logical_eq(is_d, 1)) {
          current_statement__ = 32;
          lp_accum__.add(
            set_prior(delta[(1 - 1)], prior_type_d, prior_parameters_d,
              bounds_type_d, bounds_d, pstream__));
        } 
        current_statement__ = 37;
        if (logical_eq(is_r, 1)) {
          current_statement__ = 35;
          lp_accum__.add(
            set_prior(rho[(1 - 1)], prior_type_r, prior_parameters_r,
              bounds_type_r, bounds_r, pstream__));
        } 
        current_statement__ = 43;
        if (logical_eq(is_ss, 0)) {
          current_statement__ = 40;
          lp_accum__.add(
            lognormal_lpdf<false>(x1, mu_log_i[(1 - 1)],
              sigma_log_i[(1 - 1)]));
          current_statement__ = 41;
          lp_accum__.add(
            lognormal_lpdf<false>(x2, mu_log_i[(2 - 1)],
              sigma_log_i[(2 - 1)]));
        } else {
          current_statement__ = 38;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "Fitting models with t likelihood and summary statistics is not possible :(.";
          throw std::domain_error(errmsg_stream__.str());
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_lognormal_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double mu;
      mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      mu = in__.scalar();
      current_statement__ = 1;
      mu = stan::math::lb_constrain(mu, 0);
      double sigma2;
      sigma2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma2 = in__.scalar();
      current_statement__ = 2;
      sigma2 = stan::math::lb_constrain(sigma2, 0);
      std::vector<double> delta;
      delta = std::vector<double>(is_d, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable delta");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(delta[(sym1__ - 1)],
            coefs_lb(bounds_type_d[(1 - 1)], bounds_d[(1 - 1)], pstream__),
            coefs_ub(bounds_type_d[(2 - 1)], bounds_d[(2 - 1)], pstream__)),
          "assigning variable delta");}
      std::vector<double> rho;
      rho = std::vector<double>(is_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable rho");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(rho[(sym1__ - 1)],
            coefs_lb(bounds_type_r[(1 - 1)], bounds_r[(1 - 1)], pstream__),
            coefs_ub(bounds_type_r[(2 - 1)], bounds_r[(2 - 1)], pstream__)),
          "assigning variable rho");}
      double pooled_sigma;
      pooled_sigma = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> mu_i;
      mu_i = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(mu_i, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> sigma_i;
      sigma_i = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(sigma_i, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> mu_log_i;
      mu_log_i = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(mu_log_i, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> sigma_log_i;
      sigma_log_i = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(sigma_log_i, std::numeric_limits<double>::quiet_NaN());
      
      vars__.emplace_back(mu);
      vars__.emplace_back(sigma2);
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        vars__.emplace_back(rho[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 18;
      if (logical_eq(is_r, 1)) {
        current_statement__ = 14;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * rho[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 15;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - rho[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 16;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      } else {
        current_statement__ = 10;
        assign(sigma_i, cons_list(index_uni(1), nil_index_list()),
          stan::math::sqrt((1 / (((2 * 1) / sigma2) * fixed_r[(1 - 1)]))),
          "assigning variable sigma_i");
        current_statement__ = 11;
        assign(sigma_i, cons_list(index_uni(2), nil_index_list()),
          stan::math::sqrt(
            (1 / (((2 * 1) / sigma2) * (1 - fixed_r[(1 - 1)])))),
          "assigning variable sigma_i");
        current_statement__ = 12;
        pooled_sigma = pool_sigma(sigma_i[(1 - 1)], sigma_i[(2 - 1)], N1,
                         N2, pstream__);
      }
      current_statement__ = 25;
      if (logical_eq(is_d, 1)) {
        current_statement__ = 22;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 23;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * delta[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      } else {
        current_statement__ = 19;
        assign(mu_i, cons_list(index_uni(1), nil_index_list()),
          (mu - ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
        current_statement__ = 20;
        assign(mu_i, cons_list(index_uni(2), nil_index_list()),
          (mu + ((0.5 * fixed_d[(1 - 1)]) * pooled_sigma)),
          "assigning variable mu_i");
      }
      current_statement__ = 29;
      for (int i = 1; i <= 2; ++i) {
        current_statement__ = 26;
        assign(mu_log_i, cons_list(index_uni(i), nil_index_list()),
          (stan::math::log(mu_i[(i - 1)]) -
            (stan::math::log(
               (-(-pow(mu_i[(i - 1)], 2) - pow(sigma_i[(i - 1)], 2)) /
                 pow(mu_i[(i - 1)], 2))) / 2)), "assigning variable mu_log_i");
        current_statement__ = 27;
        assign(sigma_log_i, cons_list(index_uni(i), nil_index_list()),
          stan::math::sqrt(
            stan::math::log(
              (-(-pow(mu_i[(i - 1)], 2) - pow(sigma_i[(i - 1)], 2)) /
                pow(mu_i[(i - 1)], 2)))), "assigning variable sigma_log_i");}
      if (emit_transformed_parameters__) {
        vars__.emplace_back(pooled_sigma);
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(mu_i[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(sigma_i[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(mu_log_i[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(sigma_log_i[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double mu;
      mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      mu = context__.vals_r("mu")[(1 - 1)];
      double mu_free__;
      mu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      mu_free__ = stan::math::lb_free(mu, 0);
      double sigma2;
      sigma2 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma2 = context__.vals_r("sigma2")[(1 - 1)];
      double sigma2_free__;
      sigma2_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma2_free__ = stan::math::lb_free(sigma2, 0);
      std::vector<double> delta;
      delta = std::vector<double>(is_d, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(delta, nil_index_list(), context__.vals_r("delta"),
        "assigning variable delta");
      std::vector<double> delta_free__;
      delta_free__ = std::vector<double>(is_d, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        current_statement__ = 3;
        assign(delta_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(delta[(sym1__ - 1)],
            coefs_lb(bounds_type_d[(1 - 1)], bounds_d[(1 - 1)], pstream__),
            coefs_ub(bounds_type_d[(2 - 1)], bounds_d[(2 - 1)], pstream__)),
          "assigning variable delta_free__");}
      std::vector<double> rho;
      rho = std::vector<double>(is_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(rho, nil_index_list(), context__.vals_r("rho"),
        "assigning variable rho");
      std::vector<double> rho_free__;
      rho_free__ = std::vector<double>(is_r, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        current_statement__ = 4;
        assign(rho_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(rho[(sym1__ - 1)],
            coefs_lb(bounds_type_r[(1 - 1)], bounds_r[(1 - 1)], pstream__),
            coefs_ub(bounds_type_r[(2 - 1)], bounds_r[(2 - 1)], pstream__)),
          "assigning variable rho_free__");}
      vars__.emplace_back(mu_free__);
      vars__.emplace_back(sigma2_free__);
      for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
        vars__.emplace_back(delta_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
        vars__.emplace_back(rho_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("mu");
    names__.emplace_back("sigma2");
    names__.emplace_back("delta");
    names__.emplace_back("rho");
    names__.emplace_back("pooled_sigma");
    names__.emplace_back("mu_i");
    names__.emplace_back("sigma_i");
    names__.emplace_back("mu_log_i");
    names__.emplace_back("sigma_log_i");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(is_d)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(is_r)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma2");
    for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rho" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "pooled_sigma");
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu_log_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma_log_i" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma2");
    for (int sym1__ = 1; sym1__ <= is_d; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= is_r; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "rho" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "pooled_sigma");
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu_log_i" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sigma_log_i" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"array\",\"length\":" << is_d << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"array\",\"length\":" << is_r << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"pooled_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"mu_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_log_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_log_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"array\",\"length\":" << is_d << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"array\",\"length\":" << is_r << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"pooled_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"mu_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_log_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma_log_i\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_lognormal_namespace::model_lognormal;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_lognormal_namespace::profiles__;
}
#endif
#endif
