/*
    RoBTT is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    RoBTT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RoBTT.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0

#include <stan/model/model_header.hpp>

namespace model_normal_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_normal");
    reader.add_event(0, 0, "include", "/chunks/common_functions.stan");
    reader.add_event(0, 0, "start", "/chunks/common_functions.stan");
    reader.add_event(148, 148, "end", "/chunks/common_functions.stan");
    reader.add_event(148, 1, "restart", "model_normal");
    reader.add_event(234, 85, "end", "model_normal");
    return reader;
}

template <bool propto, typename T0__>
typename boost::math::tools::promote_args<T0__>::type
Jeffreys_mu_lpdf(const T0__& mu, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        current_statement_begin__ = 5;
        return stan::math::promote_scalar<fun_return_scalar_t__>(0);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
Jeffreys_mu_lpdf(const T0__& mu, std::ostream* pstream__) {
    return Jeffreys_mu_lpdf<false>(mu, pstream__);
}


struct Jeffreys_mu_lpdf_functor__ {
    template <bool propto, typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& mu, std::ostream* pstream__) const {
        return Jeffreys_mu_lpdf(mu, pstream__);
    }
};

template <bool propto, typename T0__>
typename boost::math::tools::promote_args<T0__>::type
Jeffreys_sigma_lpdf(const T0__& sigma2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        current_statement_begin__ = 8;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::log((1 / sigma2)));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
Jeffreys_sigma_lpdf(const T0__& sigma2, std::ostream* pstream__) {
    return Jeffreys_sigma_lpdf<false>(sigma2, pstream__);
}


struct Jeffreys_sigma_lpdf_functor__ {
    template <bool propto, typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& sigma2, std::ostream* pstream__) const {
        return Jeffreys_sigma_lpdf(sigma2, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
pool_sigma(const T0__& sigma1,
               const T1__& sigma2,
               const T2__& N1,
               const T3__& N2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        current_statement_begin__ = 13;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::sqrt((((pow(sigma1, 2) * N1) + (pow(sigma2, 2) * N2)) / (N1 + N2))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct pool_sigma_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
    operator()(const T0__& sigma1,
               const T1__& sigma2,
               const T2__& N1,
               const T3__& N2, std::ostream* pstream__) const {
        return pool_sigma(sigma1, sigma2, N1, N2, pstream__);
    }
};

template <typename T1__>
typename boost::math::tools::promote_args<T1__>::type
coefs_lb(const int& type,
             const T1__& bound, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 18;
        local_scalar_t__ lb(DUMMY_VAR__);
        (void) lb;  // dummy to suppress unused var warning
        stan::math::initialize(lb, DUMMY_VAR__);
        stan::math::fill(lb, DUMMY_VAR__);


        current_statement_begin__ = 19;
        if (as_bool(logical_eq(type, 0))) {
            current_statement_begin__ = 20;
            stan::math::assign(lb, stan::math::negative_infinity());
        } else {
            current_statement_begin__ = 22;
            stan::math::assign(lb, bound);
        }
        current_statement_begin__ = 23;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lb);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct coefs_lb_functor__ {
    template <typename T1__>
        typename boost::math::tools::promote_args<T1__>::type
    operator()(const int& type,
             const T1__& bound, std::ostream* pstream__) const {
        return coefs_lb(type, bound, pstream__);
    }
};

template <typename T1__>
typename boost::math::tools::promote_args<T1__>::type
coefs_ub(const int& type,
             const T1__& bound, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 26;
        local_scalar_t__ lb(DUMMY_VAR__);
        (void) lb;  // dummy to suppress unused var warning
        stan::math::initialize(lb, DUMMY_VAR__);
        stan::math::fill(lb, DUMMY_VAR__);


        current_statement_begin__ = 27;
        if (as_bool(logical_eq(type, 0))) {
            current_statement_begin__ = 28;
            stan::math::assign(lb, stan::math::positive_infinity());
        } else {
            current_statement_begin__ = 30;
            stan::math::assign(lb, bound);
        }
        current_statement_begin__ = 31;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lb);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct coefs_ub_functor__ {
    template <typename T1__>
        typename boost::math::tools::promote_args<T1__>::type
    operator()(const int& type,
             const T1__& bound, std::ostream* pstream__) const {
        return coefs_ub(type, bound, pstream__);
    }
};

template <typename T0__, typename T2__, typename T4__>
typename boost::math::tools::promote_args<T0__, T2__, T4__>::type
set_prior(const T0__& parameter,
              const int& prior_type,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& prior_parameters,
              const std::vector<int>& bounds_type,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& bounds, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 44;
        local_scalar_t__ ll(DUMMY_VAR__);
        (void) ll;  // dummy to suppress unused var warning
        stan::math::initialize(ll, DUMMY_VAR__);
        stan::math::fill(ll, DUMMY_VAR__);


        current_statement_begin__ = 46;
        if (as_bool(logical_eq(prior_type, 1))) {

            current_statement_begin__ = 47;
            stan::math::assign(ll, normal_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
            current_statement_begin__ = 48;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 49;
                stan::math::assign(ll, (ll - log_diff_exp(normal_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)), normal_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 54;
                stan::math::assign(ll, (ll - normal_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 56;
                stan::math::assign(ll, (ll - normal_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 2))) {

            current_statement_begin__ = 59;
            stan::math::assign(ll, lognormal_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
            current_statement_begin__ = 60;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 61;
                stan::math::assign(ll, (ll - log_diff_exp(lognormal_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)), lognormal_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 66;
                stan::math::assign(ll, (ll - lognormal_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 68;
                stan::math::assign(ll, (ll - lognormal_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 3))) {

            current_statement_begin__ = 71;
            stan::math::assign(ll, cauchy_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
            current_statement_begin__ = 72;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 73;
                stan::math::assign(ll, (ll - log_diff_exp(cauchy_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)), cauchy_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 78;
                stan::math::assign(ll, (ll - cauchy_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 80;
                stan::math::assign(ll, (ll - cauchy_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 4))) {

            current_statement_begin__ = 83;
            stan::math::assign(ll, student_t_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1), get_base1(prior_parameters, 3, "prior_parameters", 1)));
            current_statement_begin__ = 84;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 85;
                stan::math::assign(ll, (ll - log_diff_exp(student_t_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1), get_base1(prior_parameters, 3, "prior_parameters", 1)), student_t_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1), get_base1(prior_parameters, 3, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 90;
                stan::math::assign(ll, (ll - student_t_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1), get_base1(prior_parameters, 3, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 92;
                stan::math::assign(ll, (ll - student_t_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1), get_base1(prior_parameters, 3, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 5))) {

            current_statement_begin__ = 95;
            stan::math::assign(ll, gamma_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
            current_statement_begin__ = 96;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 97;
                stan::math::assign(ll, (ll - log_diff_exp(gamma_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)), gamma_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 102;
                stan::math::assign(ll, (ll - gamma_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 104;
                stan::math::assign(ll, (ll - gamma_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 6))) {

            current_statement_begin__ = 107;
            stan::math::assign(ll, inv_gamma_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
            current_statement_begin__ = 108;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 109;
                stan::math::assign(ll, (ll - log_diff_exp(inv_gamma_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)), inv_gamma_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 114;
                stan::math::assign(ll, (ll - inv_gamma_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 116;
                stan::math::assign(ll, (ll - inv_gamma_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 7))) {

            current_statement_begin__ = 119;
            stan::math::assign(ll, uniform_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
        } else if (as_bool(logical_eq(prior_type, 8))) {

            current_statement_begin__ = 121;
            stan::math::assign(ll, beta_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)));
            current_statement_begin__ = 122;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 123;
                stan::math::assign(ll, (ll - log_diff_exp(beta_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)), beta_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 128;
                stan::math::assign(ll, (ll - beta_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 130;
                stan::math::assign(ll, (ll - beta_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1), get_base1(prior_parameters, 2, "prior_parameters", 1))));
            }
        } else if (as_bool(logical_eq(prior_type, 9))) {

            current_statement_begin__ = 133;
            stan::math::assign(ll, exponential_log(parameter, get_base1(prior_parameters, 1, "prior_parameters", 1)));
            current_statement_begin__ = 134;
            if (as_bool((primitive_value(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0)) && primitive_value(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))))) {

                current_statement_begin__ = 135;
                stan::math::assign(ll, (ll - log_diff_exp(exponential_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1)), exponential_cdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1)))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 1, "bounds_type", 1), 0))) {

                current_statement_begin__ = 140;
                stan::math::assign(ll, (ll - exponential_ccdf_log(get_base1(bounds, 1, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1))));
            } else if (as_bool(logical_neq(get_base1(bounds_type, 2, "bounds_type", 1), 0))) {

                current_statement_begin__ = 142;
                stan::math::assign(ll, (ll - exponential_cdf_log(get_base1(bounds, 2, "bounds", 1), get_base1(prior_parameters, 1, "prior_parameters", 1))));
            }
        }
        current_statement_begin__ = 146;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ll);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct set_prior_functor__ {
    template <typename T0__, typename T2__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T2__, T4__>::type
    operator()(const T0__& parameter,
              const int& prior_type,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& prior_parameters,
              const std::vector<int>& bounds_type,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& bounds, std::ostream* pstream__) const {
        return set_prior(parameter, prior_type, prior_parameters, bounds_type, bounds, pstream__);
    }
};

class model_normal
  : public stan::model::model_base_crtp<model_normal> {
private:
        int is_ss;
        int N1;
        int N2;
        vector_d x1;
        vector_d x2;
        vector_d mean_i;
        vector_d sd_i;
        int is_d;
        int is_r;
        vector_d bounds_d;
        vector_d bounds_r;
        std::vector<int> bounds_type_d;
        std::vector<int> bounds_type_r;
        vector_d fixed_d;
        vector_d fixed_r;
        vector_d prior_parameters_d;
        vector_d prior_parameters_r;
        int prior_type_d;
        int prior_type_r;
public:
    model_normal(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_normal(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_normal_namespace::model_normal";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 153;
            context__.validate_dims("data initialization", "is_ss", "int", context__.to_vec());
            is_ss = int(0);
            vals_i__ = context__.vals_i("is_ss");
            pos__ = 0;
            is_ss = vals_i__[pos__++];

            current_statement_begin__ = 155;
            context__.validate_dims("data initialization", "N1", "int", context__.to_vec());
            N1 = int(0);
            vals_i__ = context__.vals_i("N1");
            pos__ = 0;
            N1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N1", N1, 0);

            current_statement_begin__ = 156;
            context__.validate_dims("data initialization", "N2", "int", context__.to_vec());
            N2 = int(0);
            vals_i__ = context__.vals_i("N2");
            pos__ = 0;
            N2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N2", N2, 0);

            current_statement_begin__ = 158;
            validate_non_negative_index("x1", "(logical_eq(is_ss, 0) ? N1 : 0 )", (logical_eq(is_ss, 0) ? N1 : 0 ));
            context__.validate_dims("data initialization", "x1", "vector_d", context__.to_vec((logical_eq(is_ss, 0) ? N1 : 0 )));
            x1 = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_ss, 0) ? N1 : 0 ));
            vals_r__ = context__.vals_r("x1");
            pos__ = 0;
            size_t x1_j_1_max__ = (logical_eq(is_ss, 0) ? N1 : 0 );
            for (size_t j_1__ = 0; j_1__ < x1_j_1_max__; ++j_1__) {
                x1(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 159;
            validate_non_negative_index("x2", "(logical_eq(is_ss, 0) ? N2 : 0 )", (logical_eq(is_ss, 0) ? N2 : 0 ));
            context__.validate_dims("data initialization", "x2", "vector_d", context__.to_vec((logical_eq(is_ss, 0) ? N2 : 0 )));
            x2 = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_ss, 0) ? N2 : 0 ));
            vals_r__ = context__.vals_r("x2");
            pos__ = 0;
            size_t x2_j_1_max__ = (logical_eq(is_ss, 0) ? N2 : 0 );
            for (size_t j_1__ = 0; j_1__ < x2_j_1_max__; ++j_1__) {
                x2(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 161;
            validate_non_negative_index("mean_i", "(logical_eq(is_ss, 1) ? 2 : 0 )", (logical_eq(is_ss, 1) ? 2 : 0 ));
            context__.validate_dims("data initialization", "mean_i", "vector_d", context__.to_vec((logical_eq(is_ss, 1) ? 2 : 0 )));
            mean_i = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_ss, 1) ? 2 : 0 ));
            vals_r__ = context__.vals_r("mean_i");
            pos__ = 0;
            size_t mean_i_j_1_max__ = (logical_eq(is_ss, 1) ? 2 : 0 );
            for (size_t j_1__ = 0; j_1__ < mean_i_j_1_max__; ++j_1__) {
                mean_i(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 162;
            validate_non_negative_index("sd_i", "(logical_eq(is_ss, 1) ? 2 : 0 )", (logical_eq(is_ss, 1) ? 2 : 0 ));
            context__.validate_dims("data initialization", "sd_i", "vector_d", context__.to_vec((logical_eq(is_ss, 1) ? 2 : 0 )));
            sd_i = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_ss, 1) ? 2 : 0 ));
            vals_r__ = context__.vals_r("sd_i");
            pos__ = 0;
            size_t sd_i_j_1_max__ = (logical_eq(is_ss, 1) ? 2 : 0 );
            for (size_t j_1__ = 0; j_1__ < sd_i_j_1_max__; ++j_1__) {
                sd_i(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 165;
            context__.validate_dims("data initialization", "is_d", "int", context__.to_vec());
            is_d = int(0);
            vals_i__ = context__.vals_i("is_d");
            pos__ = 0;
            is_d = vals_i__[pos__++];

            current_statement_begin__ = 166;
            context__.validate_dims("data initialization", "is_r", "int", context__.to_vec());
            is_r = int(0);
            vals_i__ = context__.vals_i("is_r");
            pos__ = 0;
            is_r = vals_i__[pos__++];

            current_statement_begin__ = 169;
            validate_non_negative_index("bounds_d", "(logical_eq(is_d, 1) ? 2 : 0 )", (logical_eq(is_d, 1) ? 2 : 0 ));
            context__.validate_dims("data initialization", "bounds_d", "vector_d", context__.to_vec((logical_eq(is_d, 1) ? 2 : 0 )));
            bounds_d = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_d, 1) ? 2 : 0 ));
            vals_r__ = context__.vals_r("bounds_d");
            pos__ = 0;
            size_t bounds_d_j_1_max__ = (logical_eq(is_d, 1) ? 2 : 0 );
            for (size_t j_1__ = 0; j_1__ < bounds_d_j_1_max__; ++j_1__) {
                bounds_d(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 170;
            validate_non_negative_index("bounds_r", "(logical_eq(is_r, 1) ? 2 : 0 )", (logical_eq(is_r, 1) ? 2 : 0 ));
            context__.validate_dims("data initialization", "bounds_r", "vector_d", context__.to_vec((logical_eq(is_r, 1) ? 2 : 0 )));
            bounds_r = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_r, 1) ? 2 : 0 ));
            vals_r__ = context__.vals_r("bounds_r");
            pos__ = 0;
            size_t bounds_r_j_1_max__ = (logical_eq(is_r, 1) ? 2 : 0 );
            for (size_t j_1__ = 0; j_1__ < bounds_r_j_1_max__; ++j_1__) {
                bounds_r(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 171;
            validate_non_negative_index("bounds_type_d", "(logical_eq(is_d, 1) ? 2 : 0 )", (logical_eq(is_d, 1) ? 2 : 0 ));
            context__.validate_dims("data initialization", "bounds_type_d", "int", context__.to_vec((logical_eq(is_d, 1) ? 2 : 0 )));
            bounds_type_d = std::vector<int>((logical_eq(is_d, 1) ? 2 : 0 ), int(0));
            vals_i__ = context__.vals_i("bounds_type_d");
            pos__ = 0;
            size_t bounds_type_d_k_0_max__ = (logical_eq(is_d, 1) ? 2 : 0 );
            for (size_t k_0__ = 0; k_0__ < bounds_type_d_k_0_max__; ++k_0__) {
                bounds_type_d[k_0__] = vals_i__[pos__++];
            }

            current_statement_begin__ = 172;
            validate_non_negative_index("bounds_type_r", "(logical_eq(is_r, 1) ? 2 : 0 )", (logical_eq(is_r, 1) ? 2 : 0 ));
            context__.validate_dims("data initialization", "bounds_type_r", "int", context__.to_vec((logical_eq(is_r, 1) ? 2 : 0 )));
            bounds_type_r = std::vector<int>((logical_eq(is_r, 1) ? 2 : 0 ), int(0));
            vals_i__ = context__.vals_i("bounds_type_r");
            pos__ = 0;
            size_t bounds_type_r_k_0_max__ = (logical_eq(is_r, 1) ? 2 : 0 );
            for (size_t k_0__ = 0; k_0__ < bounds_type_r_k_0_max__; ++k_0__) {
                bounds_type_r[k_0__] = vals_i__[pos__++];
            }

            current_statement_begin__ = 175;
            validate_non_negative_index("fixed_d", "(logical_eq(is_d, 0) ? 1 : 0 )", (logical_eq(is_d, 0) ? 1 : 0 ));
            context__.validate_dims("data initialization", "fixed_d", "vector_d", context__.to_vec((logical_eq(is_d, 0) ? 1 : 0 )));
            fixed_d = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_d, 0) ? 1 : 0 ));
            vals_r__ = context__.vals_r("fixed_d");
            pos__ = 0;
            size_t fixed_d_j_1_max__ = (logical_eq(is_d, 0) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < fixed_d_j_1_max__; ++j_1__) {
                fixed_d(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 176;
            validate_non_negative_index("fixed_r", "(logical_eq(is_r, 0) ? 1 : 0 )", (logical_eq(is_r, 0) ? 1 : 0 ));
            context__.validate_dims("data initialization", "fixed_r", "vector_d", context__.to_vec((logical_eq(is_r, 0) ? 1 : 0 )));
            fixed_r = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_r, 0) ? 1 : 0 ));
            vals_r__ = context__.vals_r("fixed_r");
            pos__ = 0;
            size_t fixed_r_j_1_max__ = (logical_eq(is_r, 0) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < fixed_r_j_1_max__; ++j_1__) {
                fixed_r(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 177;
            validate_non_negative_index("prior_parameters_d", "(logical_eq(is_d, 1) ? 3 : 0 )", (logical_eq(is_d, 1) ? 3 : 0 ));
            context__.validate_dims("data initialization", "prior_parameters_d", "vector_d", context__.to_vec((logical_eq(is_d, 1) ? 3 : 0 )));
            prior_parameters_d = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_d, 1) ? 3 : 0 ));
            vals_r__ = context__.vals_r("prior_parameters_d");
            pos__ = 0;
            size_t prior_parameters_d_j_1_max__ = (logical_eq(is_d, 1) ? 3 : 0 );
            for (size_t j_1__ = 0; j_1__ < prior_parameters_d_j_1_max__; ++j_1__) {
                prior_parameters_d(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 178;
            validate_non_negative_index("prior_parameters_r", "(logical_eq(is_r, 1) ? 3 : 0 )", (logical_eq(is_r, 1) ? 3 : 0 ));
            context__.validate_dims("data initialization", "prior_parameters_r", "vector_d", context__.to_vec((logical_eq(is_r, 1) ? 3 : 0 )));
            prior_parameters_r = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(is_r, 1) ? 3 : 0 ));
            vals_r__ = context__.vals_r("prior_parameters_r");
            pos__ = 0;
            size_t prior_parameters_r_j_1_max__ = (logical_eq(is_r, 1) ? 3 : 0 );
            for (size_t j_1__ = 0; j_1__ < prior_parameters_r_j_1_max__; ++j_1__) {
                prior_parameters_r(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 179;
            context__.validate_dims("data initialization", "prior_type_d", "int", context__.to_vec());
            prior_type_d = int(0);
            vals_i__ = context__.vals_i("prior_type_d");
            pos__ = 0;
            prior_type_d = vals_i__[pos__++];

            current_statement_begin__ = 180;
            context__.validate_dims("data initialization", "prior_type_r", "int", context__.to_vec());
            prior_type_r = int(0);
            vals_i__ = context__.vals_i("prior_type_r");
            pos__ = 0;
            prior_type_r = vals_i__[pos__++];


            // initialize transformed data variables
            // execute transformed data statements

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 183;
            num_params_r__ += 1;
            current_statement_begin__ = 184;
            num_params_r__ += 1;
            current_statement_begin__ = 185;
            validate_non_negative_index("delta", "is_d", is_d);
            num_params_r__ += (1 * is_d);
            current_statement_begin__ = 186;
            validate_non_negative_index("rho", "is_r", is_r);
            num_params_r__ += (1 * is_r);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_normal() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 183;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 184;
        if (!(context__.contains_r("sigma2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma2", "double", context__.to_vec());
        double sigma2(0);
        sigma2 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma2: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 185;
        if (!(context__.contains_r("delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "is_d", is_d);
        context__.validate_dims("parameter initialization", "delta", "double", context__.to_vec(is_d));
        std::vector<double> delta(is_d, double(0));
        size_t delta_k_0_max__ = is_d;
        for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
            delta[k_0__] = vals_r__[pos__++];
        }
        size_t delta_i_0_max__ = is_d;
        for (size_t i_0__ = 0; i_0__ < delta_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(coefs_lb(get_base1(bounds_type_d, 1, "bounds_type_d", 1), get_base1(bounds_d, 1, "bounds_d", 1), pstream__), coefs_ub(get_base1(bounds_type_d, 2, "bounds_type_d", 1), get_base1(bounds_d, 2, "bounds_d", 1), pstream__), delta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        current_statement_begin__ = 186;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "is_r", is_r);
        context__.validate_dims("parameter initialization", "rho", "double", context__.to_vec(is_r));
        std::vector<double> rho(is_r, double(0));
        size_t rho_k_0_max__ = is_r;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            rho[k_0__] = vals_r__[pos__++];
        }
        size_t rho_i_0_max__ = is_r;
        for (size_t i_0__ = 0; i_0__ < rho_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(coefs_lb(get_base1(bounds_type_r, 1, "bounds_type_r", 1), get_base1(bounds_r, 1, "bounds_r", 1), pstream__), coefs_ub(get_base1(bounds_type_r, 2, "bounds_type_r", 1), get_base1(bounds_r, 2, "bounds_r", 1), pstream__), rho[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 183;
            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_constrain(lp__);
            else
                mu = in__.scalar_constrain();

            current_statement_begin__ = 184;
            local_scalar_t__ sigma2;
            (void) sigma2;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma2 = in__.scalar_lb_constrain(0, lp__);
            else
                sigma2 = in__.scalar_lb_constrain(0);

            current_statement_begin__ = 185;
            std::vector<local_scalar_t__> delta;
            size_t delta_d_0_max__ = is_d;
            delta.reserve(delta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < delta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_lub_constrain(coefs_lb(get_base1(bounds_type_d, 1, "bounds_type_d", 1), get_base1(bounds_d, 1, "bounds_d", 1), pstream__), coefs_ub(get_base1(bounds_type_d, 2, "bounds_type_d", 1), get_base1(bounds_d, 2, "bounds_d", 1), pstream__), lp__));
                else
                    delta.push_back(in__.scalar_lub_constrain(coefs_lb(get_base1(bounds_type_d, 1, "bounds_type_d", 1), get_base1(bounds_d, 1, "bounds_d", 1), pstream__), coefs_ub(get_base1(bounds_type_d, 2, "bounds_type_d", 1), get_base1(bounds_d, 2, "bounds_d", 1), pstream__)));
            }

            current_statement_begin__ = 186;
            std::vector<local_scalar_t__> rho;
            size_t rho_d_0_max__ = is_r;
            rho.reserve(rho_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rho.push_back(in__.scalar_lub_constrain(coefs_lb(get_base1(bounds_type_r, 1, "bounds_type_r", 1), get_base1(bounds_r, 1, "bounds_r", 1), pstream__), coefs_ub(get_base1(bounds_type_r, 2, "bounds_type_r", 1), get_base1(bounds_r, 2, "bounds_r", 1), pstream__), lp__));
                else
                    rho.push_back(in__.scalar_lub_constrain(coefs_lb(get_base1(bounds_type_r, 1, "bounds_type_r", 1), get_base1(bounds_r, 1, "bounds_r", 1), pstream__), coefs_ub(get_base1(bounds_type_r, 2, "bounds_type_r", 1), get_base1(bounds_r, 2, "bounds_r", 1), pstream__)));
            }

            // transformed parameters
            current_statement_begin__ = 189;
            local_scalar_t__ pooled_sigma;
            (void) pooled_sigma;  // dummy to suppress unused var warning
            stan::math::initialize(pooled_sigma, DUMMY_VAR__);
            stan::math::fill(pooled_sigma, DUMMY_VAR__);

            current_statement_begin__ = 190;
            validate_non_negative_index("sigma_i", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_i(2);
            stan::math::initialize(sigma_i, DUMMY_VAR__);
            stan::math::fill(sigma_i, DUMMY_VAR__);

            current_statement_begin__ = 191;
            validate_non_negative_index("mu_i", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_i(2);
            stan::math::initialize(mu_i, DUMMY_VAR__);
            stan::math::fill(mu_i, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 194;
            if (as_bool(logical_eq(is_r, 1))) {

                current_statement_begin__ = 195;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * get_base1(rho, 1, "rho", 1)))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 196;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - get_base1(rho, 1, "rho", 1))))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 197;
                stan::math::assign(pooled_sigma, pool_sigma(get_base1(sigma_i, 1, "sigma_i", 1), get_base1(sigma_i, 2, "sigma_i", 1), N1, N2, pstream__));
            } else {

                current_statement_begin__ = 199;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * get_base1(fixed_r, 1, "fixed_r", 1)))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 200;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - get_base1(fixed_r, 1, "fixed_r", 1))))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 201;
                stan::math::assign(pooled_sigma, pool_sigma(get_base1(sigma_i, 1, "sigma_i", 1), get_base1(sigma_i, 2, "sigma_i", 1), N1, N2, pstream__));
            }
            current_statement_begin__ = 203;
            if (as_bool(logical_eq(is_d, 1))) {

                current_statement_begin__ = 204;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (mu - ((0.5 * get_base1(delta, 1, "delta", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
                current_statement_begin__ = 205;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            (mu + ((0.5 * get_base1(delta, 1, "delta", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
            } else {

                current_statement_begin__ = 207;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (mu - ((0.5 * get_base1(fixed_d, 1, "fixed_d", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
                current_statement_begin__ = 208;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            (mu + ((0.5 * get_base1(fixed_d, 1, "fixed_d", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
            }

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 189;
            if (stan::math::is_uninitialized(pooled_sigma)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pooled_sigma";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable pooled_sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 190;
            size_t sigma_i_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < sigma_i_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sigma_i(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_i" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_i: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 191;
            size_t mu_i_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < mu_i_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu_i(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu_i" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu_i: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }

            // model body

            current_statement_begin__ = 213;
            lp_accum__.add(Jeffreys_mu_lpdf(mu, pstream__));
            current_statement_begin__ = 214;
            lp_accum__.add(Jeffreys_sigma_lpdf(sigma2, pstream__));
            current_statement_begin__ = 217;
            if (as_bool(logical_eq(is_d, 1))) {

                current_statement_begin__ = 218;
                lp_accum__.add(set_prior(get_base1(delta, 1, "delta", 1), prior_type_d, prior_parameters_d, bounds_type_d, bounds_d, pstream__));
            }
            current_statement_begin__ = 220;
            if (as_bool(logical_eq(is_r, 1))) {

                current_statement_begin__ = 221;
                lp_accum__.add(set_prior(get_base1(rho, 1, "rho", 1), prior_type_r, prior_parameters_r, bounds_type_r, bounds_r, pstream__));
            }
            current_statement_begin__ = 225;
            if (as_bool(logical_eq(is_ss, 0))) {

                current_statement_begin__ = 226;
                lp_accum__.add(normal_log(x1, get_base1(mu_i, 1, "mu_i", 1), get_base1(sigma_i, 1, "sigma_i", 1)));
                current_statement_begin__ = 227;
                lp_accum__.add(normal_log(x2, get_base1(mu_i, 2, "mu_i", 1), get_base1(sigma_i, 2, "sigma_i", 1)));
            } else {

                current_statement_begin__ = 229;
                lp_accum__.add((((-(N1) / 2.0) * stan::math::log(((2 * stan::math::pi()) * pow(get_base1(sigma_i, 1, "sigma_i", 1), 2)))) - ((1 / (2 * pow(get_base1(sigma_i, 1, "sigma_i", 1), 2))) * (((N1 - 1) * pow(get_base1(sd_i, 1, "sd_i", 1), 2)) + (N1 * pow((get_base1(mean_i, 1, "mean_i", 1) - get_base1(mu_i, 1, "mu_i", 1)), 2))))));
                current_statement_begin__ = 230;
                lp_accum__.add((((-(N2) / 2.0) * stan::math::log(((2 * stan::math::pi()) * pow(get_base1(sigma_i, 2, "sigma_i", 1), 2)))) - ((1 / (2 * pow(get_base1(sigma_i, 2, "sigma_i", 1), 2))) * (((N2 - 1) * pow(get_base1(sd_i, 2, "sd_i", 1), 2)) + (N2 * pow((get_base1(mean_i, 2, "mean_i", 1) - get_base1(mu_i, 2, "mu_i", 1)), 2))))));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("sigma2");
        names__.push_back("delta");
        names__.push_back("rho");
        names__.push_back("pooled_sigma");
        names__.push_back("sigma_i");
        names__.push_back("mu_i");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_d);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(is_r);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_normal_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        double mu = in__.scalar_constrain();
        vars__.push_back(mu);

        double sigma2 = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma2);

        std::vector<double> delta;
        size_t delta_d_0_max__ = is_d;
        delta.reserve(delta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < delta_d_0_max__; ++d_0__) {
            delta.push_back(in__.scalar_lub_constrain(coefs_lb(get_base1(bounds_type_d, 1, "bounds_type_d", 1), get_base1(bounds_d, 1, "bounds_d", 1), pstream__), coefs_ub(get_base1(bounds_type_d, 2, "bounds_type_d", 1), get_base1(bounds_d, 2, "bounds_d", 1), pstream__)));
        }
        size_t delta_k_0_max__ = is_d;
        for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
            vars__.push_back(delta[k_0__]);
        }

        std::vector<double> rho;
        size_t rho_d_0_max__ = is_r;
        rho.reserve(rho_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
            rho.push_back(in__.scalar_lub_constrain(coefs_lb(get_base1(bounds_type_r, 1, "bounds_type_r", 1), get_base1(bounds_r, 1, "bounds_r", 1), pstream__), coefs_ub(get_base1(bounds_type_r, 2, "bounds_type_r", 1), get_base1(bounds_r, 2, "bounds_r", 1), pstream__)));
        }
        size_t rho_k_0_max__ = is_r;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 189;
            double pooled_sigma;
            (void) pooled_sigma;  // dummy to suppress unused var warning
            stan::math::initialize(pooled_sigma, DUMMY_VAR__);
            stan::math::fill(pooled_sigma, DUMMY_VAR__);

            current_statement_begin__ = 190;
            validate_non_negative_index("sigma_i", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_i(2);
            stan::math::initialize(sigma_i, DUMMY_VAR__);
            stan::math::fill(sigma_i, DUMMY_VAR__);

            current_statement_begin__ = 191;
            validate_non_negative_index("mu_i", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu_i(2);
            stan::math::initialize(mu_i, DUMMY_VAR__);
            stan::math::fill(mu_i, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 194;
            if (as_bool(logical_eq(is_r, 1))) {

                current_statement_begin__ = 195;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * get_base1(rho, 1, "rho", 1)))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 196;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - get_base1(rho, 1, "rho", 1))))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 197;
                stan::math::assign(pooled_sigma, pool_sigma(get_base1(sigma_i, 1, "sigma_i", 1), get_base1(sigma_i, 2, "sigma_i", 1), N1, N2, pstream__));
            } else {

                current_statement_begin__ = 199;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * get_base1(fixed_r, 1, "fixed_r", 1)))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 200;
                stan::model::assign(sigma_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            stan::math::sqrt((1 / (((2 * 1) / sigma2) * (1 - get_base1(fixed_r, 1, "fixed_r", 1))))), 
                            "assigning variable sigma_i");
                current_statement_begin__ = 201;
                stan::math::assign(pooled_sigma, pool_sigma(get_base1(sigma_i, 1, "sigma_i", 1), get_base1(sigma_i, 2, "sigma_i", 1), N1, N2, pstream__));
            }
            current_statement_begin__ = 203;
            if (as_bool(logical_eq(is_d, 1))) {

                current_statement_begin__ = 204;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (mu - ((0.5 * get_base1(delta, 1, "delta", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
                current_statement_begin__ = 205;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            (mu + ((0.5 * get_base1(delta, 1, "delta", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
            } else {

                current_statement_begin__ = 207;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (mu - ((0.5 * get_base1(fixed_d, 1, "fixed_d", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
                current_statement_begin__ = 208;
                stan::model::assign(mu_i, 
                            stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                            (mu + ((0.5 * get_base1(fixed_d, 1, "fixed_d", 1)) * pooled_sigma)), 
                            "assigning variable mu_i");
            }

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(pooled_sigma);
                size_t sigma_i_j_1_max__ = 2;
                for (size_t j_1__ = 0; j_1__ < sigma_i_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma_i(j_1__));
                }
                size_t mu_i_j_1_max__ = 2;
                for (size_t j_1__ = 0; j_1__ < mu_i_j_1_max__; ++j_1__) {
                    vars__.push_back(mu_i(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    std::string model_name() const {
        return "model_normal";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma2";
        param_names__.push_back(param_name_stream__.str());
        size_t delta_k_0_max__ = is_d;
        for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = is_r;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pooled_sigma";
            param_names__.push_back(param_name_stream__.str());
            size_t sigma_i_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < sigma_i_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_i" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_i_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < mu_i_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_i" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma2";
        param_names__.push_back(param_name_stream__.str());
        size_t delta_k_0_max__ = is_d;
        for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = is_r;
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pooled_sigma";
            param_names__.push_back(param_name_stream__.str());
            size_t sigma_i_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < sigma_i_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_i" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_i_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < mu_i_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_i" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }

}; // model

}  // namespace

typedef model_normal_namespace::model_normal stan_model;

#ifndef USING_R

stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}

#endif


#endif
