% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INVTR2.R
\name{INVTR2}
\alias{INVTR2}
\title{Robust R^2 coefficient of determination}
\usage{
INVTR2(RR2, family, cc)
}
\arguments{
\item{RR2}{the proportional difference in loss functions (a naive robust R^2 coefficient).}

\item{family}{family string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "opt" and "mopt").}

\item{cc}{tuning parameters to be computed according to efficiency and / or breakdown
considerations. See \link{lmrobdet.control}, \link{bisquare}, \link{mopt}
and \link{opt}.}
}
\value{
An unbiased version of the robust R^2 coefficient of determination.
}
\description{
This function computes a robust version of the R^2 coefficient of determination.
It is used internally by \code{\link{lmrobdetMM}},
and not meant to be used directly.
}
\details{
This function computes a robust version of the R^2 coefficient.
It is used internally by \code{\link{lmrobdetMM}},
and not meant to be used directly.
}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}
}
