% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLocDis.R
\name{locScaleM}
\alias{locScaleM}
\alias{MLocDis}
\title{Robust univariate location and scale M-estimators}
\usage{
locScaleM(x, psi = "mopt", eff = 0.95, maxit = 50, tol = 1e-04,
  na.rm = FALSE)
}
\arguments{
\item{x}{a vector of univariate observations}

\item{psi}{a string indicating which score function to use. Valid options are "bisquare", "huber",
"opt" and "mopt".}

\item{eff}{desired asymptotic efficiency. Valid options are 0.85, 0.9 and 0.95 (default) when
\code{psi} = "bisquare" or "huber", and 0.85, 0.9, 0.95 (default) and 0.99 when
\code{psi} = "opt" or "mopt".}

\item{maxit}{maximum number of iterations allowed.}

\item{tol}{tolerance to decide convergence of the iterative algorithm.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before
the computation proceeds. Defaults to \code{FALSE}}
}
\value{
A list with the following components:
\item{mu}{The location estimate}
\item{std.mu}{Estimated standard deviation of the location estimator \code{mu}}
\item{disper}{M-scale/dispersion estimate}
}
\description{
This function computes M-estimators for location and scale.
}
\details{
This function computes M-estimators for location and scale.
}
\examples{
set.seed(123)
r <- rnorm(150, sd=1.5)
locScaleM(r)
# 10\% of outliers, sd of good points is 1.5
set.seed(123)
r2 <- c(rnorm(135, sd=1.5), rnorm(15, mean=-10, sd=.5))
locScaleM(r2)

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Ricardo Maronna, \email{rmaronna@retina.ar}
}
