\name{RI.indiscernibilityBasedRules.RST}
\alias{RI.indiscernibilityBasedRules.RST}
\title{Rule induction based on RST}
\usage{
RI.indiscernibilityBasedRules.RST(decision.table, feature.set)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{feature.set}{a \code{"FeatureSubset"} class which
  is produced by feature selection functions based on RST
  e.g. \code{\link{FS.permutation.heuristic.reduct.RST}},
  etc.

  See \code{\link{FS.reduct.computation}},
  \code{\link{FS.feature.subset.computation}}, and

  \code{\link{FS.all.reducts.computation}} based on RST.}
}
\value{
A class \code{"RuleSetRST"} containing the following
components/attributes: \itemize{ \item \code{rules}: every
rule which is a list consisting of five parts as follows:
\itemize{ \item \code{idx}: it is a vector of indexes of
attributes involved in each rule.  \item \code{values}: it
is a vector of values of each attributes used as the
antecedent part.  \item \code{consequent}: it is a vector
of a value of decision attribute as the consequent part.
\item \code{support}: it is a numeric value representing
the support value of each rule.  \item \code{laplace}: it
is a numeric value representing the laplace value of the
consequent part.  } \item \code{uniqueCls}: it is a vector
containing the decision classes.  \item \code{clsProbs}: it
is vector showing the probability of the decision classes.
\item \code{majorityCls}: it is a value representing the
majority value in the rules.  \item \code{method}: it is
the type of used method. In this case, it is
\code{"indiscernibilityBasedRules"}. }
}
\description{
It is a function generating rule induction based on
indiscernibility classes.
}
\details{
Basically, this function uses the output of feature
selection step as input data. So, before calling this
function, we execute a particular function implementing
feature selection,

e.g. \code{\link{FS.permutation.heuristic.reduct.RST}}.

It should be noted that this function only allows
classification problems. After obtaining the rules,
predicting can be done by calling \code{predict} or
\code{\link{predict.RuleSetRST}}.
}
\examples{
###########################################################
## Example
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## determine feature subset/reduct
reduct <- FS.permutation.heuristic.reduct.RST(decision.table,  permutation = NULL)

rules <- RI.indiscernibilityBasedRules.RST(decision.table, reduct)
}
\seealso{
\code{\link{predict.RuleSetFRST}},
\code{\link{RI.GFRS.FRST}}, and
\code{\link{RI.hybridFS.FRST}}.
}

