% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_table_graphic.R
\name{create_table_graphic}
\alias{create_table_graphic}
\title{create_table_graphic}
\usage{
create_table_graphic(
  df = NULL,
  table_width = 8,
  head_color = "black",
  head_fill = "white",
  head_font_sz = 14,
  cell_color = "black",
  cell_fill = "white",
  cell_font_sz = 11,
  cell_just = "center",
  cell_hor_pos = 0.5,
  title = NULL,
  title_font_sz = 16,
  show_row_names = TRUE,
  row_names_width = 0.5,
  return_gtable = FALSE
)
}
\arguments{
\item{df}{The target data frame from which to graph.}

\item{table_width}{The overall table width in inches.}

\item{head_color}{Color of the headings foreground.}

\item{head_fill}{Color of the headings background.}

\item{head_font_sz}{Font size of the headings.}

\item{cell_color}{Color of the cells foreground.}

\item{cell_fill}{Color of the cells background.}

\item{cell_font_sz}{Font size of the cells.}

\item{cell_just}{An string that sets justification of the cell content. Acceptable values are "left" and "right" and "center".}

\item{cell_hor_pos}{A numeric that sets the starting horizontal location of text in a cell. Acceptable range from 0.0 to 1.0.}

\item{title}{A string that sets the table title.}

\item{title_font_sz}{Font size of the title.}

\item{show_row_names}{A logical that controls the appearance of row names in the data frame.}

\item{row_names_width}{The width of the column for row names in inches.}

\item{return_gtable}{A logical which if \code{TRUE} returns a gtable/grob of the table.
The default is to return a ggplot class object.}
}
\value{
A gtable or ggplot class object.
}
\description{
Function creates a ggplot2 graphic table from a data frame.
 Function creates a simple, non-scrollable static table to be laid out with other ggplot2 graphics.  The
 function is based on \code{grid} along with the \code{gtable} package.

 For estimating the overall height of the table consider that each row of the table is 0.2 inches high, .54 inches for heading and
 if a title is defined then add an additional 0.5 inches.
}
\examples{
library(grid)
library(gtable)
library(ggplotify)
library(RplotterPkg)

RplotterPkg::create_table_graphic(
  df = RplotterPkg::car_stats,
  table_width = 7,
  show_row_names = TRUE,
  cell_just = "right",
  cell_hor_pos = 0.95,
  title = "Average Measures by Cylinders"
)

}
