% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_daggers.R
\name{coverage_daggers}
\alias{coverage_daggers}
\title{Dagger or double dagger according to coverage level}
\usage{
coverage_daggers(res_df, one_dagger = 75, two_dagger = 50)
}
\arguments{
\item{res_df}{(data frame) Rrepest output with columns for coverage (cvge)}

\item{one_dagger}{(numeric) Level at which the coverage is transformed into a dagger. 75 by default.}

\item{two_dagger}{(numeric) Level at which the coverage is transformed into a double dagger. 50 by default}
}
\value{
Dataframe with daggers or double daggers in coverage column
}
\description{
Transform coverage columns in Rrepest to dagger and double dagger according
to the coverage (cvge) column. Default levels are 75 (dagger) and 50 (double dagger).
If coverage is above both levels, no symbol is produced (empty). Used with the coverage o
option in Rrepest set to TRUE to produce columns with coverage percentages.
}
\examples{
cvge_data <- Rrepest(df_talis18, est = est("freq", "tt3g23o"), 
svy = "TALISTCH", by = "cntry", coverage = TRUE)
coverage_daggers(cvge_data, one_dagger = 95, two_dagger = 90)
}
