besselap <- function(n) {
  if (n > 25 | n < 1) stop('Bessel filter roots only available for order 0 < n < 25.')
  
  k <- 1
  z <- NULL
  # table method
  i <- complex(i = 1)
  p <- switch(n,
         -1,
         c(-.8660254037844386467637229+.4999999999999999999999996*i,
           -.8660254037844386467637229-.4999999999999999999999996*i),
         c(-.9416000265332067855971980,
           -.7456403858480766441810907-.7113666249728352680992154*i,
           -.7456403858480766441810907+.7113666249728352680992154*i),
         c(-.6572111716718829545787781-.8301614350048733772399715*i,
           -.6572111716718829545787788+.8301614350048733772399715*i,
           -.9047587967882449459642637-.2709187330038746636700923*i,
           -.9047587967882449459642624+.2709187330038746636700926*i),
         c(-.9264420773877602247196260,
           -.8515536193688395541722677-.4427174639443327209850002*i,
           -.8515536193688395541722677+.4427174639443327209850002*i,
           -.5905759446119191779319432-.9072067564574549539291747*i,
           -.5905759446119191779319432+.9072067564574549539291747*i),
         c(-.9093906830472271808050953-.1856964396793046769246397*i,
           -.9093906830472271808050953+.1856964396793046769246397*i,
           -.7996541858328288520243325-.5621717346937317988594118*i,
           -.7996541858328288520243325+.5621717346937317988594118*i,
           -.5385526816693109683073792-.9616876881954277199245657*i,
           -.5385526816693109683073792+.9616876881954277199245657*i),
         c(-.9194871556490290014311619,
           -.8800029341523374639772340-.3216652762307739398381830*i,
           -.8800029341523374639772340+.3216652762307739398381830*i,
           -.7527355434093214462291616-.6504696305522550699212995*i,
           -.7527355434093214462291616+.6504696305522550699212995*i,
           -.4966917256672316755024763-1.002508508454420401230220*i,
           -.4966917256672316755024763+1.002508508454420401230220*i),
         c(-.9096831546652910216327629-.1412437976671422927888150*i,
           -.9096831546652910216327629+.1412437976671422927888150*i,
           -.8473250802359334320103023-.4259017538272934994996429*i,
           -.8473250802359334320103023+.4259017538272934994996429*i,
           -.7111381808485399250796172-.7186517314108401705762571*i,
           -.7111381808485399250796172+.7186517314108401705762571*i,
           -.4621740412532122027072175-1.034388681126901058116589*i,
           -.4621740412532122027072175+1.034388681126901058116589*i),
         c(-.9154957797499037686769223,
           -.8911217017079759323183848-.2526580934582164192308115*i,
           -.8911217017079759323183848+.2526580934582164192308115*i,
           -.8148021112269012975514135-.5085815689631499483745341*i,
           -.8148021112269012975514135+.5085815689631499483745341*i,
           -.6743622686854761980403401-.7730546212691183706919682*i,
           -.6743622686854761980403401+.7730546212691183706919682*i,
           -.4331415561553618854685942-1.060073670135929666774323*i,
           -.4331415561553618854685942+1.060073670135929666774323*i),
         c(-.9091347320900502436826431-.1139583137335511169927714*i,
           -.9091347320900502436826431+.1139583137335511169927714*i,
           -.8688459641284764527921864-.3430008233766309973110589*i,
           -.8688459641284764527921864+.3430008233766309973110589*i,
           -.7837694413101441082655890-.5759147538499947070009852*i,
           -.7837694413101441082655890+.5759147538499947070009852*i,
           -.6417513866988316136190854-.8175836167191017226233947*i,
           -.6417513866988316136190854+.8175836167191017226233947*i,
           -.4083220732868861566219785-1.081274842819124562037210*i,
           -.4083220732868861566219785+1.081274842819124562037210*i),
         c(-.9129067244518981934637318,
           -.8963656705721166099815744-.2080480375071031919692341*i,
           -.8963656705721166099815744+.2080480375071031919692341*i,
           -.8453044014712962954184557-.4178696917801248292797448*i,
           -.8453044014712962954184557+.4178696917801248292797448*i,
           -.7546938934722303128102142-.6319150050721846494520941*i,
           -.7546938934722303128102142+.6319150050721846494520941*i,
           -.6126871554915194054182909-.8547813893314764631518509*i,
           -.6126871554915194054182909+.8547813893314764631518509*i,
           -.3868149510055090879155425-1.099117466763120928733632*i,
           -.3868149510055090879155425+1.099117466763120928733632*i),
         c(-.9084478234140682638817772-95506365213450398415258360.0E-27*i,
           -.9084478234140682638817772+95506365213450398415258360.0E-27*i,
           -.8802534342016826507901575-.2871779503524226723615457*i,
           -.8802534342016826507901575+.2871779503524226723615457*i,
           -.8217296939939077285792834-.4810212115100676440620548*i,
           -.8217296939939077285792834+.4810212115100676440620548*i,
           -.7276681615395159454547013-.6792961178764694160048987*i,
           -.7276681615395159454547013+.6792961178764694160048987*i,
           -.5866369321861477207528215-.8863772751320727026622149*i,
           -.5866369321861477207528215+.8863772751320727026622149*i,
           -.3679640085526312839425808-1.114373575641546257595657*i,
           -.3679640085526312839425808+1.114373575641546257595657*i),
         c(-.9110914665984182781070663,
           -.8991314665475196220910718-.1768342956161043620980863*i,
           -.8991314665475196220910718+.1768342956161043620980863*i,
           -.8625094198260548711573628-.3547413731172988997754038*i,
           -.8625094198260548711573628+.3547413731172988997754038*i,
           -.7987460692470972510394686-.5350752120696801938272504*i,
           -.7987460692470972510394686+.5350752120696801938272504*i,
           -.7026234675721275653944062-.7199611890171304131266374*i,
           -.7026234675721275653944062+.7199611890171304131266374*i,
           -.5631559842430199266325818-.9135900338325109684927731*i,
           -.5631559842430199266325818+.9135900338325109684927731*i,
           -.3512792323389821669401925-1.127591548317705678613239*i,
           -.3512792323389821669401925+1.127591548317705678613239*i),
         c(-.9077932138396487614720659-82196399419401501888968130.0E-27*i,
           -.9077932138396487614720659+82196399419401501888968130.0E-27*i,
           -.8869506674916445312089167-.2470079178765333183201435*i,
           -.8869506674916445312089167+.2470079178765333183201435*i,
           -.8441199160909851197897667-.4131653825102692595237260*i,
           -.8441199160909851197897667+.4131653825102692595237260*i,
           -.7766591387063623897344648-.5819170677377608590492434*i,
           -.7766591387063623897344648+.5819170677377608590492434*i,
           -.6794256425119233117869491-.7552857305042033418417492*i,
           -.6794256425119233117869491+.7552857305042033418417492*i,
           -.5418766775112297376541293-.9373043683516919569183099*i,
           -.5418766775112297376541293+.9373043683516919569183099*i,
           -.3363868224902037330610040-1.139172297839859991370924*i,
           -.3363868224902037330610040+1.139172297839859991370924*i),
         c(-.9097482363849064167228581,
           -.9006981694176978324932918-.1537681197278439351298882*i,
           -.9006981694176978324932918+.1537681197278439351298882*i,
           -.8731264620834984978337843-.3082352470564267657715883*i,
           -.8731264620834984978337843+.3082352470564267657715883*i,
           -.8256631452587146506294553-.4642348752734325631275134*i,
           -.8256631452587146506294553+.4642348752734325631275134*i,
           -.7556027168970728127850416-.6229396358758267198938604*i,
           -.7556027168970728127850416+.6229396358758267198938604*i,
           -.6579196593110998676999362-.7862895503722515897065645*i,
           -.6579196593110998676999362+.7862895503722515897065645*i,
           -.5224954069658330616875186-.9581787261092526478889345*i,
           -.5224954069658330616875186+.9581787261092526478889345*i,
           -.3229963059766444287113517-1.149416154583629539665297*i,
           -.3229963059766444287113517+1.149416154583629539665297*i),
         c(-.9072099595087001356491337-72142113041117326028823950.0E-27*i,
           -.9072099595087001356491337+72142113041117326028823950.0E-27*i,
           -.8911723070323647674780132-.2167089659900576449410059*i,
           -.8911723070323647674780132+.2167089659900576449410059*i,
           -.8584264231521330481755780-.3621697271802065647661080*i,
           -.8584264231521330481755780+.3621697271802065647661080*i,
           -.8074790293236003885306146-.5092933751171800179676218*i,
           -.8074790293236003885306146+.5092933751171800179676218*i,
           -.7356166304713115980927279-.6591950877860393745845254*i,
           -.7356166304713115980927279+.6591950877860393745845254*i,
           -.6379502514039066715773828-.8137453537108761895522580*i,
           -.6379502514039066715773828+.8137453537108761895522580*i,
           -.5047606444424766743309967-.9767137477799090692947061*i,
           -.5047606444424766743309967+.9767137477799090692947061*i,
           -.3108782755645387813283867-1.158552841199330479412225*i,
           -.3108782755645387813283867+1.158552841199330479412225*i),
         c(-.9087141161336397432860029,
           -.9016273850787285964692844-.1360267995173024591237303*i,
           -.9016273850787285964692844+.1360267995173024591237303*i,
           -.8801100704438627158492165-.2725347156478803885651973*i,
           -.8801100704438627158492165+.2725347156478803885651973*i,
           -.8433414495836129204455491-.4100759282910021624185986*i,
           -.8433414495836129204455491+.4100759282910021624185986*i,
           -.7897644147799708220288138-.5493724405281088674296232*i,
           -.7897644147799708220288138+.5493724405281088674296232*i,
           -.7166893842372349049842743-.6914936286393609433305754*i,
           -.7166893842372349049842743+.6914936286393609433305754*i,
           -.6193710717342144521602448-.8382497252826992979368621*i,
           -.6193710717342144521602448+.8382497252826992979368621*i,
           -.4884629337672704194973683-.9932971956316781632345466*i,
           -.4884629337672704194973683+.9932971956316781632345466*i,
           -.2998489459990082015466971-1.166761272925668786676672*i,
           -.2998489459990082015466971+1.166761272925668786676672*i),
         c(-.9067004324162775554189031-64279241063930693839360680.0E-27*i,
           -.9067004324162775554189031+64279241063930693839360680.0E-27*i,
           -.8939764278132455733032155-.1930374640894758606940586*i,
           -.8939764278132455733032155+.1930374640894758606940586*i,
           -.8681095503628830078317207-.3224204925163257604931634*i,
           -.8681095503628830078317207+.3224204925163257604931634*i,
           -.8281885016242836608829018-.4529385697815916950149364*i,
           -.8281885016242836608829018+.4529385697815916950149364*i,
           -.7726285030739558780127746-.5852778162086640620016316*i,
           -.7726285030739558780127746+.5852778162086640620016316*i,
           -.6987821445005273020051878-.7204696509726630531663123*i,
           -.6987821445005273020051878+.7204696509726630531663123*i,
           -.6020482668090644386627299-.8602708961893664447167418*i,
           -.6020482668090644386627299+.8602708961893664447167418*i,
           -.4734268069916151511140032-1.008234300314801077034158*i,
           -.4734268069916151511140032+1.008234300314801077034158*i,
           -.2897592029880489845789953-1.174183010600059128532230*i,
           -.2897592029880489845789953+1.174183010600059128532230*i),
         c(-.9078934217899404528985092,
           -.9021937639390660668922536-.1219568381872026517578164*i,
           -.9021937639390660668922536+.1219568381872026517578164*i,
           -.8849290585034385274001112-.2442590757549818229026280*i,
           -.8849290585034385274001112+.2442590757549818229026280*i,
           -.8555768765618421591093993-.3672925896399872304734923*i,
           -.8555768765618421591093993+.3672925896399872304734923*i,
           -.8131725551578197705476160-.4915365035562459055630005*i,
           -.8131725551578197705476160+.4915365035562459055630005*i,
           -.7561260971541629355231897-.6176483917970178919174173*i,
           -.7561260971541629355231897+.6176483917970178919174173*i,
           -.6818424412912442033411634-.7466272357947761283262338*i,
           -.6818424412912442033411634+.7466272357947761283262338*i,
           -.5858613321217832644813602-.8801817131014566284786759*i,
           -.5858613321217832644813602+.8801817131014566284786759*i,
           -.4595043449730988600785456-1.021768776912671221830298*i,
           -.4595043449730988600785456+1.021768776912671221830298*i,
           -.2804866851439370027628724-1.180931628453291873626003*i,
           -.2804866851439370027628724+1.180931628453291873626003*i),
         c(-.9062570115576771146523497-57961780277849516990208850.0E-27*i,
           -.9062570115576771146523497+57961780277849516990208850.0E-27*i,
           -.8959150941925768608568248-.1740317175918705058595844*i,
           -.8959150941925768608568248+.1740317175918705058595844*i,
           -.8749560316673332850673214-.2905559296567908031706902*i,
           -.8749560316673332850673214+.2905559296567908031706902*i,
           -.8427907479956670633544106-.4078917326291934082132821*i,
           -.8427907479956670633544106+.4078917326291934082132821*i,
           -.7984251191290606875799876-.5264942388817132427317659*i,
           -.7984251191290606875799876+.5264942388817132427317659*i,
           -.7402780309646768991232610-.6469975237605228320268752*i,
           -.7402780309646768991232610+.6469975237605228320268752*i,
           -.6658120544829934193890626-.7703721701100763015154510*i,
           -.6658120544829934193890626+.7703721701100763015154510*i,
           -.5707026806915714094398061-.8982829066468255593407161*i,
           -.5707026806915714094398061+.8982829066468255593407161*i,
           -.4465700698205149555701841-1.034097702560842962315411*i,
           -.4465700698205149555701841+1.034097702560842962315411*i,
           -.2719299580251652601727704-1.187099379810885886139638*i,
           -.2719299580251652601727704+1.187099379810885886139638*i),
         c(-.9072262653142957028884077,
           -.9025428073192696303995083-.1105252572789856480992275*i,
           -.9025428073192696303995083+.1105252572789856480992275*i,
           -.8883808106664449854431605-.2213069215084350419975358*i,
           -.8883808106664449854431605+.2213069215084350419975358*i,
           -.8643915813643204553970169-.3326258512522187083009453*i,
           -.8643915813643204553970169+.3326258512522187083009453*i,
           -.8299435470674444100273463-.4448177739407956609694059*i,
           -.8299435470674444100273463+.4448177739407956609694059*i,
           -.7840287980408341576100581-.5583186348022854707564856*i,
           -.7840287980408341576100581+.5583186348022854707564856*i,
           -.7250839687106612822281339-.6737426063024382240549898*i,
           -.7250839687106612822281339+.6737426063024382240549898*i,
           -.6506315378609463397807996-.7920349342629491368548074*i,
           -.6506315378609463397807996+.7920349342629491368548074*i,
           -.5564766488918562465935297-.9148198405846724121600860*i,
           -.5564766488918562465935297+.9148198405846724121600860*i,
           -.4345168906815271799687308-1.045382255856986531461592*i,
           -.4345168906815271799687308+1.045382255856986531461592*i,
           -.2640041595834031147954813-1.192762031948052470183960*i,
           -.2640041595834031147954813+1.192762031948052470183960*i),
         c(-.9058702269930872551848625-52774908289999045189007100.0E-27*i,
           -.9058702269930872551848625+52774908289999045189007100.0E-27*i,
           -.8972983138153530955952835-.1584351912289865608659759*i,
           -.8972983138153530955952835+.1584351912289865608659759*i,
           -.8799661455640176154025352-.2644363039201535049656450*i,
           -.8799661455640176154025352+.2644363039201535049656450*i,
           -.8534754036851687233084587-.3710389319482319823405321*i,
           -.8534754036851687233084587+.3710389319482319823405321*i,
           -.8171682088462720394344996-.4785619492202780899653575*i,
           -.8171682088462720394344996+.4785619492202780899653575*i,
           -.7700332930556816872932937-.5874255426351153211965601*i,
           -.7700332930556816872932937+.5874255426351153211965601*i,
           -.7105305456418785989070935-.6982266265924524000098548*i,
           -.7105305456418785989070935+.6982266265924524000098548*i,
           -.6362427683267827226840153-.8118875040246347267248508*i,
           -.6362427683267827226840153+.8118875040246347267248508*i,
           -.5430983056306302779658129-.9299947824439872998916657*i,
           -.5430983056306302779658129+.9299947824439872998916657*i,
           -.4232528745642628461715044-1.055755605227545931204656*i,
           -.4232528745642628461715044+1.055755605227545931204656*i,
           -.2566376987939318038016012-1.197982433555213008346532*i,
           -.2566376987939318038016012+1.197982433555213008346532*i),
         c(-.9066732476324988168207439,
           -.9027564979912504609412993-.1010534335314045013252480*i,
           -.9027564979912504609412993+.1010534335314045013252480*i,
           -.8909283242471251458653994-.2023024699381223418195228*i,
           -.8909283242471251458653994+.2023024699381223418195228*i,
           -.8709469395587416239596874-.3039581993950041588888925*i,
           -.8709469395587416239596874+.3039581993950041588888925*i,
           -.8423805948021127057054288-.4062657948237602726779246*i,
           -.8423805948021127057054288+.4062657948237602726779246*i,
           -.8045561642053176205623187-.5095305912227258268309528*i,
           -.8045561642053176205623187+.5095305912227258268309528*i,
           -.7564660146829880581478138-.6141594859476032127216463*i,
           -.7564660146829880581478138+.6141594859476032127216463*i,
           -.6965966033912705387505040-.7207341374753046970247055*i,
           -.6965966033912705387505040+.7207341374753046970247055*i,
           -.6225903228771341778273152-.8301558302812980678845563*i,
           -.6225903228771341778273152+.8301558302812980678845563*i,
           -.5304922463810191698502226-.9439760364018300083750242*i,
           -.5304922463810191698502226+.9439760364018300083750242*i,
           -.4126986617510148836149955-1.065328794475513585531053*i,
           -.4126986617510148836149955+1.065328794475513585531053*i,
           -.2497697202208956030229911-1.202813187870697831365338*i,
           -.2497697202208956030229911+1.202813187870697831365338*i),
         c(-.9055312363372773709269407-48440066540478700874836350.0E-27*i,
           -.9055312363372773709269407+48440066540478700874836350.0E-27*i,
           -.8983105104397872954053307-.1454056133873610120105857*i,
           -.8983105104397872954053307+.1454056133873610120105857*i,
           -.8837358034555706623131950-.2426335234401383076544239*i,
           -.8837358034555706623131950+.2426335234401383076544239*i,
           -.8615278304016353651120610-.3403202112618624773397257*i,
           -.8615278304016353651120610+.3403202112618624773397257*i,
           -.8312326466813240652679563-.4386985933597305434577492*i,
           -.8312326466813240652679563+.4386985933597305434577492*i,
           -.7921695462343492518845446-.5380628490968016700338001*i,
           -.7921695462343492518845446+.5380628490968016700338001*i,
           -.7433392285088529449175873-.6388084216222567930378296*i,
           -.7433392285088529449175873+.6388084216222567930378296*i,
           -.6832565803536521302816011-.7415032695091650806797753*i,
           -.6832565803536521302816011+.7415032695091650806797753*i,
           -.6096221567378335562589532-.8470292433077202380020454*i,
           -.6096221567378335562589532+.8470292433077202380020454*i,
           -.5185914574820317343536707-.9569048385259054576937721*i,
           -.5185914574820317343536707+.9569048385259054576937721*i,
           -.4027853855197518014786978-1.074195196518674765143729*i,
           -.4027853855197518014786978+1.074195196518674765143729*i,
           -.2433481337524869675825448-1.207298683731972524975429*i,
           -.2433481337524869675825448+1.207298683731972524975429*i),
         c(-.9062073871811708652496104,
           -.9028833390228020537142561-93077131185102967450643820.0E-27*i,
           -.9028833390228020537142561+93077131185102967450643820.0E-27*i,
           -.8928551459883548836774529-.1863068969804300712287138*i,
           -.8928551459883548836774529+.1863068969804300712287138*i,
           -.8759497989677857803656239-.2798521321771408719327250*i,
           -.8759497989677857803656239+.2798521321771408719327250*i,
           -.8518616886554019782346493-.3738977875907595009446142*i,
           -.8518616886554019782346493+.3738977875907595009446142*i,
           -.8201226043936880253962552-.4686668574656966589020580*i,
           -.8201226043936880253962552+.4686668574656966589020580*i,
           -.7800496278186497225905443-.5644441210349710332887354*i,
           -.7800496278186497225905443+.5644441210349710332887354*i,
           -.7306549271849967721596735-.6616149647357748681460822*i,
           -.7306549271849967721596735+.6616149647357748681460822*i,
           -.6704827128029559528610523-.7607348858167839877987008*i,
           -.6704827128029559528610523+.7607348858167839877987008*i,
           -.5972898661335557242320528-.8626676330388028512598538*i,
           -.5972898661335557242320528+.8626676330388028512598538*i,
           -.5073362861078468845461362-.9689006305344868494672405*i,
           -.5073362861078468845461362+.9689006305344868494672405*i,
           -.3934529878191079606023847-1.082433927173831581956863*i,
           -.3934529878191079606023847+1.082433927173831581956863*i,
           -.2373280669322028974199184-1.211476658382565356579418*i,
           -.2373280669322028974199184+1.211476658382565356579418*i)
              )
         
  return(list(p = p, z = z, k = k))
}
