% Generated by roxygen2 (4.0.2): do not edit by hand
\name{vcgIsosurface}
\alias{vcgIsosurface}
\title{Create Isosurface from 3D-array}
\usage{
vcgIsosurface(vol, lower = min(vol), upper = max(vol), spacing = NULL,
  origin = NULL, threshold = 0.5)
}
\arguments{
\item{vol}{an integer valued 3D-array}

\item{lower}{numeric:lower threshold}

\item{upper}{numeric: upper threshold}

\item{spacing}{numeric 3D-vector: specifies the voxel dimensons in x,y,z direction.}

\item{origin}{numeric 3D-vector: origin of the original data set, will transpose the mesh onto that origin.}

\item{threshold}{threshold of intersecting the cube (default is 0.5).}
}
\value{
returns a triangular mesh of class "mesh3d"
}
\description{
Create Isosurface from 3D-array using Marching Cubes algorithm
}
\examples{
#this is the example from the package "misc3d"
x <- seq(-2,2,len=50)
g <- expand.grid(x = x, y = x, z = x)
v <- array(g$x^4 + g$y^4 + g$z^4, rep(length(x),3))
storage.mode(v) <- "integer"
\dontrun{
mesh <- vcgIsosurface(v,lower=1)
require(rgl)
wire3d(mesh)
##now smooth it a little bit
wire3d(vcgSmooth(mesh,"HC",iteration=3),col=3)
}
}

